/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class NodeTasksHillaTest {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String USER_DIR = "user.dir";
    private static String globalUserDirValue;
    private static String globalFrontendDirValue;
    private String userDir;
    private File propertiesDir;
    @Mock
    private EndpointGeneratorTaskFactory endpointGeneratorTaskFactory;
    @Mock
    private TaskGenerateOpenAPI taskGenerateOpenAPI;
    @Mock
    private TaskGenerateEndpoint taskGenerateEndpoint;

    @Before
    public void setup() throws Exception {
        this.userDir = this.temporaryFolder.getRoot().getAbsolutePath();
        System.setProperty(USER_DIR, this.userDir);
        System.clearProperty("vaadin.frontend.folder");
        this.propertiesDir = this.temporaryFolder.newFolder();
    }

    @BeforeClass
    public static void setupBeforeClass() {
        globalUserDirValue = System.getProperty(USER_DIR);
        globalFrontendDirValue = System.getProperty("vaadin.frontend.folder");
    }

    @AfterClass
    public static void tearDownAfterClass() {
        NodeTasksHillaTest.setPropertyIfPresent(USER_DIR, globalUserDirValue);
        NodeTasksHillaTest.setPropertyIfPresent("vaadin.frontend.folder", globalFrontendDirValue);
    }

    private Options createOptions() {
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0])).when((Object)lookup)).lookup(ClassFinder.class);
        File npmFolder = new File(this.userDir);
        return new Options(lookup, npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(new File(this.userDir, "generated/jar-resources")).withFrontendGeneratedFolder(new File(this.userDir)).withBuildResultFolders(npmFolder, npmFolder).setJavaResourceFolder(this.propertiesDir);
    }

    @Test
    public void should_useHillaEngine_whenEnabled() throws ExecutionFailedException, IOException {
        Options options = this.createOptions();
        ((EndpointGeneratorTaskFactory)Mockito.doReturn((Object)this.taskGenerateOpenAPI).when((Object)this.endpointGeneratorTaskFactory)).createTaskGenerateOpenAPI((Options)ArgumentMatchers.any());
        ((EndpointGeneratorTaskFactory)Mockito.doReturn((Object)this.taskGenerateEndpoint).when((Object)this.endpointGeneratorTaskFactory)).createTaskGenerateEndpoint((Options)ArgumentMatchers.any());
        ((Lookup)Mockito.doReturn((Object)this.endpointGeneratorTaskFactory).when((Object)options.getLookup())).lookup(EndpointGeneratorTaskFactory.class);
        try (MockedStatic util = Mockito.mockStatic(FrontendBuildUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            util.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any()), (ClassFinder)((ClassFinder)Mockito.any()))).thenReturn((Object)true);
            new NodeTasks(options).execute();
        }
        this.verifyHillaEngine(true);
    }

    @Test
    public void should_notHillaEngine_whenDisabled() throws ExecutionFailedException, IOException {
        Options options = this.createOptions();
        new NodeTasks(options).execute();
        this.verifyHillaEngine(false);
    }

    private static void setPropertyIfPresent(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        }
    }

    private void verifyHillaEngine(boolean expected) throws ExecutionFailedException {
        ((EndpointGeneratorTaskFactory)Mockito.verify((Object)this.endpointGeneratorTaskFactory, (VerificationMode)(expected ? Mockito.times((int)1) : Mockito.never()))).createTaskGenerateEndpoint((Options)ArgumentMatchers.any());
        ((EndpointGeneratorTaskFactory)Mockito.verify((Object)this.endpointGeneratorTaskFactory, (VerificationMode)(expected ? Mockito.times((int)1) : Mockito.never()))).createTaskGenerateOpenAPI((Options)ArgumentMatchers.any());
        ((TaskGenerateOpenAPI)Mockito.verify((Object)this.taskGenerateOpenAPI, (VerificationMode)(expected ? Mockito.times((int)1) : Mockito.never()))).execute();
        ((TaskGenerateEndpoint)Mockito.verify((Object)this.taskGenerateEndpoint, (VerificationMode)(expected ? Mockito.times((int)1) : Mockito.never()))).execute();
    }
}

