/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ImportExtractor;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ImportExtractorTest {
    @Test
    public void removeComments_blockCommentsAreRemoved() {
        ImportExtractor extractor = new ImportExtractor("/* comment \n sdf \n \n */import 'foo.js';");
        Assert.assertEquals((Object)"import 'foo.js';", (Object)extractor.removeComments());
    }

    @Test
    public void removeComments_lineCommentsAreRemoved() {
        ImportExtractor extractor = new ImportExtractor("// sdfdsf \nimport from 'foo.js';\n //xxxxx \nimport {A}  from bar.js;");
        Assert.assertEquals((Object)"\nimport from 'foo.js';\n \nimport {A}  from bar.js;", (Object)extractor.removeComments());
    }

    @Test
    public void removeComments_blockCommentInsideImport() {
        ImportExtractor extractor = new ImportExtractor("import from /*fdg \n */'foo.js';");
        Assert.assertEquals((Object)"import from 'foo.js';", (Object)extractor.removeComments());
    }

    @Test
    public void removeComments_lineCommentInsideImport() {
        ImportExtractor extractor = new ImportExtractor("import from // xcvxcvcx\n//vcbcvbcv\n 'foo.js';");
        Assert.assertEquals((Object)"import from \n\n 'foo.js';", (Object)extractor.removeComments());
    }

    @Test
    public void getImportsWithBlockComment() {
        ImportExtractor extractor = new ImportExtractor("/* comment \n sdf \n \n */ import /* ddddddd*/'foo.js';");
        List importedPaths = extractor.getImportedPaths();
        Assert.assertEquals((long)1L, (long)importedPaths.size());
        Assert.assertEquals((Object)"foo.js", importedPaths.get(0));
    }

    @Test
    public void getImportsWithLineComments() {
        ImportExtractor extractor = new ImportExtractor("// sdfdsf \n  import from 'foo.js';\n //xxxxx \n import {A} // sdfsf\n from bar.js;");
        List importedPaths = extractor.getImportedPaths();
        Assert.assertEquals((long)2L, (long)importedPaths.size());
        Assert.assertEquals((Object)"foo.js", importedPaths.get(0));
        Assert.assertEquals((Object)"bar.js", importedPaths.get(1));
    }

    @Test
    public void getImport_lineHasNoSemicolon() {
        ImportExtractor extractor = new ImportExtractor("import {A} from 'foo.js'; import from 'bar.js'\n import from 'baz.js'");
        List importedPaths = extractor.getImportedPaths();
        Assert.assertEquals((long)3L, (long)importedPaths.size());
        Assert.assertEquals((Object)"foo.js", importedPaths.get(0));
        Assert.assertEquals((Object)"bar.js", importedPaths.get(1));
        Assert.assertEquals((Object)"baz.js", importedPaths.get(2));
    }

    @Test
    public void getImports_thereAreNoImportsAtAll_noImportsFound() {
        ImportExtractor extractor = new ImportExtractor("const container = document.createElement('template');\n\n        container.innerHTML = `\n            <dom-module id=\"gui-styles\">\n                <template>\n                    <style>\n                        @import url('https://fonts.googleapis.com/css?family=Montserrat:700');\n                    </style>\n                </template>\n            </dom-module>`;\n        document.head.appendChild(container.content);");
        Assert.assertEquals((long)0L, (long)extractor.getImportedPaths().size());
    }

    @Test
    public void getImports_onlyImportAsFirstStatementsAreCounted() {
        ImportExtractor extractor = new ImportExtractor("import {A} from 'foo.js'; \n some text  \n  import from 'ignored.js';");
        List importedPaths = extractor.getImportedPaths();
        Assert.assertEquals((long)1L, (long)importedPaths.size());
        Assert.assertEquals((Object)"foo.js", importedPaths.get(0));
    }
}

