/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GeneratedFilesSupportTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void writeIfChanged_newFilesTracked() throws IOException {
        GeneratedFilesSupport support = new GeneratedFilesSupport();
        File file = new File(this.temporaryFolder.getRoot(), "test.txt");
        Assert.assertTrue((String)"New file should have been written", (boolean)support.writeIfChanged(file, "TEST"));
        Assert.assertEquals((Object)Files.readString(file.toPath()), (Object)"TEST");
        File nested = this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "b", "c.txt")).toFile();
        Assert.assertTrue((String)"New file should have been written", (boolean)support.writeIfChanged(nested, "TEST2"));
        Assert.assertEquals((Object)Files.readString(nested.toPath()), (Object)"TEST2");
        Assert.assertEquals(Set.of(file.toPath().toAbsolutePath(), nested.toPath().toAbsolutePath()), (Object)support.getFiles());
    }

    @Test
    public void writeIfChanged_unchangedFilesTracked() throws IOException {
        GeneratedFilesSupport support = new GeneratedFilesSupport();
        File file = new File(this.temporaryFolder.getRoot(), "test.txt");
        Files.writeString(file.toPath(), (CharSequence)"TEST", new OpenOption[0]);
        Assert.assertFalse((String)"Existing file with same content should not have been overwritten", (boolean)support.writeIfChanged(file, "TEST"));
        Assert.assertEquals((Object)Files.readString(file.toPath()), (Object)"TEST");
        File nested = this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "b", "c.txt")).toFile();
        nested.getParentFile().mkdirs();
        Files.writeString(nested.toPath(), (CharSequence)"TEST2", new OpenOption[0]);
        Assert.assertFalse((String)"Existing file with same content should not have been overwritten", (boolean)support.writeIfChanged(nested, "TEST2"));
        Assert.assertEquals((Object)Files.readString(nested.toPath()), (Object)"TEST2");
        Assert.assertEquals(Set.of(file.toPath().toAbsolutePath(), nested.toPath().toAbsolutePath()), (Object)support.getFiles());
    }

    @Test
    public void writeIfChanged_updatedFilesTracked() throws IOException {
        GeneratedFilesSupport support = new GeneratedFilesSupport();
        File file = new File(this.temporaryFolder.getRoot(), "test.txt");
        Files.writeString(file.toPath(), (CharSequence)"OLD TEST", new OpenOption[0]);
        Assert.assertTrue((String)"Existing file should have been updated", (boolean)support.writeIfChanged(file, "TEST"));
        Assert.assertEquals((Object)Files.readString(file.toPath()), (Object)"TEST");
        File nested = this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "b", "c.txt")).toFile();
        nested.getParentFile().mkdirs();
        Files.writeString(nested.toPath(), (CharSequence)"OLD TEST2", new OpenOption[0]);
        Assert.assertTrue((String)"Existing file should have been updated", (boolean)support.writeIfChanged(nested, "TEST2"));
        Assert.assertEquals((Object)Files.readString(nested.toPath()), (Object)"TEST2");
        Assert.assertEquals(Set.of(file.toPath().toAbsolutePath(), nested.toPath().toAbsolutePath()), (Object)support.getFiles());
    }

    @Test
    public void getFile_filterByRootFolder() throws IOException {
        GeneratedFilesSupport support = new GeneratedFilesSupport();
        File file1 = new File(this.temporaryFolder.getRoot(), "test.txt");
        File file2 = this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "b", "c.txt")).toFile();
        File file3 = this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "z", "n.txt")).toFile();
        File file4 = this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "z", "y.txt")).toFile();
        support.writeIfChanged(file1, "TEST");
        support.writeIfChanged(file2, "TEST");
        support.writeIfChanged(file3, "TEST");
        support.writeIfChanged(file4, "TEST");
        Assert.assertEquals(Set.of(file1.toPath().toAbsolutePath(), file2.toPath().toAbsolutePath(), file3.toPath().toAbsolutePath(), file4.toPath().toAbsolutePath()), (Object)support.getFiles());
        Assert.assertEquals(Set.of(file2.toPath().toAbsolutePath(), file3.toPath().toAbsolutePath(), file4.toPath().toAbsolutePath()), (Object)support.getFiles(this.temporaryFolder.getRoot().toPath().resolve("a")));
        Assert.assertEquals(Set.of(file2.toPath().toAbsolutePath()), (Object)support.getFiles(this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "b"))));
        Assert.assertEquals(Set.of(file3.toPath().toAbsolutePath(), file4.toPath().toAbsolutePath()), (Object)support.getFiles(this.temporaryFolder.getRoot().toPath().resolve(Path.of("a", "z"))));
    }
}

