/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendVersion;
import org.junit.Assert;
import org.junit.Test;

public class FrontendVersionTest {
    @Test
    public void stringParser_returnsExpectedVersions() {
        FrontendVersion frontendVersion = new FrontendVersion("1.0.1");
        this.assertVersion(frontendVersion, 1, 0, 1, "");
        frontendVersion = new FrontendVersion("6.10");
        this.assertVersion(frontendVersion, 6, 10, 0, "");
        frontendVersion = new FrontendVersion("6.10-SNAPSHOT");
        this.assertVersion(frontendVersion, 6, 10, 0, "SNAPSHOT");
        frontendVersion = new FrontendVersion("6.5.3.alpha1");
        this.assertVersion(frontendVersion, 6, 5, 3, "alpha1");
    }

    @Test
    public void versionConstructors_returnExpectedVersions() {
        FrontendVersion frontendVersion = new FrontendVersion(1, 2);
        this.assertVersion(frontendVersion, 1, 2, 0, "");
        frontendVersion = new FrontendVersion(1, 2, 5);
        this.assertVersion(frontendVersion, 1, 2, 5, "");
        frontendVersion = new FrontendVersion(1, 2, 5, "beta3");
        this.assertVersion(frontendVersion, 1, 2, 5, "beta3");
    }

    @Test
    public void testFrontedEquality() {
        FrontendVersion fromString = new FrontendVersion("1.1.0");
        FrontendVersion fromConstructor = new FrontendVersion(1, 1);
        Assert.assertTrue((String)"Parsed string didn't equal constructor", (boolean)fromString.equals((Object)fromConstructor));
        Assert.assertTrue((String)"Constructor didn't equal parsed string", (boolean)fromConstructor.equals((Object)fromString));
        fromString = new FrontendVersion("1.1.alpha12");
        fromConstructor = new FrontendVersion(1, 1, 0, "alpha12");
        Assert.assertTrue((String)"Major-Minor version with build identifier didn't match", (boolean)fromConstructor.equals((Object)fromString));
        fromString = new FrontendVersion("12.3.5.alpha12");
        fromConstructor = new FrontendVersion(12, 3, 5, "alpha12");
        Assert.assertTrue((String)"Full version with build identifier didn't match", (boolean)fromString.equals((Object)fromConstructor));
    }

    @Test
    public void testIsEqualTo() {
        FrontendVersion fromString = new FrontendVersion("1.1.0");
        FrontendVersion fromConstructor = new FrontendVersion(1, 1);
        Assert.assertTrue((String)"Parsed string didn't equal constructor", (boolean)fromString.isEqualTo(fromConstructor));
        Assert.assertTrue((String)"Constructor didn't equal parsed string", (boolean)fromConstructor.isEqualTo(fromString));
        fromString = new FrontendVersion("1.1.alpha12");
        fromConstructor = new FrontendVersion(1, 1, 0, "alpha12");
        Assert.assertTrue((String)"Major-Minor version with build identifier didn't match", (boolean)fromConstructor.isEqualTo(fromString));
        fromString = new FrontendVersion("12.3.5.alpha12");
        fromConstructor = new FrontendVersion(12, 3, 5, "alpha12");
        Assert.assertTrue((String)"Full version with build identifier didn't match", (boolean)fromString.isEqualTo(fromConstructor));
    }

    @Test
    public void testSimilarBuildIdentifiers() {
        FrontendVersion version = new FrontendVersion("1.1.1-SNAPSHOT");
        FrontendVersion equals = new FrontendVersion("1.1.1-SNAPSHOT");
        Assert.assertTrue((String)"Versions be the same", (boolean)version.isEqualTo(equals));
        Assert.assertFalse((String)"Version should not be older", (boolean)version.isOlderThan(equals));
        Assert.assertEquals((String)"Versions should not have a difference", (long)0L, (long)version.compareTo(equals));
        Assert.assertFalse((String)"Version should not be newer", (boolean)version.isNewerThan(equals));
    }

    @Test(expected=NumberFormatException.class)
    public void faultyStringVersion_throwsException() {
        new FrontendVersion("12.0b.1");
    }

    @Test(expected=NumberFormatException.class)
    public void notANumber_throwsException() {
        new FrontendVersion("a");
    }

    @Test(expected=NumberFormatException.class)
    public void emptyString_throwsException() {
        new FrontendVersion("");
    }

    @Test
    public void onlyMajorVersion_allVersoinNumbersAreCalculated() {
        this.assertVersion(new FrontendVersion("3"), 3, 0, 0, "");
    }

    @Test
    public void versionHandlesTildeAndCaretVersions() {
        this.assertVersion(new FrontendVersion("~1.3.0-beta1"), 1, 3, 0, "beta1");
        this.assertVersion(new FrontendVersion("~2.2"), 2, 2, 0, "");
        this.assertVersion(new FrontendVersion("^3.3.1"), 3, 3, 1, "");
    }

    @Test
    public void olderVersionIsCalculatedCorrectly() {
        FrontendVersion test = new FrontendVersion("2.2.0");
        Assert.assertTrue((String)"Should be older due to revision", (boolean)test.isOlderThan(new FrontendVersion("2.2.1")));
        Assert.assertTrue((String)"Should be older due to minor", (boolean)test.isOlderThan(new FrontendVersion("2.3.0")));
        Assert.assertTrue((String)"Should be older due to major", (boolean)test.isOlderThan(new FrontendVersion("3.2.0")));
        Assert.assertFalse((String)"Should be newer as target has buildIdentifier", (boolean)test.isOlderThan(new FrontendVersion("2.2.0-alpha1")));
        Assert.assertFalse((String)"Should be newer due to major", (boolean)test.isOlderThan(new FrontendVersion("1.2.0")));
        Assert.assertFalse((String)"Should be newer due to minor", (boolean)test.isOlderThan(new FrontendVersion("2.1.0")));
        Assert.assertFalse((String)"Should be newer due to minor", (boolean)test.isOlderThan(new FrontendVersion("2.1.2")));
        Assert.assertFalse((String)"Should be newer due to minor", (boolean)test.isOlderThan(new FrontendVersion("1.5.2")));
        Assert.assertFalse((String)"Should be newer by major even with buildIdentifier", (boolean)test.isOlderThan(new FrontendVersion("1.2.0-alpha1")));
    }

    @Test
    public void newerVersionIsCalculatedCorrectly() {
        FrontendVersion test = new FrontendVersion("2.2.2");
        Assert.assertTrue((String)"Should be newer due to revision", (boolean)test.isNewerThan(new FrontendVersion("2.2.1")));
        Assert.assertTrue((String)"Should be newer due to minor", (boolean)test.isNewerThan(new FrontendVersion("2.1.2")));
        Assert.assertTrue((String)"Should be newer due to major", (boolean)test.isNewerThan(new FrontendVersion("1.2.2")));
        Assert.assertTrue((String)"Should be newer as target has buildIdentifier", (boolean)test.isNewerThan(new FrontendVersion("2.2.2-alpha1")));
        Assert.assertFalse((String)"Should be older due to major", (boolean)test.isNewerThan(new FrontendVersion("3.2.2")));
        Assert.assertFalse((String)"Should be older due to minor", (boolean)test.isNewerThan(new FrontendVersion("2.3.2")));
    }

    @Test
    public void olderVersionByBuildIdentifier() {
        FrontendVersion test = new FrontendVersion("2.0.0-RC1");
        Assert.assertTrue((String)"2.0.0 should be newer that RC1", (boolean)test.isOlderThan(new FrontendVersion("2.0.0")));
        Assert.assertTrue((String)"RC2 should be newer that RC1", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-RC2")));
        Assert.assertFalse((String)"beta5 should be older than RC1", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-beta5")));
        Assert.assertFalse((String)"alpha4 should be older than RC1", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-alpha4")));
        test = new FrontendVersion("2.0.0");
        Assert.assertFalse((String)"RC2 should be older that 2.0.0", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-RC2")));
        Assert.assertFalse((String)"beta5 should be older than 2.0.0", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-beta5")));
        Assert.assertFalse((String)"alpha4 should be older than 2.0.0", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-alpha4")));
    }

    @Test
    public void newerVersionByBuildIdentifier() {
        FrontendVersion test = new FrontendVersion("2.0.0-alpha2");
        Assert.assertTrue((String)"alpha2 should be newer than alpha1", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-alpha1")));
        Assert.assertFalse((String)"alpha2 should be older than 2.0.0", (boolean)test.isNewerThan(new FrontendVersion("2.0.0")));
        Assert.assertFalse((String)"alpha2 should be older than beta1", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-beta1")));
        Assert.assertFalse((String)"alpha2 should be older than RC1", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-RC1")));
        test = new FrontendVersion("2.0.0");
        Assert.assertTrue((String)"2.0.0 should be newer than alpha1", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-alpha1")));
        Assert.assertTrue((String)"2.0.0 should be older than beta1", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-beta1")));
        Assert.assertTrue((String)"2.0.0 should be older than RC1", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-RC1")));
    }

    @Test
    public void buildIdentifierNumbers_returnsAsExpected() {
        FrontendVersion test = new FrontendVersion("2.0.0-alpha6");
        Assert.assertTrue((String)"2.0.0-alpha6 should be older than 2.0.0-alpha13", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-alpha13")));
        test = new FrontendVersion("2.0.0-alpha20");
        Assert.assertTrue((String)"2.0.0-alpha20 should be newer than 2.0.0-alpha13", (boolean)test.isNewerThan(new FrontendVersion("2.0.0-alpha13")));
        Assert.assertFalse((String)"2.0.0-alpha20 should be newer than 2.0.0-alpha13", (boolean)test.isOlderThan(new FrontendVersion("2.0.0-alpha13")));
        Assert.assertTrue((String)"2.0.0-alpha13 should not be older than 2.0.0-alpha20", (boolean)new FrontendVersion("2.0.0-alpha13").isOlderThan(test));
        Assert.assertFalse((String)"2.0.0-alpha13 should not be older than 2.0.0-alpha20", (boolean)new FrontendVersion("2.0.0-alpha13").isNewerThan(test));
        Assert.assertTrue((String)"same versions should equal", (boolean)test.isEqualTo(new FrontendVersion("2.0.0.alpha20")));
    }

    @Test
    public void testAgainstVersionWithValueInBuildInfo() {
        FrontendVersion alpha3 = new FrontendVersion("2.0.0-alpha3");
        FrontendVersion five = new FrontendVersion("2.0.0.5");
        FrontendVersion fifteen = new FrontendVersion("2.0.0.15");
        Assert.assertTrue((String)"2.0.0-alpha3 should be older than 2.0.0.5", (boolean)alpha3.isOlderThan(five));
        Assert.assertFalse((String)"2.0.0-alpha3 should be older than 2.0.0.5", (boolean)alpha3.isNewerThan(five));
        Assert.assertTrue((String)"2.0.0.5 should be newer than 2.0.0-alpha3", (boolean)five.isNewerThan(alpha3));
        Assert.assertFalse((String)"2.0.0.5 should be newer than 2.0.0-alpha3", (boolean)five.isOlderThan(alpha3));
        Assert.assertTrue((String)"2.0.0.5 should be older than 2.0.0.15", (boolean)five.isOlderThan(fifteen));
        Assert.assertFalse((String)"2.0.0.5 should be older than 2.0.0.15", (boolean)five.isNewerThan(fifteen));
        Assert.assertTrue((String)"2.0.0.15 should be newer than 2.0.0.5", (boolean)fifteen.isNewerThan(five));
        Assert.assertFalse((String)"2.0.0.15 should be newer than 2.0.0.5", (boolean)fifteen.isOlderThan(five));
    }

    private void assertVersion(FrontendVersion version, int major, int minor, int revision, String build) {
        Assert.assertEquals((String)("Major version was wrong for " + version.getFullVersion()), (long)version.getMajorVersion(), (long)major);
        Assert.assertEquals((String)("Minor version was wrong for " + version.getFullVersion()), (long)version.getMinorVersion(), (long)minor);
        Assert.assertEquals((String)("Revision was wrong for " + version.getFullVersion()), (long)version.getRevision(), (long)revision);
        Assert.assertEquals((String)("Build identifier was wrong for " + version.getFullVersion()), (Object)version.getBuildIdentifier(), (Object)build);
    }
}

