/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.File;
import java.net.URI;
import java.util.List;

public class FrontendToolsTestHelper {
    public static String installNode(File installDir, List<ProxyConfig.Proxy> proxies, String nodeVersion, URI downloadRoot) {
        NodeInstaller nodeInstaller = new NodeInstaller(installDir, proxies).setNodeVersion(nodeVersion);
        if (downloadRoot != null) {
            nodeInstaller.setNodeDownloadRoot(downloadRoot);
        }
        try {
            nodeInstaller.install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to install Node", e);
        }
        String normalizedVersion = nodeVersion.startsWith("v") ? nodeVersion.substring(1) : nodeVersion;
        String versionedPath = "node-v" + normalizedVersion;
        String nodeBin = FrontendUtils.isWindows() ? versionedPath + "\\node.exe" : versionedPath + "/bin/node";
        File nodeExecutable = new File(installDir, nodeBin);
        return nodeExecutable.exists() ? nodeExecutable.getAbsolutePath() : null;
    }
}

