/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class FrontendToolsExecutor {
    public static void main(String[] args) {
        System.out.println("=".repeat(80));
        System.out.println("Node.js Resolution Test");
        System.out.println("=".repeat(80));
        try {
            boolean forceAlternative = Boolean.getBoolean("alternative");
            String preferredVersion = System.getProperty("nodeVersion", "v24.12.0");
            String baseDir = System.getProperty("baseDir", System.getProperty("user.dir"));
            System.out.println("\nConfiguration:");
            System.out.println("  Base directory: " + baseDir);
            System.out.println("  Supported version for global: >= " + FrontendTools.SUPPORTED_NODE_VERSION.getFullVersion());
            System.out.println("  Minimum auto-installed version (~/.vaadin): >= " + FrontendTools.MINIMUM_AUTO_INSTALLED_NODE.getFullVersion());
            System.out.println("  Maximum major version: 24");
            System.out.println("  Preferred version (to install if needed): " + preferredVersion);
            System.out.println("  Force alternative node: " + forceAlternative);
            System.out.println();
            FrontendToolsSettings settings = new FrontendToolsSettings(baseDir, (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
            settings.setNodeVersion(preferredVersion);
            settings.setForceAlternativeNode(forceAlternative);
            FrontendTools tools = new FrontendTools(settings);
            String nodeExecutable = tools.getNodeExecutable();
            String actualVersionUsed = tools.getNodeVersion().getFullVersion();
            String npmVersion = tools.getNpmVersion().getFullVersion();
            System.out.println("Resolved Node.js installation:");
            System.out.println("  Node executable: " + nodeExecutable);
            System.out.println("  Actual version used: " + actualVersionUsed);
            System.out.println("  npm version: " + npmVersion);
            File nodeFile = new File(nodeExecutable);
            boolean isGlobal = !nodeFile.getAbsolutePath().contains(FrontendUtils.getVaadinHomeDirectory().getName());
            System.out.println("\nInstallation type: " + (isGlobal ? "GLOBAL" : "ALTERNATIVE (~/.vaadin)"));
            if (!isGlobal) {
                System.out.println("  Location: " + FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
            }
            System.out.println("\nVerification:");
            try {
                ArrayList<String> versionCommand = new ArrayList<String>();
                versionCommand.add(nodeExecutable);
                versionCommand.add("--version");
                FrontendVersion version = FrontendUtils.getVersion((String)"node", versionCommand);
                System.out.println("  \u2713 Node executable is working");
                System.out.println("  \u2713 Verified version: " + version.getFullVersion());
            }
            catch (Exception e) {
                System.out.println("  \u2717 Failed to verify node executable: " + e.getMessage());
            }
            System.out.println("\n" + "=".repeat(80));
            System.out.println("Resolution completed successfully");
            System.out.println("=".repeat(80));
        }
        catch (Exception e) {
            System.err.println("\n" + "=".repeat(80));
            System.err.println("ERROR: Resolution failed");
            System.err.println("=".repeat(80));
            System.err.println("\nException: " + e.getClass().getName());
            System.err.println("Message: " + e.getMessage());
            System.err.println("\nStack trace:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

