/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.testutil.TestUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class FrontendResourcesAreCopiedAfterCleaningTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File npmFolder;
    private File testJar = TestUtils.getTestJar((String)"jar-with-frontend-resources.jar");

    @Before
    public void setup() throws IOException, ExecutionFailedException {
        this.npmFolder = this.temporaryFolder.getRoot();
    }

    @Test
    public void frontendResources_should_beCopiedFromJars_when_TaskUpdatePackagesRemovesThem() throws IOException, ExecutionFailedException {
        this.copyResources();
        this.assertCopiedFrontendFileAmount(17);
        this.performPackageClean();
        this.assertCopiedFrontendFileAmount(0);
        this.copyResources();
        this.assertCopiedFrontendFileAmount(17);
    }

    private void assertCopiedFrontendFileAmount(int fileCount) throws IOException {
        File dir = this.getJarFrontendResourcesFolder();
        FileUtils.forceMkdir((File)dir);
        List files = TestUtils.listFilesRecursively((File)dir);
        Assert.assertEquals((String)"Should have frontend files", (long)fileCount, (long)files.size());
    }

    private File getJarFrontendResourcesFolder() {
        return new File(this.npmFolder, Paths.get("./src/main/frontend/", "generated/", "jar-resources").toString());
    }

    private void copyResources() throws ExecutionFailedException {
        ClassFinder.DefaultClassFinder classFinder = new ClassFinder.DefaultClassFinder(FrontendResourcesAreCopiedAfterCleaningTest.class.getClassLoader(), new Class[0]);
        Lookup mockLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)classFinder).when((Object)mockLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockLookup, this.npmFolder).withBuildDirectory("target");
        new NodeTasks(options.withEmbeddableWebComponents(false).enableImportsUpdate(false).createMissingPackageJson(true).enableImportsUpdate(true).withRunNpmInstall(false).enablePackagesUpdate(true).withFrontendDirectory(this.npmFolder).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).copyResources(Collections.singleton(this.testJar)).withBuildResultFolders(this.npmFolder, this.npmFolder)).execute();
    }

    private void performPackageClean() throws ExecutionFailedException {
        ClassFinder.DefaultClassFinder classFinder = new ClassFinder.DefaultClassFinder(FrontendResourcesAreCopiedAfterCleaningTest.class.getClassLoader(), new Class[0]);
        Lookup mockLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)classFinder).when((Object)mockLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockLookup, this.npmFolder).withBuildDirectory("target").withEmbeddableWebComponents(false).enableImportsUpdate(false).createMissingPackageJson(true).enableImportsUpdate(true).withRunNpmInstall(false).enableNpmFileCleaning(true).withFrontendDirectory(this.npmFolder).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).copyResources(Collections.emptySet()).withBuildResultFolders(this.npmFolder, this.npmFolder).enablePackagesUpdate(true);
        new NodeTasks(options).execute();
    }
}

