/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.Pair;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ForkJoinPoolExhaustionTest {
    private final List<CompletableFuture<?>> blockingTasks = new ArrayList();

    @After
    public void cleanup() {
        this.blockingTasks.forEach(f -> f.cancel(true));
        this.blockingTasks.clear();
    }

    @Test
    public void consumeProcessStreams_shouldNotBeBlockedByExhaustedCommonPool() throws Exception {
        int parallelism = ForkJoinPool.commonPool().getParallelism();
        int numBlockingTasks = parallelism + 2;
        CountDownLatch poolSaturated = new CountDownLatch(parallelism);
        for (int i = 0; i < numBlockingTasks; ++i) {
            CompletableFuture<Void> blocker = CompletableFuture.runAsync(() -> {
                try {
                    poolSaturated.countDown();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            this.blockingTasks.add(blocker);
        }
        Assert.assertTrue((String)"Pool didn't saturate in time", (boolean)poolSaturated.await(5L, TimeUnit.SECONDS));
        List<String> cmd = List.of(Paths.get(System.getProperty("java.home"), "bin", "java").toFile().getAbsolutePath(), "-cp", System.getProperty("java.class.path"), FastTestExecutable.class.getName());
        Process process = new ProcessBuilder(cmd).start();
        CompletableFuture streamsFuture = FrontendUtils.consumeProcessStreams((Process)process);
        boolean processCompleted = process.waitFor(2L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Process should complete within 2 seconds", (boolean)processCompleted);
        try {
            Pair streams = (Pair)streamsFuture.get(2L, TimeUnit.SECONDS);
            String stdOut = (String)((Object)streams.getFirst());
            Assert.assertTrue((String)("Expected stdout to contain test output, but was: " + stdOut), (boolean)stdOut.contains("FastTestExecutable completed"));
            String stdErr = (String)((Object)streams.getSecond());
            Assert.assertTrue((String)("Expected stdout to contain test output, but was: " + stdErr), (boolean)stdErr.contains("FastTestExecutable writing to stderr"));
        }
        catch (TimeoutException e) {
            Assert.fail((String)"consumeProcessStreams should not be blocked by exhausted ForkJoinPool.commonPool(). This indicates the implementation incorrectly uses the common pool instead of a dedicated executor. See https://github.com/vaadin/flow/issues/22756");
        }
    }

    public static class FastTestExecutable {
        public static void main(String ... args) {
            System.err.println("FastTestExecutable writing to stderr");
            System.out.println("FastTestExecutable completed");
        }
    }
}

