/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.BundleBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class BundleBuildUtilsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void packageLockExists_nothingIsCopied() throws IOException {
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource(Mockito.anyString())).thenReturn(null);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), finder, this.temporaryFolder.getRoot()).withBuildDirectory("target");
        File packageLockFile = this.temporaryFolder.newFile("package-lock.json");
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "package-lock.json");
        String existingLockFile = "{ \"existing\" }";
        FileUtils.write((File)packageLockFile, (CharSequence)"{ \"existing\" }");
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"bundleFile\"}");
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)packageLockFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Existing file should not be overwritten", (Object)"{ \"existing\" }", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_devBundleLockIsCopied_notJarLock() throws IOException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "package-lock.json");
        String packageLockContent = "{ \"bundleFile\"}";
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"bundleFile\"}");
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"dev-bundle file should be used", (Object)"{ \"bundleFile\"}", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_jarDevBundleLockIsCopied() throws IOException, ClassNotFoundException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        File jarHybridPackageLock = new File(options.getNpmFolder(), "hybrid-temp.json");
        String jarHybridPackageLockContent = "{ \"hybridJarData\"}";
        FileUtils.write((File)jarHybridPackageLock, (CharSequence)"{ \"hybridJarData\"}");
        ((ClassFinder)Mockito.doThrow((Throwable[])new Throwable[]{new ClassNotFoundException("No Hilla")}).when((Object)options.getClassFinder())).loadClass("com.vaadin.hilla.EndpointController");
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-package-lock.json")).thenReturn((Object)jarHybridPackageLock.toURI().toURL());
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"File should be gotten from jar on classpath", (Object)"{ \"jarData\"}", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_hillaUsed_jarHybridDevBundleLockIsCopied() throws IOException, ClassNotFoundException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        Path dummyView = options.getFrontendDirectory().toPath().resolve(Path.of("views", "dummy.tsx"));
        Files.createDirectories(dummyView.getParent(), new FileAttribute[0]);
        Files.writeString(dummyView, (CharSequence)"const x = 1;", new OpenOption[0]);
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        File jarHybridPackageLock = new File(options.getNpmFolder(), "hybrid-temp.json");
        String jarHybridPackageLockContent = "{ \"hybridJarData\"}";
        FileUtils.write((File)jarHybridPackageLock, (CharSequence)"{ \"hybridJarData\"}");
        Mockito.when((Object)options.getClassFinder().loadClass("com.vaadin.hilla.EndpointController")).thenReturn(Object.class);
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-package-lock.json")).thenReturn((Object)jarHybridPackageLock.toURI().toURL());
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"File should be gotten from jar on classpath", (Object)"{ \"hybridJarData\"}", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_hillaUsed_hybridPackageLockNotPresentInJar_jarDevBundleIsCopied() throws IOException, ClassNotFoundException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        Path dummyView = options.getFrontendDirectory().toPath().resolve(Path.of("views", "dummy.tsx"));
        Files.createDirectories(dummyView.getParent(), new FileAttribute[0]);
        Files.writeString(dummyView, (CharSequence)"const x = 1;", new OpenOption[0]);
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        Mockito.when((Object)options.getClassFinder().loadClass("com.vaadin.hilla.EndpointController")).thenReturn(Object.class);
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-package-lock.json")).thenReturn(null);
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"File should be gotten from jar on classpath", (Object)"{ \"jarData\"}", (Object)packageLockContents);
    }

    @Test
    public void pnpm_noPackageLockExists_devBundleLockYamlIsCopied_notJarLockOrJson() throws IOException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target").withEnablePnpm(true);
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/pnpm-lock.yaml")).thenReturn((Object)jarPackageLock.toURI().toURL());
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "package-lock.json");
        File devPackageLock = new File(devBundleFolder, "pnpm-lock.yaml");
        String packageLockContent = "{ \"bundleFile\"}";
        FileUtils.write((File)devPackageLock, (CharSequence)"{ \"bundleFile\"}");
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"json\"}");
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "pnpm-lock.yaml"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"dev-bundle file should be used", (Object)"{ \"bundleFile\"}", (Object)packageLockContents);
    }

    @Test
    public void pnpm_packageLockExists_nothingIsCopied() throws IOException {
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource(Mockito.anyString())).thenReturn(null);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), finder, this.temporaryFolder.getRoot()).withBuildDirectory("target").withEnablePnpm(true);
        File packageLockFile = this.temporaryFolder.newFile("pnpm-lock.yaml");
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "pnpm-lock.yaml");
        String existingLockFile = "{ \"existing\" }";
        FileUtils.write((File)packageLockFile, (CharSequence)"{ \"existing\" }");
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"bundleFile\"}");
        BundleBuildUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)packageLockFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Existing file should not be overwritten", (Object)"{ \"existing\" }", (Object)packageLockContents);
    }
}

