/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.MockLogger;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.frontend.AbstractUpdateImports;
import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;

public abstract class AbstractUpdateImportsTest
extends NodeUpdateTestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected File tmpRoot;
    protected File frontendDirectory;
    protected File nodeModulesPath;
    protected UpdateImports updater;
    private MockLogger logger;
    private static final String ERROR_MSG = "foo-bar-baz";
    private FeatureFlags featureFlags;
    protected Options options;
    private File tokenFile;

    @Before
    public void setup() throws Exception {
        this.tmpRoot = this.temporaryFolder.getRoot();
        this.logger = new MockLogger();
        this.frontendDirectory = new File(this.tmpRoot, "./src/main/frontend/");
        this.nodeModulesPath = new File(this.tmpRoot, "node_modules/");
        this.tokenFile = new File(this.tmpRoot, "config/flow-build-info.json");
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder();
        this.featureFlags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        this.options = new MockOptions(classFinder, this.tmpRoot).withTokenFile(this.tokenFile).withProductionMode(true).withFeatureFlags(this.featureFlags).withBundleBuild(true);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        Assert.assertTrue((boolean)this.nodeModulesPath.mkdirs());
        this.createExpectedImports(this.frontendDirectory, this.nodeModulesPath);
        Assert.assertTrue((boolean)new File(new File(new File(this.frontendDirectory, "generated/"), "jar-resources"), "ExampleConnector.js").exists());
    }

    protected abstract FrontendDependenciesScanner getScanner(ClassFinder var1);

    @Test
    public void importsFilesAreNotFound_throws() {
        this.deleteExpectedImports(this.frontendDirectory, this.nodeModulesPath);
        this.exception.expect(IllegalStateException.class);
        this.updater.run();
    }

    @Test
    public void generatedResources_relativeImport_dotSlash_notStripped() throws IOException {
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./generated/jar-resources/foo.js");
        File resource = this.resolveImportFile(this.frontendDirectory, this.nodeModulesPath, "./generated/jar-resources/ExampleConnector.js");
        Files.writeString(resource.toPath(), (CharSequence)"import \"./foo.js\";", new OpenOption[0]);
        this.updater.run();
        String output = this.logger.getLogs();
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.not((org.hamcrest.Matcher)CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"Use the './' prefix for files in the '"), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"folder: 'generated/jar-resources/foo.js', please update your annotations."))));
    }

    @Test
    public void copiedJarResources_containsImport_importFollowedAndAdded() throws IOException {
        Class[] testClasses = new Class[]{UI.class, AllEagerAppConf.class, NodeTestComponents.ReferenceView.class, NodeTestComponents.VaadinBowerComponent.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./generated/jar-resources/sub/example-import.js");
        File resource = this.resolveImportFile(this.frontendDirectory, this.nodeModulesPath, "./generated/jar-resources/ExampleConnector.js");
        Files.writeString(resource.toPath(), (CharSequence)"import \"./sub/example-import.js\";", new OpenOption[0]);
        this.updater.run();
        ArrayList flowImports = new ArrayList(this.updater.getOutput().get(this.updater.generatedFlowImports));
        Assert.assertTrue((boolean)flowImports.contains("import 'Frontend/generated/jar-resources/ExampleConnector.js';"));
        Assert.assertTrue((boolean)flowImports.contains("import 'Frontend/generated/jar-resources/sub/example-import.js';"));
    }

    @Test
    public void getModuleLines_npmPackagesDontExist_logExplanation() {
        boolean atLeastOneRemoved = false;
        for (String imprt : this.getExpectedImports()) {
            if (!imprt.startsWith("@vaadin") || !imprt.endsWith(".js")) continue;
            Assert.assertTrue((boolean)this.resolveImportFile(this.nodeModulesPath, this.nodeModulesPath, imprt).delete());
            atLeastOneRemoved = true;
        }
        Assert.assertTrue((boolean)atLeastOneRemoved);
        this.updater.run();
        MatcherAssert.assertThat((Object)this.logger.getLogs(), (org.hamcrest.Matcher)CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"@vaadin/vaadin-lumo-styles/spacing.js"), (org.hamcrest.Matcher)CoreMatchers.containsString((String)ERROR_MSG)));
    }

    @Test
    public void getModuleLines_oneFrontendDependencyDoesntExist_throwExceptionAndlogExplanation() {
        String fooFileName = "./foo.js";
        this.assertFileRemoved(fooFileName, this.frontendDirectory);
        try {
            this.updater.run();
            Assert.fail((String)"Execute should have failed with missing file");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"Failed to find the following files:"), (org.hamcrest.Matcher)CoreMatchers.containsString((String)fooFileName), (org.hamcrest.Matcher)CoreMatchers.containsString((String)this.getFrontendErrorMessageSuffix())));
        }
    }

    @Test
    public void getModuleLines_oneFrontendDependencyAndFrontendDirectoryDontExist_throwExceptionAdvisingUserToRunPrepareFrontend() throws Exception {
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder();
        this.options.withTokenFile(null);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        Files.move(this.frontendDirectory.toPath(), new File(this.tmpRoot, "_frontend").toPath(), new CopyOption[0]);
        try {
            this.updater.run();
            Assert.fail((String)"Execute should have failed with advice to run `prepare-frontend`");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"Unable to locate frontend resources and missing token file. Please run the `prepare-frontend` Vaadin plugin goal before deploying the application"));
        }
    }

    @Test
    public void getModuleLines_multipleFrontendDependencyDoesntExist_throwExceptionAndlogExplanation() {
        String localTemplateFileName = "./local-template.js";
        String fooFileName = "./foo.js";
        this.assertFileRemoved(localTemplateFileName, this.frontendDirectory);
        this.assertFileRemoved(fooFileName, this.frontendDirectory);
        try {
            this.updater.run();
            Assert.fail((String)"Execute should have failed with missing files");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (org.hamcrest.Matcher)CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"Failed to find the following files:"), (org.hamcrest.Matcher)CoreMatchers.containsString((String)localTemplateFileName), (org.hamcrest.Matcher)CoreMatchers.containsString((String)fooFileName), (org.hamcrest.Matcher)CoreMatchers.containsString((String)this.getFrontendErrorMessageSuffix())));
        }
    }

    private void assertFileRemoved(String fileName, File directory) {
        Assert.assertTrue((String)String.format("File `%s` was not removed from, or does not exist in, `%s`", fileName, directory), (boolean)this.resolveImportFile(directory, directory, fileName).delete());
    }

    private String getFrontendErrorMessageSuffix() {
        String suffix = String.format("%n  Locations searched were:%n      - `%s` in this project%n      - `%s` in included JARs%n      - `%s` in included JARs%n%n  Please, double check that those files exist. If you use a custom directory for your resource files instead of default `frontend` folder then make sure you it's correctly configured (e.g. set '%s' property)", this.frontendDirectory.getPath(), "META-INF/frontend", "META-INF/resources/frontend", "vaadin.frontend.folder");
        return suffix;
    }

    @Test
    public void generateLines_resultingLinesContainsThemeLinesAndExpectedImportsAndCssLinesAndGeneratedImportsAndLoggerReports() throws Exception {
        ArrayList<String> expectedLines = new ArrayList<String>();
        this.getExpectedImports().stream().filter(imp -> imp.equals("/foo.css")).forEach(imp -> expectedLines.add("import '" + this.addFrontendAlias((String)imp) + "';"));
        expectedLines.add("import '@vaadin/vaadin-mixed-component/src/vaadin-something-else';");
        expectedLines.add("import 'unresolved/component';");
        expectedLines.add("import \\$cssFromFile_\\d from '@vaadin/vaadin-mixed-component/bar.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("injectGlobalCss\\(\\$cssFromFile_\\d.toString\\(\\), 'CSSImport end', document\\);");
        expectedLines.add("addCssBlock\\(`<style include=\"bar\">\\$\\{\\$css_\\d\\}</style>`\\);");
        expectedLines.add("registerStyles\\('', \\$css_\\d, \\{moduleId: 'baz'\\}\\);");
        expectedLines.add("registerStyles\\('', \\$css_\\d, \\{include: 'bar', moduleId: 'baz'\\}\\);");
        expectedLines.add("registerStyles\\('foo-bar', \\$css_\\d, \\{moduleId: 'flow_css_mod_\\d'\\}\\);");
        expectedLines.add("registerStyles\\('foo-bar', \\$css_\\d, \\{include: 'bar', moduleId: 'flow_css_mod_\\d'\\}\\);");
        expectedLines.add("import 'Frontend/generated/flow/generated-modules-foo';");
        expectedLines.add("import 'Frontend/generated/flow/generated-modules-bar';");
        List<String> expectedAppShellImports = List.of("import \\$cssFromFile_\\d from 'lumo-css-import.css\\?inline';", "injectGlobalCss\\(\\$cssFromFile_\\d.toString\\(\\), 'CSSImport end', document\\);");
        this.updater.run();
        List<String> appShellImports = this.updater.getOutput().get(this.updater.appShellImports);
        String appShellOutput = String.join((CharSequence)"\n", appShellImports);
        for (String line : expectedAppShellImports) {
            Assert.assertTrue((String)("\n" + line + " IS NOT FOUND IN: \n" + String.valueOf(appShellImports)), (boolean)Pattern.compile(line).matcher(appShellOutput).find());
        }
        List<String> mergedOutput = this.updater.getMergedOutput();
        String outputString = String.join((CharSequence)"\n", mergedOutput);
        for (String line : expectedLines) {
            Assert.assertTrue((String)("\n" + line + " IS NOT FOUND IN: \n" + String.valueOf(mergedOutput)), (boolean)Pattern.compile(line).matcher(outputString).find());
        }
        Pattern moduleIdPattern = Pattern.compile(".*moduleId: '(flow_css_mod_[^']*)'.*");
        List moduleIds = mergedOutput.stream().map(moduleIdPattern::matcher).filter(Matcher::matches).map(m -> m.group(1)).collect(Collectors.toList());
        long uniqueModuleIds = moduleIds.stream().distinct().count();
        Assert.assertTrue((String)"expected modules", (moduleIds.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)("duplicates in generated " + String.valueOf(moduleIds)), (long)moduleIds.size(), (long)uniqueModuleIds);
        String output = this.logger.getLogs();
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.containsString((String)"Use the './' prefix for files in JAR files: 'ExampleConnector.js'"));
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.containsString((String)("Use the './' prefix for files in the '" + this.frontendDirectory.getPath() + "' folder: 'vaadin-mixed-component/src/vaadin-mixed-component.js'")));
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.allOf((org.hamcrest.Matcher)CoreMatchers.containsString((String)"Failed to find the following imports in the `node_modules` tree:"), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"unresolved/component")));
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.not((org.hamcrest.Matcher)CoreMatchers.containsString((String)"changing 'frontend://foo-dir/javascript-lib.js' to './foo-dir/javascript-lib.js'")));
    }

    @Test
    public void cssFileNotFound_loggerReports() {
        Assert.assertTrue((boolean)this.resolveImportFile(this.frontendDirectory, this.nodeModulesPath, "@vaadin/vaadin-mixed-component/bar.css").delete());
        this.updater.run();
        String output = this.logger.getLogs();
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.containsString((String)"Failed to find the following css files in the `node_modules`"));
        MatcherAssert.assertThat((Object)output, (org.hamcrest.Matcher)CoreMatchers.containsString((String)"@vaadin/vaadin-mixed-component/bar.css"));
    }

    @Test
    public void generate_containsLumoThemeFiles() {
        this.updater.run();
        this.assertContainsImports(true, "@vaadin/vaadin-lumo-styles/color.js", "@vaadin/vaadin-lumo-styles/color-global.js", "@vaadin/vaadin-lumo-styles/typography.js", "@vaadin/vaadin-lumo-styles/typography-global.js", "@vaadin/vaadin-lumo-styles/sizing.js", "@vaadin/vaadin-lumo-styles/spacing.js", "@vaadin/vaadin-lumo-styles/style.js", "@vaadin/vaadin-lumo-styles/icons.js");
    }

    @Test
    public void generate_embeddedImports_doNotContainLumoGlobalThemeFiles() throws IOException {
        this.updater.run();
        ArrayList<String> flowImports = new ArrayList<String>((Collection)this.updater.getOutput().get(this.updater.generatedFlowImports));
        Predicate<String> lumoGlobalsMatcher = Pattern.compile("@vaadin/vaadin-lumo-styles/.*-global.js").asPredicate();
        Assert.assertTrue((boolean)flowImports.stream().anyMatch(lumoGlobalsMatcher));
        Assert.assertTrue((String)"Import for web-components should not contain lumo global imports", (boolean)this.updater.webComponentImports.stream().noneMatch(lumoGlobalsMatcher));
        flowImports.removeAll(this.updater.webComponentImports);
        Predicate<String> injectGlobal = Pattern.compile("injectGlobalCss.*").asPredicate();
        flowImports.removeIf(injectGlobal);
        Assert.assertTrue((String)"Flow and web-component imports must be the same, except for lumo globals", (boolean)flowImports.stream().allMatch(lumoGlobalsMatcher));
    }

    @Test
    public void generate_embeddedImports_addAlsoGlobalStyles() throws IOException {
        Class[] testClasses = new Class[]{FooCssImport.class, FooCssImport2.class, UI.class, AllEagerAppConf.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Pattern injectGlobalCssPattern = Pattern.compile("^\\s*injectGlobalCss\\(([^,]+),.*");
        Predicate<String> globalCssImporter = injectGlobalCssPattern.asPredicate();
        List<String> globalCss = this.updater.getOutput().get(this.updater.generatedFlowImports).stream().filter(globalCssImporter).map(line -> {
            Matcher matcher = injectGlobalCssPattern.matcher((CharSequence)line);
            matcher.find();
            return matcher.group(1);
        }).collect(Collectors.toList());
        Assert.assertTrue((String)"Should contain function to import global CSS into embedded component", (boolean)this.updater.webComponentImports.stream().anyMatch(line -> line.contains("import { injectGlobalWebcomponentCss }")));
        globalCss.forEach(css -> Assert.assertTrue((String)("Should register global CSS " + css + " for webcomponent"), (boolean)this.updater.webComponentImports.stream().anyMatch(line -> line.contains("injectGlobalWebcomponentCss(" + css + ");"))));
    }

    @Test
    public void jsModulesOrderIsPreservedAnsAfterJsModules() {
        this.updater.run();
        this.assertImportOrder("jsmodule/g.js", "javascript/a.js", "javascript/b.js", "javascript/c.js");
    }

    @Test
    public void duplicateEagerCssOnlyImportedOnce() throws Exception {
        Class[] testClasses = new Class[]{FooCssImport.class, FooCssImport2.class, UI.class, AllEagerAppConf.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        this.assertOnce("import { injectGlobalCss } from", output.get(flowGeneratedImports));
        this.assertOnce("import { css, unsafeCSS, registerStyles } from", output.get(flowGeneratedImports));
        this.assertOnce("from 'Frontend/foo.css?inline';", output.get(flowGeneratedImports));
    }

    @Test
    public void eagerCssImportsMerged() throws Exception {
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./bar.css");
        Class[] testClasses = new Class[]{FooCssImport.class, BarCssImport.class, UI.class, AllEagerAppConf.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        this.assertOnce("import { injectGlobalCss } from", output.get(flowGeneratedImports));
        this.assertOnce("import { css, unsafeCSS, registerStyles } from", output.get(flowGeneratedImports));
        this.assertOnce("from 'Frontend/foo.css?inline';", output.get(flowGeneratedImports));
        this.assertOnce("from 'Frontend/bar.css?inline';", output.get(flowGeneratedImports));
        this.assertOnce("import $cssFromFile_0 from", output.get(flowGeneratedImports));
        this.assertOnce("import $cssFromFile_1 from", output.get(flowGeneratedImports));
    }

    @Test
    public void themeForCssImports_eagerLoaded() throws Exception {
        Class[] testClasses = new Class[]{ThemeForCssImport.class, UI.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        this.assertOnce("import { injectGlobalCss } from", output.get(flowGeneratedImports));
        this.assertOnce("import { css, unsafeCSS, registerStyles } from", output.get(flowGeneratedImports));
        this.assertOnce("from 'Frontend/foo.css?inline';", output.get(flowGeneratedImports));
        this.assertOnce("import $cssFromFile_0 from", output.get(flowGeneratedImports));
    }

    protected void assertOnce(String key, List<String> output) {
        int found = 0;
        for (String row : output) {
            if (!row.contains(key)) continue;
            ++found;
        }
        Assert.assertEquals((String)("Expected one instance of '" + key + "'"), (long)1L, (long)found);
    }

    @Test
    public void importingBinaryFile_importVisitorShouldNotFail() throws IOException, URISyntaxException {
        File newFile = this.resolveImportFile(this.frontendDirectory, this.nodeModulesPath, "./common-js-file.js");
        Files.copy(Paths.get(this.getClass().getClassLoader().getResource("dice.jpg").toURI()), new File(newFile.getParentFile(), "dice.jpg").toPath(), new CopyOption[0]);
        Files.write(newFile.toPath(), Collections.singleton("import './dice.jpg'"), new OpenOption[0]);
        this.updater.run();
    }

    @Test
    public void developmentDependencies_includedInDevelopmentMode() throws IOException, URISyntaxException {
        this.createAndLoadDependencies(false);
        List<String> out = this.updater.getMergedOutput().stream().filter(row -> !row.startsWith("export ")).filter(row -> !row.startsWith("window.Vaadin")).filter(row -> !row.contains("Frontend/generated/flow")).filter(row -> !row.contains("const loadOnDemand")).filter(row -> !row.contains("@vaadin/common-frontend/ConnectionIndicator")).toList();
        Assert.assertEquals(List.of("import 'Frontend/jsm-all.js';", "import 'Frontend/jsm-all2.js';", "import 'Frontend/jsm-dev.js';", "import 'Frontend/js-all.js';", "import 'Frontend/js-all2.js';", "import 'Frontend/js-dev.js';"), out);
    }

    @Test
    public void developmentDependencies_notIncludedInProductionMode() throws IOException, URISyntaxException {
        this.createAndLoadDependencies(true);
        List<String> out = this.updater.getMergedOutput().stream().filter(row -> !row.startsWith("export ")).filter(row -> !row.startsWith("window.Vaadin")).filter(row -> !row.contains("Frontend/generated/flow")).filter(row -> !row.contains("const loadOnDemand")).filter(row -> !row.contains("@vaadin/common-frontend/ConnectionIndicator")).toList();
        Assert.assertEquals(List.of("import 'Frontend/jsm-all.js';", "import 'Frontend/jsm-all2.js';", "import 'Frontend/js-all.js';", "import 'Frontend/js-all2.js';"), out);
    }

    private void createAndLoadDependencies(boolean productionMode) throws IOException {
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./jsm-all.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./jsm-all2.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./js-all.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./js-all2.js");
        if (!productionMode) {
            this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./jsm-dev.js");
            this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./js-dev.js");
        }
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(DevelopmentAndProductionDependencies.class);
        this.options.withProductionMode(productionMode);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
    }

    @Test
    public void multipleThemes_importsOnlyFromActiveTheme() throws Exception {
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./fake-material-theme.js");
        Class[] testClasses = new Class[]{FakeMaterialTheme.class, NodeTestComponents.MainLayout.class, NodeTestComponents.LumoTest.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        String output = String.join((CharSequence)"\n", this.updater.getMergedOutput());
        Assert.assertTrue((boolean)output.contains("import '@vaadin/vaadin-lumo-styles/color.js';"));
        Assert.assertFalse((boolean)output.contains("Frontend/fake-material-theme.js"));
    }

    public void assertFullSortOrder(boolean uiImportSeparated, List<String> expectedJsModuleImports) throws MalformedURLException {
        Class[] testClasses = new Class[]{MainView.class, NodeTestComponents.TranslatedImports.class, NodeTestComponents.LocalP3Template.class, NodeTestComponents.JavaScriptOrder.class, UI.class, AllEagerAppConf.class};
        ClassFinder classFinder = AbstractUpdateImportsTest.getClassFinder(testClasses);
        this.options.withTokenFile(new File(this.tmpRoot, "config/flow-build-info.json"));
        this.updater = new UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        ArrayList<String> expectedImports = new ArrayList<String>();
        ArrayList<String> uiAndGeneratedImports = new ArrayList<String>();
        expectedImports.addAll(expectedJsModuleImports);
        this.getAnntotationsAsStream(JavaScript.class, testClasses).map(JavaScript::value).map(this::updateToImport).forEach(expectedImports::add);
        if (uiImportSeparated) {
            String uiImport = expectedImports.stream().filter(dep -> dep.contains("@vaadin/common-frontend/ConnectionIndicator.js")).findFirst().get();
            expectedImports.remove(uiImport);
            uiAndGeneratedImports.add(uiImport);
        }
        this.updater.getGeneratedModules().stream().map(arg_0 -> ((UpdateImports)this.updater).resolveGeneratedModule(arg_0)).map(this::updateToImport).forEach(uiAndGeneratedImports::add);
        List<String> result = this.updater.getMergedOutput();
        result.removeIf(line -> line.startsWith("import { injectGlobalCss }"));
        result.removeIf(line -> line.startsWith("export "));
        result.removeIf(line -> line.isBlank());
        result.removeIf(line -> line.contains("loadOnDemand"));
        result.removeIf(line -> line.contains("window.Vaadin"));
        expectedImports.addAll(uiAndGeneratedImports);
        Assert.assertEquals(expectedImports, result);
    }

    private <T extends Annotation> Stream<T> getAnntotationsAsStream(Class<T> annotation, Class<?> ... classes) {
        Stream<Object> stream = Stream.empty();
        for (Class<?> clazz : classes) {
            stream = Stream.concat(stream, Stream.of(clazz.getAnnotationsByType(annotation)));
        }
        return stream;
    }

    private String updateToImport(String value) {
        if (value.startsWith("./")) {
            value = value.replace("./", "Frontend/");
        }
        return String.format("import '%s';", value);
    }

    private void assertContainsImports(boolean contains, String ... imports) {
        for (String line : imports) {
            boolean result = this.updater.getMergedOutput().contains("import '" + this.addFrontendAlias(line) + "';");
            String message = "\n  " + (contains ? "NOT " : "") + "FOUND '" + line + " IN: \n" + String.valueOf(this.updater.getMergedOutput());
            if (contains) {
                Assert.assertTrue((String)message, (boolean)result);
                continue;
            }
            Assert.assertFalse((String)message, (boolean)result);
        }
    }

    private void assertImportOrder(String ... imports) {
        int curIndex = -1;
        for (String line : imports) {
            String prefixed = this.addFrontendAlias(line);
            int nextIndex = this.updater.getMergedOutput().indexOf("import '" + prefixed + "';");
            Assert.assertTrue((String)("import '" + prefixed + "' not found"), (nextIndex != -1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("import '" + prefixed + "' appears in the wrong order"), (curIndex <= nextIndex ? 1 : 0) != 0);
            curIndex = nextIndex;
        }
    }

    class UpdateImports
    extends AbstractUpdateImports {
        private Map<File, List<String>> output;
        private List<String> webComponentImports;

        UpdateImports(FrontendDependenciesScanner scanner, Options options) {
            super(options, scanner);
        }

        protected void writeOutput(Map<File, List<String>> output) {
            this.output = output;
        }

        List<String> filterWebComponentImports(List<String> lines) {
            this.webComponentImports = super.filterWebComponentImports(lines);
            return this.webComponentImports;
        }

        public Map<File, List<String>> getOutput() {
            return this.output;
        }

        protected List<String> getMergedOutput() {
            return this.merge(this.output);
        }

        protected Collection<String> getGeneratedModules() {
            return Arrays.asList("generated-modules-foo", "generated-modules-bar");
        }

        protected Logger getLogger() {
            return AbstractUpdateImportsTest.this.logger;
        }

        protected String getImportsNotFoundMessage() {
            return AbstractUpdateImportsTest.ERROR_MSG;
        }
    }

    @LoadDependenciesOnStartup
    static class AllEagerAppConf
    implements AppShellConfigurator {
        AllEagerAppConf() {
        }
    }

    @Route(value="simplecss")
    @CssImport(value="./foo.css")
    public static class FooCssImport
    extends Component {
    }

    @Route(value="simplecss2")
    @CssImport(value="./foo.css")
    public static class FooCssImport2
    extends Component {
    }

    @Route(value="simplecss")
    @CssImport(value="./bar.css")
    public static class BarCssImport
    extends Component {
    }

    @Route(value="themefor")
    @CssImport(value="./foo.css", themeFor="something")
    public static class ThemeForCssImport
    extends Component {
    }

    @Route(value="")
    @JsModule.Container(value={@JsModule(value="./jsm-all.js"), @JsModule(value="./jsm-all2.js", developmentOnly=false), @JsModule(value="./jsm-dev.js", developmentOnly=true)})
    @JavaScript.Container(value={@JavaScript(value="./js-all.js"), @JavaScript(value="./js-all2.js", developmentOnly=false), @JavaScript(value="./js-dev.js", developmentOnly=true)})
    public static class DevelopmentAndProductionDependencies
    extends Component {
    }

    @JsModule(value="./fake-material-theme.js")
    public static class FakeMaterialTheme
    implements AbstractTheme {
        public String getBaseUrl() {
            return "fake-material-base";
        }

        public String getThemeUrl() {
            return null;
        }
    }

    @Route(value="")
    static class MainView
    extends Component {
        NodeTestComponents.TranslatedImports translatedImports;
        NodeTestComponents.LocalP3Template localP3Template;
        NodeTestComponents.JavaScriptOrder javaScriptOrder;

        MainView() {
        }
    }

    @Theme(themeClass=NodeTestComponents.LumoTest.class)
    @CssImport(value="./foo.css")
    public static class ThemeCssImport
    implements AppShellConfigurator {
    }
}

