/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.testutil.FrontendStubs;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public abstract class AbstractNodeUpdatePackagesTest
extends NodeUpdateTestUtil {
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String VAADIN_VERSION = "vaadinVersion";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TaskUpdatePackages packageUpdater;
    private TaskGeneratePackageJson packageCreator;
    private File baseDir;
    private File packageJson;
    private ClassFinder classFinder;
    private File mainNodeModules;
    private File packageLock;
    private Options options;
    private File versions;

    @Before
    public void setup() throws Exception {
        this.baseDir = this.temporaryFolder.getRoot();
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)this.baseDir.getAbsolutePath());
        this.classFinder = (ClassFinder)Mockito.spy((Object)AbstractNodeUpdatePackagesTest.getClassFinder());
        this.options = new MockOptions(this.classFinder, this.baseDir).withBuildDirectory("target").withBundleBuild(true);
        this.packageCreator = new TaskGeneratePackageJson(this.options);
        this.versions = this.temporaryFolder.newFile();
        FileUtils.write((File)this.versions, (CharSequence)"{}", (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.classFinder.getResource("vaadin-core-versions.json")).thenReturn((Object)this.versions.toURI().toURL());
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageJson = new File(this.baseDir, "package.json");
        this.mainNodeModules = new File(this.baseDir, "node_modules/");
        this.packageLock = new File(this.baseDir, "package-lock.json");
    }

    protected abstract FrontendDependenciesScanner getScanner(ClassFinder var1);

    @Test
    public void should_CreatePackageJson() {
        Assert.assertFalse((boolean)this.packageJson.exists());
        this.packageCreator.execute();
        Assert.assertTrue((boolean)this.packageJson.exists());
    }

    @Test
    public void should_not_ModifyPackageJson_WhenAlreadyExists() {
        this.packageCreator.execute();
        Assert.assertTrue((boolean)this.packageCreator.modified);
        this.packageCreator.execute();
        Assert.assertFalse((boolean)this.packageCreator.modified);
    }

    @Test
    public void should_AddNewDependencies() throws Exception {
        this.packageCreator.execute();
        this.packageUpdater.execute();
        Assert.assertTrue((boolean)this.packageCreator.modified);
        Assert.assertTrue((boolean)this.packageUpdater.modified);
        this.assertMainPackageJsonContent();
    }

    @Test
    public void pnpmIsInUse_packageJsonContainsFlowDeps_removeFlowDeps() throws IOException {
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        ObjectNode json = this.packageUpdater.getPackageJson();
        this.getDependencies((JsonNode)json).put("@vaadin/flow-deps", "target/frontend");
        json.put("vaadinAppPackageHash", "e05bfd4b6c6bd20c806b3a0ad1be521bfd775c9b6f8f9c997b0ad1fda834805b");
        Files.write(this.packageJson.toPath(), Collections.singletonList(json.toString()), new OpenOption[0]);
        this.options.withEnablePnpm(true);
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageUpdater.execute();
        this.assertPackageJsonFlowDeps();
    }

    @Test
    public void pnpmIsInUse_packageJsonContainsFlowFrontend_removeFlowFrontend() throws IOException {
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        ObjectNode json = this.packageUpdater.getPackageJson();
        this.getDependencies((JsonNode)json).put("@vaadin/flow-frontend", "target/flow-frontend");
        json.put("vaadinAppPackageHash", "e05bfd4b6c6bd20c806b3a0ad1be521bfd775c9b6f8f9c997b0ad1fda834805b");
        Files.write(this.packageJson.toPath(), Collections.singletonList(json.toString()), new OpenOption[0]);
        this.options.withEnablePnpm(true);
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageUpdater.execute();
        this.assertPackageJsonFlowDeps();
    }

    @Test
    public void pnpmIsInUse_packageLockExists_removePackageLock() throws IOException {
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        Files.write(this.packageLock.toPath(), Collections.singletonList("{}"), new OpenOption[0]);
        this.options.withEnablePnpm(true);
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageUpdater.execute();
        Assert.assertFalse((String)"npm package-lock should be removed for pnpm", (boolean)this.packageLock.exists());
    }

    @Test
    public void npmIsInUse_packageJsonContainsFlowDeps_removeFlowDeps() throws IOException {
        this.packageCreator.execute();
        this.packageUpdater.execute();
        JsonNode packJsonNode = this.getPackageJson(this.packageJson);
        ObjectNode deps = (ObjectNode)packJsonNode.get(DEPENDENCIES);
        deps.put("@vaadin/flow-deps", "foobar");
        this.writePackageJson(this.packageJson, packJsonNode);
        this.packageUpdater.execute();
        this.assertPackageJsonFlowDeps();
    }

    @Test
    public void npmIsInUse_packageJsonContainsFlowFrontend_removeFlowFrontend() throws IOException {
        this.packageCreator.execute();
        this.packageUpdater.execute();
        JsonNode packJsonNode = this.getPackageJson(this.packageJson);
        ObjectNode deps = (ObjectNode)packJsonNode.get(DEPENDENCIES);
        deps.put("@vaadin/flow-frontend", "foobar");
        this.writePackageJson(this.packageJson, packJsonNode);
        this.packageUpdater.execute();
        this.assertPackageJsonFlowDeps();
    }

    @Test
    public void npmIsInUse_packageLockJsonContainsNonPMPMDeps_packageLockNotRemoved() throws IOException {
        this.packageCreator.execute();
        this.packageUpdater.execute();
        Files.write(this.packageLock.toPath(), Collections.singletonList("{  }"), new OpenOption[0]);
        this.packageUpdater.execute();
        Assert.assertTrue((boolean)this.packageLock.exists());
    }

    @Test
    public void unmatchedDevDependency_devDependencyIsRemoved() throws IOException {
        this.packageCreator.execute();
        this.packageUpdater.execute();
        ObjectNode json = this.packageUpdater.getPackageJson();
        String old_dependency = "old_dependency";
        ((ObjectNode)json.get("vaadin").get(DEV_DEPENDENCIES)).put("old_dependency", "1.1.1");
        ((ObjectNode)json.get(DEV_DEPENDENCIES)).put("old_dependency", "1.1.1");
        Files.write(this.packageJson.toPath(), Collections.singletonList(json.toString()), new OpenOption[0]);
        this.packageUpdater.execute();
        json = this.packageUpdater.getPackageJson();
        Assert.assertFalse((String)"Old dev dependency should be removed from vaadin", (boolean)json.get("vaadin").get(DEV_DEPENDENCIES).has("old_dependency"));
        Assert.assertFalse((String)"Old dev dependency should be removed from devDependencies", (boolean)json.get(DEV_DEPENDENCIES).has("old_dependency"));
    }

    @Test
    public void oldVaadinDevDependency_missmatchWithDevDependency_vaadinDependencyIsUpdated() throws IOException {
        this.packageCreator.execute();
        ObjectNode json = this.packageUpdater.getPackageJson();
        String key = "vite";
        String version = (String)this.packageUpdater.getDefaultDevDependencies().get("vite");
        ((ObjectNode)json.get("vaadin").get(DEV_DEPENDENCIES)).put("vite", "v2.8.0");
        ((ObjectNode)json.get(DEV_DEPENDENCIES)).put("vite", version);
        Files.write(this.packageJson.toPath(), Collections.singletonList(json.toString()), new OpenOption[0]);
        this.packageCreator.execute();
        json = this.packageUpdater.getPackageJson();
        Assert.assertEquals((String)"Vaadin dependency should be updated to latest DevDependency", (Object)version, (Object)json.get("vaadin").get(DEV_DEPENDENCIES).get("vite").asString());
        Assert.assertEquals((String)"DevDependency should stay the same as it was", (Object)version, (Object)json.get(DEV_DEPENDENCIES).get("vite").asString());
    }

    @Test
    public void versionsDoNotMatch_inVaadinJson_cleanUpNpm() throws IOException {
        this.packageCreator.execute();
        this.makeNodeModulesAndPackageLock();
        this.packageUpdater.updateVaadinJsonContents(Collections.singletonMap(VAADIN_VERSION, "1.1.1"));
        FileUtils.write((File)this.versions, (CharSequence)"{\"platform\": \"1.2.3\"}", (Charset)StandardCharsets.UTF_8);
        this.packageUpdater.execute();
        this.assertCleanUp();
    }

    @Test
    public void versionsDoNotMatch_inVaadinJson_cleanUpPnpm() throws IOException {
        this.options.withEnablePnpm(true);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), this.options);
        this.packageCreator.execute();
        this.makeNodeModulesAndPackageLock();
        this.packageUpdater.updateVaadinJsonContents(Collections.singletonMap(VAADIN_VERSION, "1.1.1"));
        try (MockedStatic platform = Mockito.mockStatic(Platform.class);){
            platform.when(Platform::getVaadinVersion).thenReturn(Optional.of("1.2.3"));
            this.packageUpdater.execute();
            Assert.assertTrue((boolean)this.mainNodeModules.exists());
            Assert.assertFalse((boolean)this.packageLock.exists());
        }
    }

    @Test
    public void versionsMatch_noCleanUp() throws IOException {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.makeNodeModulesAndPackageLock();
        Files.write(this.packageLock.toPath(), Collections.singletonList(this.makePackageLock("1.1.1").toString()), new OpenOption[0]);
        this.packageUpdater.execute();
        Assert.assertTrue((boolean)this.mainNodeModules.exists());
        Assert.assertTrue((boolean)this.packageLock.exists());
    }

    @Test
    public void versionsMatch_forceCleanUp_cleanUp() throws IOException {
        this.packageCreator.execute();
        this.packageUpdater.execute();
        this.makeNodeModulesAndPackageLock();
        ClassFinder classFinder = AbstractNodeUpdatePackagesTest.getClassFinder();
        this.options.enableNpmFileCleaning(true);
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(classFinder), this.options);
        this.packageUpdater.execute();
        this.assertCleanUp();
    }

    @Test
    public void generatePackageJson_sameDependencies_updaterIsNotModified() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        this.packageUpdater.execute();
        Assert.assertFalse((String)"Modification flag should be false when no dependencies changed.", (boolean)this.packageUpdater.modified);
    }

    @Test
    public void generatePackageJson_sameDependenciesInDifferentOrder_updaterIsNotModified() throws IOException {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        ObjectNode json = (ObjectNode)this.getPackageJson(this.packageJson);
        JsonNode dependencies = json.get(DEPENDENCIES);
        List dependencyKeys = JacksonUtils.getKeys((JsonNode)dependencies);
        Collections.shuffle(dependencyKeys);
        ObjectNode newDependencies = JacksonUtils.createObjectNode();
        dependencyKeys.forEach(key -> newDependencies.put(key, dependencies.get(key).asString()));
        json.set(DEPENDENCIES, (JsonNode)newDependencies);
        Files.write(this.packageJson.toPath(), Collections.singletonList(json.toString()), new OpenOption[0]);
        this.packageUpdater.execute();
        Assert.assertFalse((String)"Modification flag should be false when no dependencies changed.", (boolean)this.packageUpdater.modified);
    }

    @Test
    public void generatePackageJson_removedDependencies_updaterIsModified() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        packages.remove("@vaadin/vaadin-checkbox");
        this.packageUpdater.execute();
        Assert.assertTrue((String)"Modification flag should be true when dependency removed.", (boolean)this.packageUpdater.modified);
    }

    @Test
    public void generatePackageJson_addedDependencies_updaterIsModified() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        packages.put("@vaadin/vaadin-list-box", "1.1.1");
        this.packageUpdater.execute();
        Assert.assertTrue((String)"Modification flag should be true when dependency added.", (boolean)this.packageUpdater.modified);
    }

    @Test
    public void generatePackageJson_noDependencies_updaterIsNotModified() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap packages = new HashMap();
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        Assert.assertTrue((String)"Modification flag should be true as we have added default dependencies.", (boolean)this.packageUpdater.modified);
        this.packageUpdater.execute();
        Assert.assertFalse((String)"Modification flag should be false when there has never been dependencies.", (boolean)this.packageUpdater.modified);
    }

    @Test
    public void updatedPackageJson_noDependencies_creatorAndUpdatedIsMarkedModified() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap packages = new HashMap();
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        Assert.assertTrue((String)"Modification flag should be true when main package was created.", (boolean)this.packageCreator.modified);
        Assert.assertTrue((String)"Modification flag should be true as we should have updated the hash for default dependencies.", (boolean)this.packageUpdater.modified);
    }

    @Test
    public void userAddedDependencies_notCleanedByUpdater() throws IOException {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        JsonNode json = this.getPackageJson(this.packageJson);
        ((ObjectNode)json.get(DEPENDENCIES)).put("@custom/timer", "3.3.0");
        Files.write(this.packageJson.toPath(), Collections.singletonList(json.toString()), new OpenOption[0]);
        this.packageUpdater.execute();
        JsonNode dependencies = this.getPackageJson(this.packageJson).get(DEPENDENCIES);
        Assert.assertTrue((boolean)dependencies.has("@custom/timer"));
        Assert.assertEquals((Object)"3.3.0", (Object)dependencies.get("@custom/timer").asString());
    }

    @Test
    public void legacyPackageJson_isCleanedCorrectly_pnpm() throws IOException {
        String legacyPackageContent = this.getLegacyPackageContent();
        Files.write(this.packageJson.toPath(), Collections.singletonList(legacyPackageContent), new OpenOption[0]);
        this.options.withEnablePnpm(true);
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageUpdater.execute();
        this.assertPackageJsonFlowDeps();
    }

    @Test
    public void legacyPackageJson_isCleanedCorrectly_npm() throws IOException {
        String legacyPackageContent = this.getLegacyPackageContent();
        Files.write(this.packageJson.toPath(), Collections.singletonList(legacyPackageContent), new OpenOption[0]);
        this.packageUpdater = new TaskUpdatePackages(this.getScanner(this.classFinder), this.options);
        this.packageUpdater.execute();
        this.assertPackageJsonFlowDeps();
    }

    @Test
    public void frameworkManagedPackages_versionsAreUpdated() throws IOException {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        JsonNode dependencies = this.getPackageJson(this.packageJson).get(DEPENDENCIES);
        for (Map.Entry entry : packages.entrySet()) {
            Assert.assertTrue((boolean)dependencies.has((String)entry.getKey()));
            Assert.assertEquals(entry.getValue(), (Object)dependencies.get((String)entry.getKey()).asString());
        }
        packages.clear();
        packages.put("@polymer/iron-list", "3.1.0");
        packages.put("@vaadin/vaadin-confirm-dialog", "2.0.0");
        packages.put("@vaadin/vaadin-checkbox", "3.1.1");
        packages.put("@polymer/iron-icon", "3.0.3");
        packages.put("@vaadin/vaadin-time-picker", "2.0.3");
        this.packageUpdater.execute();
        dependencies = this.getPackageJson(this.packageJson).get(DEPENDENCIES);
        for (Map.Entry entry : packages.entrySet()) {
            Assert.assertTrue((boolean)dependencies.has((String)entry.getKey()));
            Assert.assertEquals(entry.getValue(), (Object)dependencies.get((String)entry.getKey()).asString());
        }
    }

    @Test
    public void removedFrameworkDependencies_dependencyIsRemoved() throws IOException {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@polymer/iron-list", "3.0.2");
        packages.put("@vaadin/vaadin-confirm-dialog", "1.1.4");
        packages.put("@vaadin/vaadin-checkbox", "2.2.10");
        packages.put("@polymer/iron-icon", "3.0.1");
        packages.put("@vaadin/vaadin-time-picker", "2.0.2");
        Mockito.when((Object)frontendDependencies.getPackages()).thenReturn(packages);
        this.packageUpdater = new TaskUpdatePackages((FrontendDependenciesScanner)frontendDependencies, this.options);
        this.packageCreator.execute();
        this.packageUpdater.execute();
        packages.remove("@vaadin/vaadin-checkbox");
        JsonNode dependencies = this.getPackageJson(this.packageJson).get(DEPENDENCIES);
        Assert.assertTrue((String)"vaadin-checkbox is missing from the dependencies", (boolean)dependencies.has("@vaadin/vaadin-checkbox"));
        dependencies = this.getPackageJson(this.packageJson).get("vaadin").get(DEPENDENCIES);
        Assert.assertTrue((String)"vaadin-checkbox is missing from vaadin.dependencies", (boolean)dependencies.has("@vaadin/vaadin-checkbox"));
        this.packageUpdater.execute();
        dependencies = this.getPackageJson(this.packageJson).get(DEPENDENCIES);
        Assert.assertFalse((String)"vaadin-checkbox is still available in the dependencies", (boolean)dependencies.has("@vaadin/vaadin-checkbox"));
        dependencies = this.getPackageJson(this.packageJson).get("vaadin").get(DEPENDENCIES);
        Assert.assertFalse((String)"vaadin-checkbox is still available in vaadin.dependencies", (boolean)dependencies.has("@vaadin/vaadin-checkbox"));
    }

    public String getLegacyPackageContent() {
        return "{\n  \"name\": \"no-name\",\n  \"license\": \"UNLICENSED\",\n  \"vaadin\": {\n    \"dependencies\": {\n      \"@vaadin/router\": \"^1.6.0\",\n      \"@polymer/polymer\": \"3.4.1\",\n      \"@vaadin/vaadin-ordered-layout\": \"1.1.0\",\n      \"@vaadin/vaadin-combo-box\": \"5.0.11\",\n      \"@vaadin/vaadin-lumo-styles\": \"1.6.0\",\n      \"@vaadin/vaadin-material-styles\": \"1.3.2\"\n    },\n    \"devDependencies\": {\n      \"webpack-dev-server\": \"3.10.3\"\n    },\n    \"hash\": \"72bdea1adb5aa0d1259db10a6f76872d996db31d2c312d0c7849eb39de92835e\"\n  },\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.6.0\",\n    \"@polymer/polymer\": \"3.4.1\",\n    \"@vaadin/flow-deps\": \"./target/frontend\",\n    \"@vaadin/vaadin-ordered-layout\": \"1.1.0\",\n    \"@vaadin/vaadin-combo-box\": \"5.0.11\",\n    \"@vaadin/vaadin-lumo-styles\": \"1.6.0\",\n    \"@vaadin/vaadin-material-styles\": \"1.3.2\"\n  },\n  \"devDependencies\": {\n    \"webpack-dev-server\": \"3.10.3\"\n  },\n\"vaadinAppPackageHash\": \"e05bfd4b6c6bd20c806b3a0ad1be521bfd775c9b6f8f9c997b0ad1fda834805b\"\n}\n";
    }

    private void makeNodeModulesAndPackageLock() throws IOException {
        this.mainNodeModules.mkdirs();
        Files.write(this.packageLock.toPath(), Collections.singletonList("{}"), new OpenOption[0]);
        Assert.assertTrue((boolean)this.mainNodeModules.exists());
        Assert.assertTrue((boolean)this.packageLock.exists());
    }

    private void assertCleanUp() {
        Assert.assertFalse((boolean)this.mainNodeModules.exists());
        Assert.assertTrue((String)"package-lock should not be removed", (boolean)this.packageLock.exists());
    }

    private void assertMainPackageJsonContent() throws IOException {
        ObjectNode json = this.packageUpdater.getPackageJson();
        Assert.assertTrue((boolean)json.has("name"));
        Assert.assertTrue((boolean)json.has("license"));
        JsonNode dependencies = json.get(DEPENDENCIES);
        for (Map.Entry entry : this.packageUpdater.getDefaultDependencies().entrySet()) {
            Assert.assertTrue((String)("Missing '" + (String)entry.getKey() + "' package"), (boolean)dependencies.has((String)entry.getKey()));
        }
        JsonNode devDependencies = json.get(DEV_DEPENDENCIES);
        for (Map.Entry entry : this.packageUpdater.getDefaultDevDependencies().entrySet()) {
            Assert.assertTrue((String)("Missing '" + (String)entry.getKey() + "' package"), (boolean)devDependencies.has((String)entry.getKey()));
        }
        Assert.assertFalse((boolean)dependencies.has("@vaadin/flow-frontend"));
    }

    private ObjectNode getDependencies(JsonNode json) {
        return (ObjectNode)json.get(DEPENDENCIES);
    }

    private ObjectNode makePackageLock(String version) {
        ObjectNode object = JacksonUtils.createObjectNode();
        ObjectNode deps = JacksonUtils.createObjectNode();
        ObjectNode shrinkWrap = JacksonUtils.createObjectNode();
        object.set(DEPENDENCIES, (JsonNode)deps);
        shrinkWrap.put("version", version);
        return object;
    }

    private void assertPackageJsonFlowDeps() throws IOException {
        JsonNode packJsonNode = this.getPackageJson(this.packageJson);
        JsonNode deps = packJsonNode.get(DEPENDENCIES);
        Assert.assertFalse((boolean)deps.has("@vaadin/flow-deps"));
        Assert.assertFalse((boolean)deps.has("@vaadin/flow-frontend"));
        Assert.assertFalse((boolean)deps.has("vaadinAppPackageHash"));
        Assert.assertFalse((boolean)deps.has("@polymer/polymer"));
        Assert.assertTrue((boolean)packJsonNode.get("vaadin").has("hash"));
    }

    JsonNode getPackageJson(File packageFile) throws IOException {
        ObjectNode packageJson = null;
        if (packageFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)packageFile, (String)StandardCharsets.UTF_8.name());
            packageJson = JacksonUtils.readTree((String)fileContent);
        }
        return packageJson;
    }

    void writePackageJson(File packageJsonFile, JsonNode packageJson) throws IOException {
        FileIOUtils.writeIfChanged((File)packageJsonFile, (String)packageJson.toString());
    }
}

