/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.MockLogger;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;

public abstract class AbstractNodeUpdateImportsTest
extends NodeUpdateTestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private File importsFile;
    private File frontendDirectory;
    private File nodeModulesPath;
    private TaskUpdateImports updater;
    private MockLogger logger;

    @Before
    public void setup() throws Exception {
        File tmpRoot = this.temporaryFolder.getRoot();
        this.logger = new MockLogger();
        this.frontendDirectory = new File(tmpRoot, "./src/main/frontend/");
        this.nodeModulesPath = new File(tmpRoot, "node_modules/");
        this.importsFile = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        ClassFinder classFinder = AbstractNodeUpdateImportsTest.getClassFinder();
        Options options = new MockOptions(classFinder, tmpRoot).withFrontendDirectory(this.frontendDirectory).withBuildDirectory("target").withProductionMode(true).withBundleBuild(true);
        this.updater = new TaskUpdateImports(this.getScanner(classFinder), options){

            Logger log() {
                return AbstractNodeUpdateImportsTest.this.logger;
            }
        };
        Assert.assertTrue((boolean)this.nodeModulesPath.mkdirs());
        this.createExpectedImports(this.frontendDirectory, this.nodeModulesPath);
        Assert.assertTrue((boolean)new File(new File(new File(this.frontendDirectory, "generated/"), "jar-resources"), "ExampleConnector.js").exists());
    }

    protected abstract FrontendDependenciesScanner getScanner(ClassFinder var1);

    @Test
    public void generateImportsFile_fileContainsThemeLinesAndExpectedImportsAndCssImportLinesAndLogReports() throws Exception {
        ArrayList<String> expectedLines = new ArrayList<String>();
        expectedLines.addAll(this.getExpectedImports());
        expectedLines.add("import '@vaadin/vaadin-mixed-component/src/vaadin-something-else'");
        expectedLines.add("import 'unresolved/component';");
        expectedLines.add("import \\$cssFromFile_\\d from '@vaadin/vaadin-mixed-component/bar.css\\?inline'");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\$cssFromFile_\\d from 'Frontend/foo.css\\?inline';");
        expectedLines.add("import \\{ css, unsafeCSS, registerStyles \\} from '@vaadin/vaadin-themable-mixin';");
        expectedLines.add("injectGlobalCss\\(\\$cssFromFile_\\d.toString\\(\\), 'CSSImport end', document\\);");
        expectedLines.add("injectGlobalCss\\(\\$cssFromFile_\\d.toString\\(\\), 'CSSImport end', document\\);");
        expectedLines.add("function addCssBlock\\(block\\) \\{");
        expectedLines.add("addCssBlock\\(`<style include=\"bar\">\\$\\{\\$css_\\d\\}</style>`\\);");
        expectedLines.add("registerStyles\\('', \\$css_\\d, \\{moduleId: 'baz'\\}\\);");
        expectedLines.add("registerStyles\\('', \\$css_\\d, \\{include: 'bar', moduleId: 'baz'\\}\\);");
        expectedLines.add("registerStyles\\('foo-bar', \\$css_\\d, \\{moduleId: 'flow_css_mod_\\d'\\}\\);");
        expectedLines.add("registerStyles\\('foo-bar', \\$css_\\d, \\{include: 'bar', moduleId: 'flow_css_mod_\\d'\\}\\);");
        Assert.assertFalse((boolean)this.importsFile.exists());
        this.updater.execute();
        Assert.assertTrue((boolean)this.importsFile.exists());
        this.assertContainsImports(true, expectedLines.toArray(new String[0]));
        String output = this.logger.getLogs();
        this.assertContains(output, true, "Use the './' prefix for files in JAR files: 'ExampleConnector.js'", "Use the './' prefix for files in the '" + this.frontendDirectory.getPath().replace("\\", "\\\\") + "' folder: 'vaadin-mixed-component/src/vaadin-mixed-component.js'");
        this.assertContains(output, true, "Failed to find the following imports in the `node_modules` tree:", "unresolved/component");
    }

    @Test
    public void noChanges_generatedJsFileIsNotUpdated() throws Exception {
        this.updater.execute();
        long timestamp1 = this.importsFile.lastModified();
        this.sleep(1000);
        this.updater.execute();
        long timestamp2 = this.importsFile.lastModified();
        Assert.assertEquals((long)timestamp1, (long)timestamp2);
    }

    @Test
    public void removeJsModuleImportFromFile_importIsReadedAfterRegeneration() throws Exception {
        this.updater.execute();
        this.removeImports("@vaadin/vaadin-lumo-styles/sizing.js", "./local-template.js");
        this.assertContainsImports(false, "@vaadin/vaadin-lumo-styles/sizing.js", "./local-template.js");
        this.updater.execute();
        this.assertContainsImports(true, "@vaadin/vaadin-lumo-styles/sizing.js", "./local-template.js");
    }

    @Test
    public void addModuleImportManuallyIntoGeneratedFile_importIsRemovedAfterRegeneration() throws Exception {
        this.updater.execute();
        this.addImports("./added-import.js");
        this.assertContainsImports(true, "./added-import.js");
        this.updater.execute();
        this.assertContainsImports(false, "./added-import.js");
    }

    @Test
    public void addAndRemoveJsModuleImports_addedImportIsNotPreseredAfterRegeneration() throws Exception {
        this.updater.execute();
        this.removeImports("@vaadin/vaadin-lumo-styles/sizing.js", "./local-template.js");
        this.addImports("./added-import.js");
        this.assertContainsImports(false, "@vaadin/vaadin-lumo-styles/sizing.js", "./local-template.js");
        this.assertContainsImports(true, "./added-import.js");
        this.updater.execute();
        this.assertContainsImports(false, "./added-import.js");
    }

    private void assertContainsImports(boolean contains, String ... imports) throws IOException {
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        for (String line : imports) {
            this.assertContains(content, contains, this.addFrontendAlias(line));
        }
    }

    private void assertContains(String content, boolean contains, String ... checks) {
        for (String importString : checks) {
            boolean result = Pattern.compile(importString).matcher(content).find();
            String message = "\n  " + (contains ? "NOT " : "") + "FOUND '" + importString + " IN: \n" + content;
            if (contains) {
                Assert.assertTrue((String)message, (boolean)result);
                continue;
            }
            Assert.assertFalse((String)message, (boolean)result);
        }
    }

    private void assertImportOrder(String ... imports) throws IOException {
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        int curIndex = -1;
        for (String line : imports) {
            String prefixed = this.addFrontendAlias(line);
            int nextIndex = content.indexOf(prefixed);
            Assert.assertTrue((String)("import '" + prefixed + "' not found"), (nextIndex != -1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("import '" + prefixed + "' appears in the wrong order"), (curIndex <= nextIndex ? 1 : 0) != 0);
            curIndex = nextIndex;
        }
    }

    private void removeImports(String ... imports) throws IOException {
        List<String> importsList = Arrays.asList(imports);
        List current = FileUtils.readLines((File)this.importsFile, (Charset)Charset.defaultCharset());
        Set removed = current.stream().filter(line -> importsList.stream().map(this::addFrontendAlias).anyMatch(line::contains)).collect(Collectors.toSet());
        current.removeAll(removed);
        String content = String.join((CharSequence)"\n", current);
        this.replaceJsFile(content + "\n", new OpenOption[0]);
    }

    private void addImports(String ... imports) throws IOException {
        String content = Arrays.stream(imports).map(this::addFrontendAlias).map(s -> "import '" + s + "';").collect(Collectors.joining("\n"));
        this.replaceJsFile(content + "\n", StandardOpenOption.APPEND);
    }

    private void replaceJsFile(String content, OpenOption ... options) throws IOException {
        Files.write(Paths.get(this.importsFile.toURI()), content.getBytes(StandardCharsets.UTF_8), options);
    }
}

