/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.server.communication.rpc.AttachExistingElementRpcHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class AttachExistingElementRpcHandlerTest {
    @Test
    public void handleNode_error() {
        AttachExistingElementRpcHandler handler = new AttachExistingElementRpcHandler();
        int requestedId = 1;
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("attachReqId", requestedId);
        object.put("attachAssignedId", -1);
        object.put("attachTagName", "div");
        object.put("attachIndex", -1);
        StateNode node = (StateNode)Mockito.mock(StateNode.class);
        StateNode requested = (StateNode)Mockito.mock(StateNode.class);
        StateTree tree = (StateTree)Mockito.mock(StateTree.class);
        Mockito.when((Object)node.getOwner()).thenReturn((Object)tree);
        Mockito.when((Object)tree.getNodeById(requestedId)).thenReturn((Object)requested);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Node parentNode = (Node)Mockito.mock(Node.class);
        ChildElementConsumer consumer = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Element sibling = (Element)Mockito.mock(Element.class);
        feature.register(parentNode, sibling, requested, consumer);
        Mockito.when((Object)((AttachExistingElementFeature)node.getFeature(AttachExistingElementFeature.class))).thenReturn((Object)feature);
        handler.handleNode(node, (JsonNode)object);
        ((ChildElementConsumer)Mockito.verify((Object)consumer)).onError(parentNode, "div", sibling);
        this.assertNodeIsUnregistered(node, requested, feature);
    }

    @Test
    public void handleNode_requestedIdEqualsAssignedId() {
        AttachExistingElementRpcHandler handler = new AttachExistingElementRpcHandler();
        int requestedId = 1;
        int index = 2;
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("attachReqId", requestedId);
        object.put("attachAssignedId", requestedId);
        object.put("attachTagName", "div");
        object.put("attachIndex", index);
        StateNode node = (StateNode)Mockito.mock(StateNode.class);
        StateNode requested = (StateNode)Mockito.mock(StateNode.class);
        StateTree tree = (StateTree)Mockito.mock(StateTree.class);
        Mockito.when((Object)node.getOwner()).thenReturn((Object)tree);
        Mockito.when((Object)tree.getNodeById(requestedId)).thenReturn((Object)requested);
        Mockito.when((Object)requested.hasFeature((Class)Mockito.any())).thenReturn((Object)true);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Node parentNode = (Node)Mockito.mock(Node.class);
        ChildElementConsumer consumer = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Element sibling = (Element)Mockito.mock(Element.class);
        feature.register(parentNode, sibling, requested, consumer);
        Mockito.when((Object)((AttachExistingElementFeature)node.getFeature(AttachExistingElementFeature.class))).thenReturn((Object)feature);
        handler.handleNode(node, (JsonNode)object);
        this.assertNodeIsUnregistered(node, requested, feature);
        ((Node)Mockito.verify((Object)parentNode)).insertChild(index, new Element[]{Element.get((StateNode)requested)});
        ((ChildElementConsumer)Mockito.verify((Object)consumer)).accept(Element.get((StateNode)requested));
    }

    @Test
    public void handleNode_requestedIdAndAssignedIdAreDifferent() {
        AttachExistingElementRpcHandler handler = new AttachExistingElementRpcHandler();
        int requestedId = 1;
        int assignedId = 2;
        int index = 3;
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("attachReqId", requestedId);
        object.put("attachAssignedId", assignedId);
        object.put("attachTagName", "div");
        object.put("attachIndex", index);
        StateNode node = (StateNode)Mockito.mock(StateNode.class);
        StateNode requested = (StateNode)Mockito.mock(StateNode.class);
        StateNode assigned = (StateNode)Mockito.mock(StateNode.class);
        StateTree tree = (StateTree)Mockito.mock(StateTree.class);
        Mockito.when((Object)node.getOwner()).thenReturn((Object)tree);
        Mockito.when((Object)tree.getNodeById(requestedId)).thenReturn((Object)requested);
        Mockito.when((Object)tree.getNodeById(assignedId)).thenReturn((Object)assigned);
        Mockito.when((Object)assigned.hasFeature((Class)Mockito.any())).thenReturn((Object)true);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Node parentNode = (Node)Mockito.mock(Node.class);
        ChildElementConsumer consumer = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Element sibling = (Element)Mockito.mock(Element.class);
        feature.register(parentNode, sibling, requested, consumer);
        Mockito.when((Object)((AttachExistingElementFeature)node.getFeature(AttachExistingElementFeature.class))).thenReturn((Object)feature);
        handler.handleNode(node, (JsonNode)object);
        this.assertNodeIsUnregistered(node, requested, feature);
        ((Node)Mockito.verify((Object)parentNode, (VerificationMode)Mockito.times((int)0))).insertChild(index, new Element[]{Element.get((StateNode)assigned)});
        ((ChildElementConsumer)Mockito.verify((Object)consumer)).accept(Element.get((StateNode)assigned));
    }

    private void assertNodeIsUnregistered(StateNode node, StateNode requested, AttachExistingElementFeature feature) {
        ((StateNode)Mockito.verify((Object)requested)).setParent(null);
        Assert.assertNull((Object)feature.getParent(requested));
        Assert.assertNull((Object)feature.getCallback(requested));
        Assert.assertNull((Object)feature.getPreviousSibling(node));
    }
}

