/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.UploadException;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamReceiverHandler;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class StreamReceiverHandlerTest {
    private StreamReceiverHandler handler;
    @Mock
    private VaadinResponse response;
    @Mock
    private StreamVariable streamVariable;
    @Mock
    private StateNode stateNode;
    private VaadinRequest request;
    @Mock
    private UI ui;
    @Mock
    private UIInternals uiInternals;
    @Mock
    private StateTree stateTree;
    @Mock
    private VaadinSession session;
    @Mock
    private OutputStream responseOutput;
    @Mock
    private StreamReceiver streamReceiver;
    @Mock
    private StreamResourceRegistry registry;
    @Mock
    private ErrorHandler errorHandler;
    private VaadinServletService mockService;
    private final int uiId = 123;
    private final int nodeId = 1233;
    private final String variableName = "name";
    private final String expectedSecurityKey = "key";
    private String contentLength;
    private ServletInputStream inputStream;
    private OutputStream outputStream;
    private String contentType;
    private List<Part> parts;
    private boolean isGetContentLengthLongCalled;
    private String requestCharacterEncoding;
    private String xFilenameHeader;

    @Before
    public void setup() throws Exception {
        this.contentLength = "6";
        this.inputStream = this.createInputStream("foobar");
        this.outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        this.contentType = "foobar";
        this.parts = Collections.emptyList();
        MockitoAnnotations.initMocks((Object)this);
        this.handler = new StreamReceiverHandler();
        this.mockService = new MockVaadinServletService();
        this.mockRequest();
        this.mockReceiverAndRegistry();
        this.mockUi();
        Mockito.when((Object)this.streamReceiver.getNode()).thenReturn((Object)this.stateNode);
        Mockito.when((Object)this.stateNode.isAttached()).thenReturn((Object)true);
        Mockito.when((Object)this.streamVariable.getOutputStream()).thenAnswer(invocationOnMock -> this.outputStream);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.responseOutput);
        Mockito.when((Object)this.session.getErrorHandler()).thenReturn((Object)((ErrorHandler)Mockito.mock(ErrorHandler.class)));
    }

    private void mockReceiverAndRegistry() {
        Mockito.when((Object)this.session.getResourceRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)this.registry.getResource((URI)Mockito.any())).thenReturn(Optional.of(this.streamReceiver));
        Mockito.when((Object)this.streamReceiver.getId()).thenReturn((Object)"key");
        Mockito.when((Object)this.streamReceiver.getStreamVariable()).thenReturn((Object)this.streamVariable);
    }

    private void mockRequest() throws IOException {
        HttpServletRequest servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)servletRequest.getContentLength()).thenAnswer(invocationOnMock -> Integer.parseInt(this.contentLength));
        this.request = new VaadinServletRequest(servletRequest, this.mockService){

            public String getParameter(String name) {
                if ("restartApplication".equals(name) || "ignoreRestart".equals(name) || "closeApplication".equals(name)) {
                    return null;
                }
                return "1";
            }

            public String getPathInfo() {
                return "/VAADIN/dynamic/resource/123/1233/name/key";
            }

            public String getMethod() {
                return "POST";
            }

            public ServletInputStream getInputStream() throws IOException {
                return StreamReceiverHandlerTest.this.inputStream;
            }

            public String getHeader(String name) {
                if ("content-length".equals(name.toLowerCase())) {
                    return StreamReceiverHandlerTest.this.contentLength;
                }
                if ("x-filename".equals(name.toLowerCase())) {
                    return StreamReceiverHandlerTest.this.xFilenameHeader;
                }
                if ("content-type".equals(name.toLowerCase())) {
                    return StreamReceiverHandlerTest.this.contentType;
                }
                return super.getHeader(name);
            }

            public String getContentType() {
                return StreamReceiverHandlerTest.this.contentType;
            }

            public Collection<Part> getParts() throws IOException, ServletException {
                return StreamReceiverHandlerTest.this.parts;
            }

            public long getContentLengthLong() {
                StreamReceiverHandlerTest.this.isGetContentLengthLongCalled = true;
                return 0L;
            }

            public String getCharacterEncoding() {
                return StreamReceiverHandlerTest.this.requestCharacterEncoding;
            }
        };
    }

    private ServletInputStream createInputStream(final String content) {
        return new ServletInputStream(this){
            boolean finished = false;
            int counter = 0;
            byte[] msg = content.getBytes();

            public boolean isFinished() {
                return this.finished;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                if (this.counter > this.msg.length + 1) {
                    throw new AssertionError((Object)"-1 was ignored by StreamReceiverHandler.");
                }
                if (this.counter >= this.msg.length) {
                    ++this.counter;
                    this.finished = true;
                    return -1;
                }
                return this.msg[this.counter++];
            }
        };
    }

    private Part createPart(InputStream inputStream, String contentType, String name, long size) throws IOException {
        Part part = (Part)Mockito.mock(Part.class);
        Mockito.when((Object)part.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)part.getContentType()).thenReturn((Object)contentType);
        Mockito.when((Object)part.getSubmittedFileName()).thenReturn((Object)name);
        Mockito.when((Object)part.getSize()).thenReturn((Object)size);
        return part;
    }

    private void mockUi() {
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)this.uiInternals);
        Mockito.when((Object)this.uiInternals.getStateTree()).thenReturn((Object)this.stateTree);
        Mockito.when((Object)this.stateTree.getNodeById(Mockito.anyInt())).thenReturn((Object)this.stateNode);
        Mockito.when((Object)this.session.getUIById(123)).thenReturn((Object)this.ui);
    }

    @Test
    public void doHandleXhrFilePost_outputStreamGetterThrows_responseStatusIs500() throws IOException {
        ((StreamVariable)Mockito.doThrow(RuntimeException.class).when((Object)this.streamVariable)).getOutputStream();
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 1L);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void doHandleXhrFilePost_outputStreamThrowsOnWrite_responseStatusIs500() throws IOException {
        ((OutputStream)Mockito.doThrow(RuntimeException.class).when((Object)this.outputStream)).write((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt());
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 1L);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void doHandleXhrFilePost_happyPath_setContentTypeNoExplicitSetStatus() throws IOException {
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 1L);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("text/html; charset=utf-8");
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setStatus(Mockito.anyInt());
    }

    @Test
    public void doHandleMultipartFileUpload_noPart_uploadFailed_responseStatusIs500() throws IOException {
        this.handler.doHandleMultipartFileUpload(this.session, this.request, this.response, this.streamReceiver, this.stateNode);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void doHandleMultipartFileUpload_hasParts_uploadFailed_responseStatusIs500() throws IOException {
        this.contentType = "multipart/form-data; boundary=----WebKitFormBoundary7NsWHeCJVZNwi6ll";
        this.inputStream = this.createInputStream("------WebKitFormBoundary7NsWHeCJVZNwi6ll\nContent-Disposition: form-data; name=\"file\"; filename=\"EBookJP.txt\"\nContent-Type: text/plain\n\n\n------WebKitFormBoundary7NsWHeCJVZNwi6ll--");
        ((OutputStream)Mockito.doThrow(RuntimeException.class).when((Object)this.outputStream)).write((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt());
        this.contentLength = "99";
        this.parts = new ArrayList<Part>();
        this.parts.add(this.createPart((InputStream)this.createInputStream("foobar"), "text/plain", "EBookJP.txt", 6L));
        this.handler.doHandleMultipartFileUpload(this.session, this.request, this.response, this.streamReceiver, this.stateNode);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void exceptionIsThrownOnUnexpectedEnd() throws IOException {
        this.contentType = "multipart/form-data; boundary=----WebKitFormBoundary7NsWHeCJVZNwi6ll";
        this.inputStream = this.createInputStream("------WebKitFormBoundary7NsWHeCJVZNwi6ll\nContent-Disposition: form-data; name=\"file\"; filename=\"EBookJP.txt\"\nContent-Type: text/plain\n\n\n------WebKitFormBoundary7NsWHeCJVZNwi6ll--");
        this.contentLength = "99";
        this.handler.doHandleMultipartFileUpload(this.session, this.request, this.response, null, null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void responseIsSentOnCorrectSecurityKey() throws IOException {
        this.handler.handleRequest(this.session, this.request, this.response, this.streamReceiver, String.valueOf(123), "key");
        ((OutputStream)Mockito.verify((Object)this.responseOutput)).close();
    }

    @Test
    public void responseIsNotSentOnIncorrectSecurityKey() throws IOException {
        Mockito.when((Object)this.streamReceiver.getId()).thenReturn((Object)"another key expected");
        this.handler.handleRequest(this.session, this.request, this.response, this.streamReceiver, String.valueOf(123), "key");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.responseOutput});
    }

    @Test
    public void responseIsNotSentOnMissingSecurityKey() throws IOException {
        Mockito.when((Object)this.streamReceiver.getId()).thenReturn(null);
        this.handler.handleRequest(this.session, this.request, this.response, this.streamReceiver, String.valueOf(123), "key");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.responseOutput});
    }

    @Test
    public void partsAreUsedDirectlyIfPresentWithoutParsingInput() throws IOException {
        this.contentType = "multipart/form-data; boundary=----WebKitFormBoundary7NsWHeCJVZNwi6ll";
        this.inputStream = this.createInputStream("------WebKitFormBoundary7NsWHeCJVZNwi6ll\nContent-Disposition: form-data; name=\"file\"; filename=\"EBookJP.txt\"\nContent-Type: text/plain\n\n\n------WebKitFormBoundary7NsWHeCJVZNwi6ll--");
        this.outputStream = new ByteArrayOutputStream();
        this.contentLength = "99";
        String fileName = "EBookJP.txt";
        String contentType = "text/plain";
        this.parts = new ArrayList<Part>();
        this.parts.add(this.createPart((InputStream)this.createInputStream("foobar"), "text/plain", "EBookJP.txt", 6L));
        this.handler.handleRequest(this.session, this.request, this.response, this.streamReceiver, String.valueOf(123), "key");
        ((OutputStream)Mockito.verify((Object)this.responseOutput)).close();
        ArgumentCaptor endEventArgumentCaptor = ArgumentCaptor.forClass(StreamVariable.StreamingEndEvent.class);
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFinished((StreamVariable.StreamingEndEvent)endEventArgumentCaptor.capture());
        Assert.assertEquals((Object)"foobar", (Object)new String(((ByteArrayOutputStream)this.outputStream).toByteArray()));
        Assert.assertEquals((Object)"EBookJP.txt", (Object)((StreamVariable.StreamingEndEvent)endEventArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"text/plain", (Object)((StreamVariable.StreamingEndEvent)endEventArgumentCaptor.getValue()).getMimeType());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("text/html; charset=utf-8");
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setStatus(Mockito.anyInt());
    }

    @Test
    public void handleFileUploadValidationAndData_inputStreamThrowsIOException_exceptionIsNotRethrown_exceptionIsNotHandlerByErrorHandler() throws UploadException {
        InputStream inputStream = new InputStream(this){

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        };
        this.handler.handleFileUploadValidationAndData(this.session, inputStream, this.streamReceiver, null, null, 0L, this.stateNode);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorHandler});
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFailed((StreamVariable.StreamingErrorEvent)Mockito.any());
    }

    @Test
    public void handleFileUploadValidationAndData_inputStreamThrowsIOExceptionOnClose_exceptionIsNotRethrown_exceptionIsNotHandlerByErrorHandler() throws UploadException {
        InputStream inputStream = new InputStream(this){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        this.handler.handleFileUploadValidationAndData(this.session, inputStream, this.streamReceiver, null, null, 0L, this.stateNode);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorHandler});
    }

    @Test
    public void doHandleMultipartFileUpload_IOExceptionIsThrown_exceptionIsNotRethrown_exceptionIsNotHandlerByErrorHandler() throws IOException, ServletException {
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ((VaadinServletRequest)Mockito.doThrow(IOException.class).when((Object)request)).getParts();
        this.handler.doHandleMultipartFileUpload(this.session, (VaadinRequest)request, this.response, this.streamReceiver, this.stateNode);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorHandler});
    }

    @Test
    public void doHandleXhrFilePost_filenameFromHeader_extractedCorrectly() throws IOException {
        this.xFilenameHeader = "test.txt";
        this.outputStream = new ByteArrayOutputStream();
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 6L);
        ArgumentCaptor endEventCaptor = ArgumentCaptor.forClass(StreamVariable.StreamingEndEvent.class);
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFinished((StreamVariable.StreamingEndEvent)endEventCaptor.capture());
        Assert.assertEquals((Object)"test.txt", (Object)((StreamVariable.StreamingEndEvent)endEventCaptor.getValue()).getFileName());
    }

    @Test
    public void doHandleXhrFilePost_encodedFilename_decodedCorrectly() throws IOException {
        this.xFilenameHeader = "my%20file%20%C3%A5%C3%A4%C3%B6.txt";
        this.outputStream = new ByteArrayOutputStream();
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 6L);
        ArgumentCaptor endEventCaptor = ArgumentCaptor.forClass(StreamVariable.StreamingEndEvent.class);
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFinished((StreamVariable.StreamingEndEvent)endEventCaptor.capture());
        Assert.assertEquals((Object)"my file \u00e5\u00e4\u00f6.txt", (Object)((StreamVariable.StreamingEndEvent)endEventCaptor.getValue()).getFileName());
    }

    @Test
    public void doHandleXhrFilePost_contentTypeFromHeader_extractedCorrectly() throws IOException {
        this.xFilenameHeader = "test.txt";
        this.contentType = "text/plain";
        this.outputStream = new ByteArrayOutputStream();
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 6L);
        ArgumentCaptor endEventCaptor = ArgumentCaptor.forClass(StreamVariable.StreamingEndEvent.class);
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFinished((StreamVariable.StreamingEndEvent)endEventCaptor.capture());
        Assert.assertEquals((Object)"text/plain", (Object)((StreamVariable.StreamingEndEvent)endEventCaptor.getValue()).getMimeType());
    }

    @Test
    public void doHandleXhrFilePost_missingContentTypeHeader_defaultsToUnknown() throws IOException {
        this.xFilenameHeader = "test.txt";
        this.contentType = null;
        this.outputStream = new ByteArrayOutputStream();
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 6L);
        ArgumentCaptor endEventCaptor = ArgumentCaptor.forClass(StreamVariable.StreamingEndEvent.class);
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFinished((StreamVariable.StreamingEndEvent)endEventCaptor.capture());
        Assert.assertEquals((Object)"unknown", (Object)((StreamVariable.StreamingEndEvent)endEventCaptor.getValue()).getMimeType());
    }

    @Test
    public void doHandleXhrFilePost_missingFilenameHeader_defaultsToUnknown() throws IOException {
        this.xFilenameHeader = null;
        this.outputStream = new ByteArrayOutputStream();
        this.handler.doHandleXhrFilePost(this.session, this.request, this.response, this.streamReceiver, this.stateNode, 6L);
        ArgumentCaptor endEventCaptor = ArgumentCaptor.forClass(StreamVariable.StreamingEndEvent.class);
        ((StreamVariable)Mockito.verify((Object)this.streamVariable)).streamingFinished((StreamVariable.StreamingEndEvent)endEventCaptor.capture());
        Assert.assertEquals((Object)"unknown", (Object)((StreamVariable.StreamingEndEvent)endEventCaptor.getValue()).getFileName());
    }
}

