/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class VisibilityDataTest {
    @Test
    public void setVisible() {
        StateNode node = new StateNode(new Class[]{ElementData.class});
        ElementData data = (ElementData)node.getFeature(ElementData.class);
        Assert.assertNull((Object)data.get("visible"));
        Assert.assertTrue((boolean)data.isVisible());
        data.put("visible", (Serializable)Boolean.valueOf(true));
        Assert.assertTrue((boolean)data.isVisible());
        data.put("visible", (Serializable)Boolean.valueOf(false));
        Assert.assertFalse((boolean)data.isVisible());
    }

    @Test
    public void allowsChanges_delegateToIsVisible() {
        ElementData data = (ElementData)Mockito.mock(ElementData.class);
        ((ElementData)Mockito.doCallRealMethod().when((Object)data)).allowsChanges();
        Mockito.when((Object)data.isVisible()).thenReturn((Object)true);
        Assert.assertTrue((boolean)data.allowsChanges());
        Mockito.when((Object)data.isVisible()).thenReturn((Object)false);
        Assert.assertFalse((boolean)data.allowsChanges());
    }
}

