/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.shared.ui.Transport;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class PushConfigurationMapTest
extends AbstractNodeFeatureTest<PushConfigurationMap> {
    private PushConfigurationMap ns = (PushConfigurationMap)this.createFeature();

    @Test
    public void transportWebsocket() {
        this.ns.setTransport(Transport.WEBSOCKET);
        Assert.assertEquals((Object)Transport.WEBSOCKET.getIdentifier(), (Object)this.ns.getParameter("transport"));
        Assert.assertFalse((boolean)this.ns.contains("alwaysXhrToServer"));
        Assert.assertEquals((Object)Transport.WEBSOCKET, (Object)this.ns.getTransport());
    }

    @Test
    public void transportLongPolling() {
        this.ns.setTransport(Transport.LONG_POLLING);
        Assert.assertEquals((Object)Transport.LONG_POLLING.getIdentifier(), (Object)this.ns.getParameter("transport"));
        Assert.assertFalse((boolean)this.ns.contains("alwaysXhrToServer"));
        Assert.assertEquals((Object)Transport.LONG_POLLING, (Object)this.ns.getTransport());
    }

    @Test
    public void transportLongWebsocketXHR() {
        this.ns.setTransport(Transport.WEBSOCKET_XHR);
        Assert.assertEquals((Object)Transport.WEBSOCKET.getIdentifier(), (Object)this.ns.getParameter("transport"));
        Assert.assertTrue((boolean)((Boolean)this.ns.get("alwaysXhrToServer")));
        Assert.assertEquals((Object)Transport.WEBSOCKET_XHR, (Object)this.ns.getTransport());
    }

    @Test
    public void fallbackTransportLongPolling() {
        this.ns.setFallbackTransport(Transport.LONG_POLLING);
        Assert.assertEquals((Object)Transport.LONG_POLLING.getIdentifier(), (Object)this.ns.getParameter("fallbackTransport"));
        Assert.assertEquals((Object)Transport.LONG_POLLING, (Object)this.ns.getFallbackTransport());
    }

    @Test
    public void fallbackTransportWebsocket() {
        this.ns.setFallbackTransport(Transport.WEBSOCKET);
        Assert.assertEquals((Object)Transport.WEBSOCKET.getIdentifier(), (Object)this.ns.getParameter("fallbackTransport"));
        Assert.assertEquals((Object)Transport.WEBSOCKET, (Object)this.ns.getFallbackTransport());
    }

    @Test(expected=IllegalArgumentException.class)
    public void fallbackTransportWebsocketXHR() {
        this.ns.setFallbackTransport(Transport.WEBSOCKET_XHR);
    }

    @Test
    public void parameterNames() {
        this.ns.setParameter("foo", "bar");
        Assert.assertArrayEquals((Object[])new String[]{"foo"}, (Object[])this.ns.getParameterNames().toArray());
        this.ns.setTransport(Transport.WEBSOCKET);
        this.ns.setFallbackTransport(Transport.LONG_POLLING);
        Object[] expected = new String[]{"foo", "transport", "fallbackTransport"};
        Collection paramNames = this.ns.getParameterNames();
        Object[] actual = paramNames.toArray(new String[paramNames.size()]);
        Arrays.sort(expected);
        Arrays.sort(actual);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }
}

