/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AttachExistingElementFeatureTest {
    @Test
    public void register_dataIsAvailaleByNode() {
        StateNode node = new StateNode(new Class[0]);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Element element = (Element)Mockito.mock(Element.class);
        StateNode child = (StateNode)Mockito.mock(StateNode.class);
        ChildElementConsumer callback = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Node parent = (Node)Mockito.mock(Node.class);
        feature.register(parent, element, child, callback);
        ((StateNode)Mockito.verify((Object)child)).setParent(node);
        Assert.assertEquals((Object)callback, (Object)feature.getCallback(child));
        Assert.assertEquals((Object)parent, (Object)feature.getParent(child));
        Assert.assertEquals((Object)element, (Object)feature.getPreviousSibling(child));
    }

    @Test
    public void forEachChild_register_registeredStatNodeIsAChild() {
        StateNode node = new StateNode(new Class[0]);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Element element = (Element)Mockito.mock(Element.class);
        StateNode child = (StateNode)Mockito.mock(StateNode.class);
        ChildElementConsumer callback = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Node parent = (Node)Mockito.mock(Node.class);
        feature.register(parent, element, child, callback);
        ArrayList children = new ArrayList(1);
        feature.forEachChild(children::add);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals((Object)child, children.get(0));
    }

    @Test
    public void unregister_dataIsNotAvailaleByNode() {
        StateNode node = new StateNode(new Class[0]);
        AttachExistingElementFeature feature = new AttachExistingElementFeature(node);
        Element element = (Element)Mockito.mock(Element.class);
        StateNode child = (StateNode)Mockito.mock(StateNode.class);
        ChildElementConsumer callback = (ChildElementConsumer)Mockito.mock(ChildElementConsumer.class);
        Node parent = (Node)Mockito.mock(Node.class);
        feature.register(parent, element, child, callback);
        feature.unregister(child);
        Assert.assertNull((Object)feature.getCallback(child));
        Assert.assertNull((Object)feature.getParent(child));
        Assert.assertNull((Object)feature.getPreviousSibling(child));
    }
}

