/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

class SimpleMultipartParser {
    private final BufferedReader reader;
    private final String boundary;
    private boolean lastPartRead = false;
    private String pushedBackLine = null;

    public SimpleMultipartParser(byte[] data, String boundary) {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
        this.boundary = "--" + boundary;
    }

    public String readHeaders() throws IOException {
        String line;
        if (this.lastPartRead) {
            return null;
        }
        StringBuilder headers = new StringBuilder();
        if (this.pushedBackLine != null) {
            line = this.pushedBackLine;
            this.pushedBackLine = null;
        } else {
            while ((line = this.reader.readLine()) != null && !line.startsWith(this.boundary)) {
            }
        }
        if (line == null) {
            return null;
        }
        if (line.equals(this.boundary + "--")) {
            this.lastPartRead = true;
            return null;
        }
        while ((line = this.reader.readLine()) != null && !line.isEmpty()) {
            headers.append(line).append("\n");
        }
        return headers.toString();
    }

    public void readBodyData(ByteArrayOutputStream outputStream) throws IOException {
        String line;
        boolean firstLine = true;
        while ((line = this.reader.readLine()) != null) {
            if (line.startsWith(this.boundary)) {
                this.pushedBackLine = line;
                if (line.equals(this.boundary + "--")) {
                    this.lastPartRead = true;
                }
                return;
            }
            if (!firstLine) {
                outputStream.write(13);
                outputStream.write(10);
            }
            firstLine = false;
            outputStream.write(line.getBytes(StandardCharsets.UTF_8));
        }
    }
}

