/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.ValueSignal;
import org.junit.Assert;
import org.junit.Test;

public class ElementBindVisibleTest
extends SignalsUnitTest {
    @Test
    public void bindVisible_elementAttachedBefore_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertTrue((boolean)element.isVisible());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        Assert.assertFalse((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementAttachedAfter_bindingActive() {
        Element element = new Element("foo");
        Assert.assertTrue((boolean)element.isVisible());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertFalse((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementAttached_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        Assert.assertFalse((boolean)element.isVisible());
        signal.value((Object)true);
        Assert.assertTrue((boolean)element.isVisible());
        signal.value(null);
        Assert.assertFalse((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementNotAttached_bindingInactive() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementDetached_bindingInactive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        element.removeFromParent();
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_elementReAttached_bindingActivate() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        element.removeFromParent();
        signal.value((Object)false);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertFalse((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_setVisibleAndBindVisibleWhileBindingIsActive_throwException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.bindVisible((Signal)new ValueSignal((Object)true));
        Assert.assertThrows(BindingActiveException.class, () -> element.setVisible(false));
        Assert.assertThrows(BindingActiveException.class, () -> element.bindVisible((Signal)new ValueSignal((Object)true)));
        Assert.assertTrue((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_withNullBinding_removesBinding() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        Assert.assertTrue((boolean)element.isVisible());
        element.bindVisible(null);
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_withNullBinding_removesBindingPreserveState() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindVisible((Signal)signal);
        Assert.assertFalse((boolean)element.isVisible());
        element.bindVisible(null);
        Assert.assertFalse((boolean)element.isVisible());
        Assert.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindVisible_withNullBinding_allowsSetVisible() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindVisible((Signal)signal);
        Assert.assertTrue((boolean)element.isVisible());
        element.bindVisible(null);
        element.setVisible(false);
        Assert.assertFalse((boolean)element.isVisible());
    }
}

