/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ElementBindEnabledTest {
    private static MockVaadinServletService service;
    private MockedStatic<FeatureFlags> featureFlagStaticMock;
    private MockUI ui;
    private LinkedList<ErrorEvent> events;

    @BeforeClass
    public static void init() {
        MockedStatic featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        ElementBindEnabledTest.featureFlagEnabled((MockedStatic<FeatureFlags>)featureFlagStaticMock);
        service = new MockVaadinServletService();
        ElementBindEnabledTest.close((MockedStatic<FeatureFlags>)featureFlagStaticMock);
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Before
    public void before() {
        this.featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        ElementBindEnabledTest.featureFlagEnabled(this.featureFlagStaticMock);
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @After
    public void after() {
        Assert.assertTrue((boolean)this.events.isEmpty());
        ElementBindEnabledTest.close(this.featureFlagStaticMock);
        this.events = null;
        this.ui = null;
    }

    private static void featureFlagEnabled(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        FeatureFlags flags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Mockito.when((Object)flags.isEnabled(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId())).thenReturn((Object)true);
        featureFlagStaticMock.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn((Object)flags);
    }

    private static void close(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        CurrentInstance.clearAll();
        featureFlagStaticMock.close();
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        this.ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Test
    public void bindEnabled_elementAttachedBefore_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertTrue((boolean)element.isEnabled());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindEnabled((Signal)signal);
        Assert.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementAttachedAfter_bindingActive() {
        Element element = new Element("foo");
        Assert.assertTrue((boolean)element.isEnabled());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindEnabled((Signal)signal);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementAttached_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindEnabled((Signal)signal);
        Assert.assertFalse((boolean)element.isEnabled());
        signal.value((Object)true);
        Assert.assertTrue((boolean)element.isEnabled());
        signal.value(null);
        Assert.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementNotAttached_bindingInactive() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementDetached_bindingInactive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        element.removeFromParent();
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementReAttached_bindingActivate() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        element.removeFromParent();
        signal.value((Object)false);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assert.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_setEnabledAndBindEnabledWhileBindingIsActive_throwException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.bindEnabled((Signal)new ValueSignal((Object)true));
        Assert.assertThrows(BindingActiveException.class, () -> element.setEnabled(false));
        Assert.assertThrows(BindingActiveException.class, () -> element.bindEnabled((Signal)new ValueSignal((Object)true)));
        Assert.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_withNullBinding_removesBinding() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        Assert.assertTrue((boolean)element.isEnabled());
        element.bindEnabled(null);
        signal.value((Object)false);
        Assert.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_withNullBinding_allowsSetEnabled() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        Assert.assertTrue((boolean)element.isEnabled());
        element.bindEnabled(null);
        element.setEnabled(false);
        Assert.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_lazyInitSignalBindingFeature() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.setEnabled(false);
        element.isEnabled();
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assert.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindEnabled_implicitlyDisabledComponent_isEnabledReturnsFalse() {
        TestComponent component = new TestComponent();
        component.bindEnabled((Signal)new ValueSignal((Object)true));
        TestComponent parent = new TestComponent();
        parent.setEnabled(false);
        parent.add(new Component[]{component});
        UI.getCurrent().add(new Component[]{parent});
        Assert.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void bindEnabled_implicitlyDisabledComponent_detach_componentBecomesEnabled() {
        TestComponent component = new TestComponent();
        component.bindEnabled((Signal)new ValueSignal((Object)true));
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        UI.getCurrent().add(new Component[]{parent});
        parent.setEnabled(false);
        parent.remove(new Component[]{component});
        Assert.assertTrue((boolean)component.isEnabled());
    }

    @Test
    public void bindEnabled_explicitlyDisabledComponent_enableParent_componentRemainsDisabled() {
        TestComponent component = new TestComponent();
        component.bindEnabled((Signal)new ValueSignal((Object)false));
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        UI.getCurrent().add(new Component[]{parent});
        parent.setEnabled(false);
        Assert.assertFalse((boolean)component.isEnabled());
        parent.setEnabled(true);
        Assert.assertFalse((boolean)component.isEnabled());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasComponents {
        private TestComponent() {
        }
    }
}

