/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.internal.ComponentMetaData;
import com.vaadin.flow.dom.DisabledUpdateMode;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class ComponentMetaDataTest {
    @Test
    public void synchronizedProperties_methodInClass() {
        this.assertFooProperty(Sample.class);
    }

    @Test
    public void synchronizedProperties_methodInInterface() {
        this.assertFooProperty(HasFooImpl.class, DisabledUpdateMode.ALWAYS);
    }

    @Test
    public void synchronizedProperties_protectedMethod() {
        this.assertFooProperty(HasFooProtected.class);
    }

    @Test
    public void synchronizedProperties_packagePrivateMethod() {
        this.assertFooProperty(HasFooPackagePrivate.class);
    }

    @Test
    public void synchronizedProperties_privateMethod() {
        this.assertFooProperty(HasFooPrivate.class);
    }

    @Test
    public void synchronizedProperties_hasOverriddenMethod() {
        ComponentMetaData data = new ComponentMetaData(SubClass.class);
        Collection props = data.getSynchronizedProperties();
        Assert.assertEquals((long)2L, (long)props.size());
        List bazProps = props.stream().filter(prop -> prop.getProperty().equals("baz")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)bazProps.size());
        ComponentMetaData.SynchronizedPropertyInfo info = (ComponentMetaData.SynchronizedPropertyInfo)bazProps.get(0);
        List events = info.getEventNames().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"bar", events.get(0));
        Assert.assertTrue((boolean)props.stream().anyMatch(prop -> prop.getProperty().equals("bar")));
    }

    @Test
    public void synchronizedProperties_overridesMethodAndProperty() {
        ComponentMetaData data = new ComponentMetaData(ChangeSyncProperty.class);
        Collection props = data.getSynchronizedProperties();
        Assert.assertEquals((long)1L, (long)props.size());
        ComponentMetaData.SynchronizedPropertyInfo info = (ComponentMetaData.SynchronizedPropertyInfo)props.iterator().next();
        Assert.assertEquals((Object)"foo", (Object)info.getProperty());
        List events = info.getEventNames().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"baz", events.get(0));
    }

    private void assertFooProperty(Class<? extends Component> clazz) {
        this.assertFooProperty(clazz, DisabledUpdateMode.ONLY_WHEN_ENABLED);
    }

    private void assertFooProperty(Class<? extends Component> clazz, DisabledUpdateMode mode) {
        ComponentMetaData data = new ComponentMetaData(clazz);
        Collection props = data.getSynchronizedProperties();
        Assert.assertEquals((long)1L, (long)props.size());
        ComponentMetaData.SynchronizedPropertyInfo info = (ComponentMetaData.SynchronizedPropertyInfo)props.iterator().next();
        Assert.assertEquals((Object)"baz", (Object)info.getProperty());
        Assert.assertEquals((Object)mode, (Object)info.getUpdateMode());
        List events = info.getEventNames().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)"bar", events.get(0));
    }

    @Tag(value="a")
    public static class Sample
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        public String getFoo() {
            return null;
        }

        public String getBar() {
            return null;
        }
    }

    @Tag(value="a")
    public static class HasFooImpl
    extends Component
    implements HasFoo {
        @Override
        public String getFoo() {
            return null;
        }
    }

    public static class HasFooProtected
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        protected String getFoo() {
            return null;
        }
    }

    public static class HasFooPackagePrivate
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        String getFoo() {
            return null;
        }
    }

    public static class HasFooPrivate
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        private String getFoo() {
            return null;
        }
    }

    public static class SubClass
    extends Sample {
        @Override
        public String getFoo() {
            return null;
        }

        @Synchronize(value={"foo"}, property="bar")
        public String getBaz() {
            return null;
        }
    }

    public static class ChangeSyncProperty
    extends Sample {
        @Override
        @Synchronize(value={"baz"}, property="foo")
        public String getFoo() {
            return null;
        }
    }

    public static interface HasFoo {
        @Synchronize(value={"bar"}, property="baz", allowUpdates=DisabledUpdateMode.ALWAYS)
        public String getFoo();
    }
}

