/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;

public class RegistrationTest {
    @Test
    public void once_onlyCalledOnce() {
        AtomicBoolean invoked = new AtomicBoolean();
        Command & Serializable action = (Command & Serializable)() -> {
            boolean calledPreviously = invoked.getAndSet(true);
            Assert.assertFalse((String)"Command should not invoked previously", (boolean)calledPreviously);
        };
        Registration registration = Registration.once((Command)action);
        Assert.assertFalse((String)"Command should not yet be invoked", (boolean)invoked.get());
        registration.remove();
        Assert.assertTrue((String)"Command should be invoked", (boolean)invoked.get());
        registration.remove();
    }

    @Test
    public void combine_removesAll() {
        AtomicBoolean firstRemoved = new AtomicBoolean();
        AtomicBoolean secondRemoved = new AtomicBoolean();
        Registration registration = Registration.combine((Registration[])new Registration[]{(Registration & Serializable)() -> firstRemoved.set(true), (Registration & Serializable)() -> secondRemoved.set(true)});
        Assert.assertFalse((String)"Should not be removed yet", (boolean)firstRemoved.get());
        Assert.assertFalse((String)"Should not be removed yet", (boolean)secondRemoved.get());
        registration.remove();
        Assert.assertTrue((String)"Should be removed now", (boolean)firstRemoved.get());
        Assert.assertTrue((String)"Should be removed now", (boolean)secondRemoved.get());
    }

    @Test
    public void addAndRemove_addsAndRemoves() {
        ArrayList collection = new ArrayList();
        Object o1 = new Object();
        Object o2 = new Object();
        Registration r1 = Registration.addAndRemove(collection, (Object)o1);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertTrue((boolean)collection.contains(o1));
        Registration r2 = Registration.addAndRemove(collection, (Object)o2);
        Assert.assertEquals((long)2L, (long)collection.size());
        Assert.assertTrue((boolean)collection.contains(o2));
        r1.remove();
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertFalse((boolean)collection.contains(o1));
        r2.remove();
        Assert.assertTrue((boolean)collection.isEmpty());
    }
}

