/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.dau.FlowDauIntegration;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import jakarta.servlet.http.Cookie;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class FlowDauIntegrationTest {
    @Test
    public void generateNewCookie_setsUpExpectedParameters() {
        try (MockedStatic key = Mockito.mockStatic(DauIntegration.class);){
            key.when(DauIntegration::newTrackingHash).thenReturn((Object)"hash");
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
            Cookie cookie = FlowDauIntegration.generateNewCookie((VaadinRequest)request);
            String[] hashAndTime = cookie.getValue().split("\\$");
            Assert.assertEquals((Object)"hash", (Object)hashAndTime[0]);
            Assert.assertFalse((boolean)hashAndTime[1].isBlank());
            Assert.assertEquals((Object)"DailyActiveUser", (Object)cookie.getName());
            Assert.assertTrue((boolean)cookie.isHttpOnly());
            Assert.assertTrue((boolean)cookie.getSecure());
            Assert.assertEquals((long)86400L, (long)cookie.getMaxAge());
            Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        }
    }

    @Test
    public void generateNewCookie_notSecureRequest_cookieNotSecure() {
        try (MockedStatic key = Mockito.mockStatic(DauIntegration.class);){
            key.when(DauIntegration::newTrackingHash).thenReturn((Object)"hash");
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
            Cookie cookie = FlowDauIntegration.generateNewCookie((VaadinRequest)request);
            Assert.assertFalse((boolean)cookie.getSecure());
        }
    }
}

