/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ConstantsUsageStatsEnvTest {
    private String runIsolated(Boolean setEnv, String value) throws IOException, InterruptedException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpath, "com.vaadin.flow.server.PrintDefaultDevModeStatsMain");
        Map<String, String> env = builder.environment();
        if (setEnv == null || !setEnv.booleanValue()) {
            env.remove("VAADIN_USAGE_STATS_ENABLED");
        } else {
            env.put("VAADIN_USAGE_STATS_ENABLED", value);
        }
        builder.redirectErrorStream(true);
        Process process = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            int exit = process.waitFor();
            if (exit != 0) {
                throw new AssertionError((Object)("Child JVM exited with code " + exit + "; output: " + line));
            }
            String string = line == null ? "" : line.trim();
            return string;
        }
    }

    @Test
    public void whenEnvNotSet_statsEnabledByDefault() throws Exception {
        String out = this.runIsolated(false, null);
        Assert.assertEquals((Object)"true", (Object)out);
    }

    @Test
    public void whenEnvFalse_statsDisabled() throws Exception {
        String out = this.runIsolated(true, "false");
        Assert.assertEquals((Object)"false", (Object)out);
    }

    @Test
    public void whenEnvFALSE_statsDisabled() throws Exception {
        String out = this.runIsolated(true, "FALSE");
        Assert.assertEquals((Object)"false", (Object)out);
    }

    @Test
    public void whenEnvTrue_statsEnabled() throws Exception {
        String out = this.runIsolated(true, "true");
        Assert.assertEquals((Object)"true", (Object)out);
    }

    @Test
    public void whenEnvRandom_statsEnabled() throws Exception {
        String out = this.runIsolated(true, "random-value");
        Assert.assertEquals((Object)"true", (Object)out);
    }
}

