/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.WebComponentExporterTest;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class WebComponentConfigurationFactoryTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private WebComponentExporter.WebComponentConfigurationFactory factory = new WebComponentExporter.WebComponentConfigurationFactory();

    @Test
    public void create_constructsValidConfiguration() {
        WebComponentConfiguration config1 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class).create());
        WebComponentConfiguration config2 = this.factory.create((WebComponentExporter)new MyComponentExporter());
        Assert.assertNotNull((String)"create() from class should have been successful", (Object)config1);
        Assert.assertNotNull((String)"create() from instance should have been successful", (Object)config2);
    }

    @Test
    public void create_instance_throwsOnNullArgument() {
        this.expectedEx.expect(NullPointerException.class);
        this.expectedEx.expectMessage("'exporter'");
        this.factory.create(null);
    }

    @Test
    public void create_configuration_hashCode() {
        WebComponentConfiguration myComponentConfig = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class).create());
        WebComponentConfiguration similarConfig1 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter1.class).create());
        WebComponentConfiguration similarConfig2 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter2.class).create());
        WebComponentConfiguration similarConfig3 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter3.class).create());
        Assert.assertNotEquals((String)"Configurations with different tags should have not have same hashCodes", (long)myComponentConfig.hashCode(), (long)similarConfig1.hashCode());
        Assert.assertNotEquals((String)"Configurations with same tag, but different properties should not have same hashCodes", (long)similarConfig1.hashCode(), (long)similarConfig2.hashCode());
        Assert.assertEquals((String)"Configurations with same tag and same properties but different defaults should have the same hashCode", (long)similarConfig2.hashCode(), (long)similarConfig3.hashCode());
    }

    @Test
    public void create_configuration_equals() {
        WebComponentConfiguration myComponentConfig = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class).create());
        WebComponentConfiguration similarConfig1 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter1.class).create());
        WebComponentConfiguration similarConfig2 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter2.class).create());
        WebComponentConfiguration similarConfig3 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter3.class).create());
        Assert.assertNotEquals((String)"Configurations with different tags should not be equal", (Object)myComponentConfig, (Object)similarConfig1);
        Assert.assertNotEquals((String)"Configurations with same tag, but different properties should not be equal", (Object)similarConfig1, (Object)similarConfig2);
        Assert.assertEquals((String)"Configurations with same tag and same properties but different defaults should be equal", (Object)similarConfig2, (Object)similarConfig3);
    }

    public static class MyComponentExporter
    extends WebComponentExporter<WebComponentExporterTest.MyComponent> {
        public MyComponentExporter() {
            super("my-component");
        }

        public void configureInstance(WebComponent<WebComponentExporterTest.MyComponent> webComponent, WebComponentExporterTest.MyComponent component) {
        }
    }

    public static class SimilarExporter1
    extends WebComponentExporter<MyComponent> {
        public SimilarExporter1() {
            super("tag");
            this.addProperty("string", "dog");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class SimilarExporter2
    extends WebComponentExporter<MyComponent> {
        public SimilarExporter2() {
            super("tag");
            this.addProperty("int", 0);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class SimilarExporter3
    extends WebComponentExporter<MyComponent> {
        public SimilarExporter3() {
            super("tag");
            this.addProperty("int", 1);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class NoDefaultConstructorExporter
    extends WebComponentExporter<MyComponent> {
        public NoDefaultConstructorExporter(String tag) {
            super(tag);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class NullTagExporter
    extends WebComponentExporter<MyComponent> {
        public NullTagExporter() {
            super(null);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class MyComponent
    extends Component {
    }
}

