/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import java.io.Serializable;
import org.junit.Assert;

public class ValueChangeMonitor<T> {
    HasValue.ValueChangeEvent<T> capturedEvent;

    public ValueChangeMonitor(HasValue<?, T> obserable) {
        obserable.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.capturedEvent != null) {
                Assert.fail((String)("There is already an event. Old event: " + String.valueOf(this.capturedEvent) + ", new event: " + String.valueOf(event)));
            }
            Assert.assertSame((Object)obserable, (Object)event.getHasValue());
            if (event instanceof AbstractField.ComponentValueChangeEvent) {
                Assert.assertSame((Object)obserable, (Object)((AbstractField.ComponentValueChangeEvent)event).getSource());
            }
            this.capturedEvent = event;
        });
    }

    public void discard() {
        Assert.assertNotNull((String)"There should be an event", this.capturedEvent);
        this.capturedEvent = null;
    }

    public void assertEvent(boolean fromClient, T oldValue, T newValue) {
        Assert.assertNotNull((String)"There should be an event", this.capturedEvent);
        Assert.assertTrue((fromClient == this.capturedEvent.isFromClient() ? 1 : 0) != 0);
        ValueChangeMonitor.assertEventValues(this.capturedEvent, oldValue, newValue);
        this.discard();
    }

    public void assertNoEvent() {
        Assert.assertNull((String)"There should be no event", this.capturedEvent);
    }

    public static <T> void assertEventValues(HasValue.ValueChangeEvent<T> event, T oldValue, T newValue) {
        Assert.assertEquals(oldValue, (Object)event.getOldValue());
        Assert.assertEquals(newValue, (Object)event.getValue());
    }
}

