/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class ShortCutRegistrationFilterTest {
    private static String invokeGenerateEventModifierFilter(List<Key> list) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method privateMethod = ShortcutRegistration.class.getDeclaredMethod("generateEventModifierFilter", Collection.class);
        privateMethod.setAccessible(true);
        String result = (String)privateMethod.invoke(null, list);
        return result;
    }

    private static Object getHashableKey(KeyModifier keyModifier) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> nestedClass = Class.forName("com.vaadin.flow.component.ShortcutRegistration$HashableKey");
        Constructor<?> ctor = nestedClass.getDeclaredConstructors()[0];
        ctor.setAccessible(true);
        return ctor.newInstance(keyModifier);
    }

    private static ArrayList<String> getModifierFilterConditions(String eventModifierFilter, int expectedFilterCount) {
        ArrayList<String> filterConditions = new ArrayList<String>(Arrays.asList(eventModifierFilter.split(" && ", Integer.MAX_VALUE)));
        Assert.assertTrue((String)"Split filter conditions should not contain '&' character or blank strings.", (boolean)filterConditions.stream().filter(c -> c.contains("&") || StringUtils.isBlank((CharSequence)c)).collect(Collectors.toList()).isEmpty());
        Assert.assertEquals((long)expectedFilterCount, (long)filterConditions.size());
        return filterConditions;
    }

    @Test
    public void testGenerateEventModifierFilterWithModifierKeyAlt() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String result = ShortCutRegistrationFilterTest.invokeGenerateEventModifierFilter(Collections.singletonList((Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.ALT)));
        ArrayList<String> conditions = ShortCutRegistrationFilterTest.getModifierFilterConditions(result, 4);
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('Alt')"));
        Assert.assertTrue((boolean)conditions.contains("!event.getModifierState('Control')"));
        Assert.assertFalse((boolean)conditions.contains("event.getModifierState('AltGraph')"));
        Assert.assertFalse((boolean)conditions.contains("!event.getModifierState('AltGraph')"));
    }

    @Test
    public void testGenerateEventModifierFilterWithModifierKeyAltGr() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String result = ShortCutRegistrationFilterTest.invokeGenerateEventModifierFilter(Collections.singletonList((Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.ALT_GRAPH)));
        ArrayList<String> conditions = ShortCutRegistrationFilterTest.getModifierFilterConditions(result, 5);
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('AltGraph')"));
        Assert.assertTrue((boolean)conditions.contains("!event.getModifierState('Alt')"));
        Assert.assertTrue((boolean)conditions.contains("!event.getModifierState('Control')"));
    }

    @Test
    public void testGenerateEventModifierFilterWithModifierKeyAltAndAltGr() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String result = ShortCutRegistrationFilterTest.invokeGenerateEventModifierFilter(Arrays.asList((Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.ALT), (Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.ALT_GRAPH)));
        ArrayList<String> conditions = ShortCutRegistrationFilterTest.getModifierFilterConditions(result, 5);
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('Alt')"));
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('AltGraph')"));
        Assert.assertTrue((boolean)conditions.contains("!event.getModifierState('Control')"));
    }

    @Test
    public void testGenerateEventModifierFilterWithModifierKeyAltGrAndCtrl() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String result = ShortCutRegistrationFilterTest.invokeGenerateEventModifierFilter(Arrays.asList((Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.ALT_GRAPH), (Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.CONTROL)));
        ArrayList<String> conditions = ShortCutRegistrationFilterTest.getModifierFilterConditions(result, 5);
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('AltGraph')"));
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('Control')"));
        Assert.assertTrue((boolean)conditions.contains("!event.getModifierState('Alt')"));
    }

    @Test
    public void testGenerateEventModifierFilterWithModifierKeyAltAndCtrl() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String result = ShortCutRegistrationFilterTest.invokeGenerateEventModifierFilter(Arrays.asList((Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.ALT), (Key)ShortCutRegistrationFilterTest.getHashableKey(KeyModifier.CONTROL)));
        ArrayList<String> conditions = ShortCutRegistrationFilterTest.getModifierFilterConditions(result, 4);
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('Alt')"));
        Assert.assertTrue((boolean)conditions.contains("event.getModifierState('Control')"));
        Assert.assertFalse((boolean)conditions.contains("event.getModifierState('AltGraph')"));
        Assert.assertFalse((boolean)conditions.contains("!event.getModifierState('AltGraph')"));
    }
}

