/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.ValueChangeMonitor;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.tests.PublicApiAnalyzer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class AbstractFieldTest {
    private static void assertNoEvents(HasValue<?, ?> observable) {
        observable.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assert.fail((String)("Got unexpected event: " + String.valueOf(event))));
    }

    @Test
    public void initialValue_used() {
        TestAbstractField<String> field = new TestAbstractField<String>("foo");
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void emptyValue_sameAsInitial() {
        TestAbstractField<String> field = new TestAbstractField<String>("foo");
        Assert.assertEquals((Object)"foo", (Object)field.getEmptyValue());
        field.setValue("bar");
        Assert.assertEquals((String)"Empty value shouldn't change when value is changed", (Object)"foo", (Object)field.getEmptyValue());
    }

    @Test
    public void initialValue_defaultNull() {
        TestAbstractField field = new TestAbstractField();
        Assert.assertNull((Object)field.getValue());
        Assert.assertNull(field.getEmptyValue());
    }

    @Test
    public void setValue_differentValue_firesOneEvent() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor<String> eventMonitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        field.setValue("Foo");
        eventMonitor.assertEvent(false, null, "Foo");
        Assert.assertEquals((Object)"Foo", field.presentationValue);
    }

    @Test
    public void setValue_sameValue_firesNoEvent() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor eventMonitor = new ValueChangeMonitor(field);
        field.setValue((String)field.getValue());
        eventMonitor.assertNoEvent();
    }

    @Test
    public void clear_firesIfNotEmpty() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor<String> eventMonitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        field.clear();
        eventMonitor.assertNoEvent();
        field.setValue("foo");
        eventMonitor.discard();
        Assert.assertFalse((boolean)field.isEmpty());
        field.clear();
        eventMonitor.assertEvent(false, "foo", null);
        Assert.assertTrue((boolean)field.isEmpty());
        field.clear();
        eventMonitor.assertNoEvent();
    }

    @Test
    public void clear_customEmptyValue_emptyValueUsed() {
        TestAbstractField field = new TestAbstractField();
        field.emptyValue = (SerializableSupplier & Serializable)() -> "";
        Assert.assertFalse((boolean)field.isEmpty());
        field.clear();
        Assert.assertTrue((boolean)field.isEmpty());
        Assert.assertEquals((Object)"", (Object)field.getValue());
    }

    @Test
    public void updateFromClient_differentValue_updatesAndFires() {
        TestAbstractField<String> field = new TestAbstractField<String>();
        ValueChangeMonitor<String> eventMonitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        field.updatePresentationValue("foo", true);
        eventMonitor.assertEvent(true, null, "foo");
        field.updatePresentationValue("foo", true);
        eventMonitor.assertNoEvent();
    }

    @Test
    public void customEquals() {
        TestAbstractField field = new TestAbstractField();
        field.valueEquals = (SerializableBiPredicate & Serializable)(value1, value2) -> value1 == value2;
        Integer value12 = new Integer(0);
        Integer value22 = new Integer(0);
        field.setValue(value12);
        ValueChangeMonitor<Integer> eventMonitor = new ValueChangeMonitor<Integer>((HasValue<?, Integer>)field);
        field.setValue(value12);
        eventMonitor.assertNoEvent();
        field.setValue(value22);
        eventMonitor.assertEvent(false, value12, value22);
        field.updatePresentationValue(value22, true);
        eventMonitor.assertNoEvent();
        field.updatePresentationValue(value12, true);
        eventMonitor.assertEvent(true, value22, value12);
    }

    @Test
    public void customEquals_isEmpty() {
        Integer value1 = new Integer(0);
        Integer value2 = new Integer(0);
        TestAbstractField<Integer> field = new TestAbstractField<Integer>(value1);
        field.valueEquals = (SerializableBiPredicate & Serializable)(v1, v2) -> v1 == v2;
        Assert.assertTrue((boolean)field.isEmpty());
        Assert.assertFalse((boolean)field.getOptionalValue().isPresent());
        field.setValue(value2);
        Assert.assertFalse((boolean)field.isEmpty());
        Assert.assertTrue((boolean)field.getOptionalValue().isPresent());
        field.clear();
        Assert.assertTrue((boolean)field.isEmpty());
        Assert.assertFalse((boolean)field.getOptionalValue().isPresent());
    }

    @Test
    public void getValue_changesAfterUpdatedFromClient() {
        TestAbstractField field = new TestAbstractField();
        Assert.assertNull((Object)field.getValue());
        field.presentationValue = "foo";
        Assert.assertNull((Object)field.getValue());
        field.valueUpdatedFromClient(false);
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void setPresentation_setSameValue_notRunAgain() {
        TestAbstractField field = new TestAbstractField();
        AtomicReference lastWriteValue = new AtomicReference();
        field.setPresentationValue = (SerializableConsumer & Serializable)value -> {
            Assert.assertNull((String)"Unexpected update", (Object)lastWriteValue.getAndSet(value));
            field.presentationValue = value;
        };
        field.setValue("foo");
        Assert.assertEquals((Object)"foo", lastWriteValue.get());
        lastWriteValue.set(null);
        field.setValue("foo");
        Assert.assertNull(lastWriteValue.get());
    }

    @Test
    public void updatePresentation_doesntCallSetPresentation() {
        TestAbstractField field = new TestAbstractField();
        field.setPresentationValue = (SerializableConsumer & Serializable)value -> Assert.fail((String)"setPresentationValue should not run");
        field.updatePresentationValue("foo", true);
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void setPresentation_throws_sameException_valuePreserved() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor eventMonitor = new ValueChangeMonitor(field);
        field.setPresentationValue = (SerializableConsumer & Serializable)value -> {
            throw new IllegalStateException((String)value);
        };
        try {
            field.setValue("foo");
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"foo", (Object)e.getMessage());
        }
        eventMonitor.assertNoEvent();
        Assert.assertNull((Object)field.getValue());
    }

    @Test
    public void setPresentation_partialUpdates_onlyOneEvent() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor<String> eventMonitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        field.setPresentationValue = (SerializableConsumer & Serializable)value -> {
            field.updatePresentationValue("temp value", true);
            field.updatePresentationValue(value, true);
        };
        field.setValue("foo");
        eventMonitor.assertEvent(false, null, "foo");
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void setPresentation_changesValue_onlyOneEvent() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor<String> eventMonitor = new ValueChangeMonitor<String>((HasValue<?, String>)field);
        field.setPresentationValue = (SerializableConsumer & Serializable)value -> {
            field.setPresentationValue = (SerializableConsumer & Serializable)value2 -> Assert.fail((String)"setPresentationValue should not be called again");
            field.updatePresentationValue(value.toUpperCase(Locale.ROOT), false);
        };
        field.setValue("foo");
        eventMonitor.assertEvent(false, null, "FOO");
        Assert.assertEquals((Object)"FOO", (Object)field.getValue());
    }

    @Test
    public void setPresentation_revertsValue_noEvent() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor eventMonitor = new ValueChangeMonitor(field);
        field.setPresentationValue = (SerializableConsumer & Serializable)value -> {
            field.setPresentationValue = (SerializableConsumer & Serializable)value2 -> Assert.fail((String)"setPresentationValue should not be called again");
            field.valueUpdatedFromClient(false);
        };
        field.setValue("foo");
        eventMonitor.assertNoEvent();
        Assert.assertNull((Object)field.getValue());
    }

    @Test
    public void setValueInEventHandler() {
        TestAbstractField field = new TestAbstractField();
        ArrayList beforeEvents = new ArrayList();
        ArrayList afterEvents = new ArrayList();
        field.addValueChangeListener(beforeEvents::add);
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> ((TestAbstractField)event.getSource()).setValue("bar"));
        field.addValueChangeListener(afterEvents::add);
        field.setValue("foo");
        Assert.assertEquals((long)2L, (long)beforeEvents.size());
        ValueChangeMonitor.assertEventValues((HasValue.ValueChangeEvent)beforeEvents.get(0), null, "foo");
        ValueChangeMonitor.assertEventValues((HasValue.ValueChangeEvent)beforeEvents.get(1), "foo", "bar");
        Assert.assertEquals((long)2L, (long)afterEvents.size());
        ValueChangeMonitor.assertEventValues((HasValue.ValueChangeEvent)afterEvents.get(0), "foo", "bar");
        ValueChangeMonitor.assertEventValues((HasValue.ValueChangeEvent)afterEvents.get(1), null, "foo");
    }

    @Test
    public void requiredIndicator_writtenToElement() {
        TestAbstractField field = new TestAbstractField();
        Element element = field.getElement();
        Assert.assertFalse((boolean)element.getProperty("required", false));
        field.setRequiredIndicatorVisible(true);
        Assert.assertTrue((boolean)element.getProperty("required", false));
        field.setRequiredIndicatorVisible(false);
        Assert.assertFalse((boolean)element.getProperty("required", false));
    }

    @Test
    public void requiredIndicator_readFromElement() {
        TestAbstractField field = new TestAbstractField();
        Element element = field.getElement();
        Assert.assertFalse((boolean)field.isRequiredIndicatorVisible());
        element.setProperty("required", true);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        element.setProperty("required", false);
        Assert.assertFalse((boolean)field.isRequiredIndicatorVisible());
    }

    @Test
    public void readonly_writtenToElement() {
        TestAbstractField field = new TestAbstractField();
        Element element = field.getElement();
        Assert.assertFalse((boolean)element.getProperty("readonly", false));
        field.setReadOnly(true);
        Assert.assertTrue((boolean)element.getProperty("readonly", false));
        field.setReadOnly(false);
        Assert.assertFalse((boolean)element.getProperty("readonly", false));
    }

    @Test
    public void readonly_readFromElement() {
        TestAbstractField field = new TestAbstractField();
        Element element = field.getElement();
        Assert.assertFalse((boolean)field.isReadOnly());
        element.setProperty("readonly", true);
        Assert.assertTrue((boolean)field.isReadOnly());
        element.setProperty("readonly", false);
        Assert.assertFalse((boolean)field.isReadOnly());
    }

    @Test
    public void readonly_setValue_accepted() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor eventMonitor = new ValueChangeMonitor(field);
        field.setReadOnly(true);
        field.setValue("foo");
        eventMonitor.discard();
        Assert.assertEquals((Object)"foo", field.presentationValue);
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void readonly_presentationFromClient_reverted() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor eventMonitor = new ValueChangeMonitor(field);
        field.setReadOnly(true);
        field.updatePresentationValue("foo", true);
        eventMonitor.assertNoEvent();
        Assert.assertEquals(null, (Object)field.getValue());
        Assert.assertEquals(null, field.presentationValue);
    }

    @Test
    public void readonly_presentationFromServer_accepted() {
        TestAbstractField field = new TestAbstractField();
        ValueChangeMonitor eventMonitor = new ValueChangeMonitor(field);
        field.setReadOnly(true);
        field.updatePresentationValue("foo", false);
        eventMonitor.discard();
        Assert.assertEquals((Object)"foo", field.presentationValue);
        Assert.assertEquals((Object)"foo", (Object)field.getValue());
    }

    @Test
    public void noOwnPublicApi() {
        List newPublicMethods = PublicApiAnalyzer.findNewPublicMethods(AbstractField.class).collect(Collectors.toList());
        Assert.assertEquals(Collections.emptyList(), newPublicMethods);
    }

    @Test
    public void serializable() {
        TestAbstractField field = new TestAbstractField();
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ignore -> {});
        field.setValue("foo");
        TestAbstractField anotherField = (TestAbstractField)((Object)SerializationUtils.roundtrip(field));
        Assert.assertEquals((Object)"foo", (Object)anotherField.getValue());
    }

    @Tag(value="tag")
    private static class TestAbstractField<T>
    extends AbstractField<TestAbstractField<T>, T> {
        T presentationValue;
        SerializableConsumer<T> setPresentationValue = (SerializableConsumer & Serializable)value -> {
            this.presentationValue = value;
        };
        SerializableBiPredicate<T, T> valueEquals;
        SerializableSupplier<T> emptyValue;

        public TestAbstractField() {
            this(null);
        }

        public TestAbstractField(T defaultValue) {
            super(defaultValue);
        }

        protected void setPresentationValue(T value) {
            this.setPresentationValue.accept(value);
        }

        protected boolean valueEquals(T value1, T value2) {
            if (this.valueEquals != null) {
                return this.valueEquals.test(value1, value2);
            }
            return super.valueEquals(value1, value2);
        }

        public T getEmptyValue() {
            if (this.emptyValue != null) {
                return (T)this.emptyValue.get();
            }
            return (T)super.getEmptyValue();
        }

        public void updatePresentationValue(T value, boolean fromClient) {
            this.presentationValue = value;
            this.setModelValue(value, fromClient);
        }

        public void setModelValue(T value, boolean fromClient) {
            super.setModelValue(value, fromClient);
        }

        public void valueUpdatedFromClient(boolean fromClient) {
            super.setModelValue(this.presentationValue, fromClient);
        }
    }

    private static class SimpleAbstractField<T>
    extends AbstractField<SimpleAbstractField<T>, T> {
        public SimpleAbstractField() {
            super(null);
        }

        protected void setPresentationValue(T value) {
        }
    }
}

