/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.AbstractDeploymentConfiguration;
import com.vaadin.flow.server.SessionLockCheckStrategy;
import com.vaadin.flow.shared.communication.PushMode;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDeploymentConfigurationTest {
    @Test
    public void getUIClass_returnsUIParameterPropertyValue() {
        String ui = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("UI", ui);
        Assert.assertEquals((String)"Unexpected UI class configuration option value", (Object)ui, (Object)config.getUIClassName());
    }

    @Test
    public void getClassLoader_returnsClassloaderPropertyValue() {
        String classLoader = UUID.randomUUID().toString();
        DeploymentConfiguration config = this.getConfig("ClassLoader", classLoader);
        Assert.assertEquals((String)"Unexpected classLoader configuration option value", (Object)classLoader, (Object)config.getClassLoaderName());
    }

    private DeploymentConfiguration getConfig(String property, String value) {
        Properties props = new Properties();
        if (property != null) {
            props.put(property, value);
        }
        return new DeploymentConfigImpl(props);
    }

    private static class DeploymentConfigImpl
    extends AbstractDeploymentConfiguration {
        private Properties properties;

        DeploymentConfigImpl(Properties props) {
            super(Collections.emptyMap());
            this.properties = props;
        }

        public boolean isProductionMode() {
            return false;
        }

        public boolean isRequestTiming() {
            return !this.isProductionMode();
        }

        public boolean isXsrfProtectionEnabled() {
            return false;
        }

        public boolean isSyncIdCheckEnabled() {
            return false;
        }

        public int getHeartbeatInterval() {
            return 0;
        }

        public int getMaxMessageSuspendTimeout() {
            return 0;
        }

        public int getWebComponentDisconnect() {
            return 0;
        }

        public boolean isCloseIdleSessions() {
            return false;
        }

        public PushMode getPushMode() {
            return null;
        }

        public Properties getInitParameters() {
            return null;
        }

        public <T> T getApplicationOrSystemProperty(String propertyName, T defaultValue, Function<String, T> converter) {
            return Optional.ofNullable(this.properties.getProperty(propertyName)).map(converter).orElse(defaultValue);
        }

        public boolean isDevModeLiveReloadEnabled() {
            return false;
        }

        public boolean isDevToolsEnabled() {
            return false;
        }

        public boolean isSendUrlsAsParameters() {
            return true;
        }

        public SessionLockCheckStrategy getSessionLockCheckStrategy() {
            return SessionLockCheckStrategy.ASSERT;
        }
    }
}

