/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.polymertemplate.EventHandler;
import com.vaadin.flow.component.polymertemplate.RepeatIndex;
import com.vaadin.flow.component.template.internal.DeprecatedPolymerTemplate;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.HasCurrentService;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.server.VaadinService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
public class PolymerServerEventHandlersTest
extends HasCurrentService {
    private StateNode stateNode;
    private PolymerServerEventHandlers handlers;
    private Collection<Method> methodCollector;
    private Map<String, Method> correctlyAnnotatedHandlers;
    private Map<String, Method> wronglyAnnotatedHandlers;

    private static Map<String, Method> getEventHandlerNamesAndMethods(Class<?> clazz) {
        return Stream.of(clazz.getMethods()).filter(method -> Objects.nonNull(method.getAnnotation(EventHandler.class))).collect(Collectors.toMap(Method::getName, Function.identity()));
    }

    @Before
    public void setUp() {
        Collection features = BasicElementStateProvider.getFeatures();
        this.stateNode = new StateNode(features.toArray(new Class[features.size()]));
        ((ElementData)this.stateNode.getFeature(ElementData.class)).setTag("test");
        this.handlers = new PolymerServerEventHandlers(this.stateNode);
        this.methodCollector = new ArrayList<Method>();
        this.correctlyAnnotatedHandlers = PolymerServerEventHandlersTest.getEventHandlerNamesAndMethods(CorrectAnnotationUsage.class);
        this.wronglyAnnotatedHandlers = PolymerServerEventHandlersTest.getEventHandlerNamesAndMethods(WrongAnnotationUsage.class);
    }

    @Override
    protected VaadinService createService() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)true);
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)configuration);
        return service;
    }

    private void addAndVerifyMethod(Method method) {
        this.handlers.addHandlerMethod(method, this.methodCollector);
        Assert.assertEquals((long)1L, (long)this.methodCollector.size());
        Assert.assertEquals((Object)method, (Object)this.methodCollector.iterator().next());
        Assert.assertEquals((long)method.getParameters().length, (long)this.extractParametersData(method).size());
    }

    private ArrayNode extractParametersData(Method method) {
        ConstantPoolKey parametersData = (ConstantPoolKey)((PolymerEventListenerMap)this.stateNode.getFeature(PolymerEventListenerMap.class)).get(method.getName());
        Assert.assertNotNull((Object)parametersData);
        ObjectNode json = JacksonUtils.createObjectNode();
        parametersData.export(json);
        return (ArrayNode)json.get(parametersData.getId());
    }

    @Test
    public void testNoParamsMethod() {
        this.addAndVerifyMethod(this.correctlyAnnotatedHandlers.get("noParams"));
    }

    @Test
    public void testCorrectMethodWithDifferentAnnotations() throws NoSuchFieldException, IllegalAccessException {
        Field component = ComponentMapping.class.getDeclaredField("component");
        component.setAccessible(true);
        component.set(this.stateNode.getFeature(ComponentMapping.class), (Object)new CorrectAnnotationUsage());
        this.addAndVerifyMethod(this.correctlyAnnotatedHandlers.get("eventDataAndRepeatIndexOnDifferentParams"));
    }

    @Test
    public void testEventDataParam() throws NoSuchFieldException, IllegalAccessException {
        Field component = ComponentMapping.class.getDeclaredField("component");
        component.setAccessible(true);
        component.set(this.stateNode.getFeature(ComponentMapping.class), (Object)new CorrectAnnotationUsage());
        this.addAndVerifyMethod(this.correctlyAnnotatedHandlers.get("eventDataParam"));
    }

    @Test
    public void testRepeatIndexParam1() {
        this.addAndVerifyMethod(this.correctlyAnnotatedHandlers.get("repeatIndexParam1"));
    }

    @Test
    public void testRepeatIndexParam2() {
        this.addAndVerifyMethod(this.correctlyAnnotatedHandlers.get("repeatIndexParam2"));
    }

    @Test(expected=IllegalStateException.class)
    public void testNotAnnotatedParam() {
        this.addAndVerifyMethod(this.wronglyAnnotatedHandlers.get("notAnnotatedParam"));
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongTypeOfRepeatIndexParam() {
        this.addAndVerifyMethod(this.wronglyAnnotatedHandlers.get("wrongTypeOfRepeatIndexParam"));
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleAnnotationsOnOneParam() {
        this.addAndVerifyMethod(this.wronglyAnnotatedHandlers.get("eventDataAndRepeatIndexOnOneParam"));
    }

    @Tag(value="polymer")
    private static class CorrectAnnotationUsage
    extends AbstractTemplate {
        private CorrectAnnotationUsage() {
        }

        @EventHandler
        public void noParams() {
        }

        @EventHandler
        public void eventDataParam(@EventData(value="test") String test) {
        }

        @EventHandler
        public void repeatIndexParam1(@RepeatIndex int index) {
        }

        @EventHandler
        public void repeatIndexParam2(@RepeatIndex Integer index) {
        }

        @EventHandler
        public void eventDataAndRepeatIndexOnDifferentParams(@EventData(value="test") String test, @RepeatIndex int index) {
        }
    }

    private static class WrongAnnotationUsage {
        private WrongAnnotationUsage() {
        }

        @EventHandler
        public void notAnnotatedParam(int iCauseExceptions) {
        }

        @EventHandler
        public void wrongTypeOfRepeatIndexParam(@RepeatIndex String iCauseThemToo) {
        }

        @EventHandler
        public void eventDataAndRepeatIndexOnOneParam(@EventData(value="test") @RepeatIndex int meToo) {
        }
    }

    private static class AbstractTemplate
    extends Component
    implements DeprecatedPolymerTemplate {
        private AbstractTemplate() {
        }
    }
}

