/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ElementDataTest
extends AbstractNodeFeatureTest<ElementData> {
    private final ElementData elementData = (ElementData)new StateNode(Collections.singletonList(ElementData.class), new Class[0]).getFeature(ElementData.class);

    @Test
    public void setGetTag() {
        Assert.assertNull((String)"Tag should initially be null", (Object)this.elementData.getTag());
        this.elementData.setTag("myTag");
        Assert.assertEquals((Object)"myTag", (Object)this.elementData.getTag());
    }

    @Test
    public void setGetPayload() {
        Assert.assertNull((String)"Tag should initially be null", (Object)this.elementData.getPayload());
        ObjectNode object = JacksonUtils.createObjectNode();
        this.elementData.setPayload((BaseJsonNode)object);
        Assert.assertEquals((Object)object, (Object)this.elementData.getPayload());
    }

    @Test
    public void collectChanges_setTagOnly_onlyOneChanges() {
        this.elementData.setTag("foo");
        ArrayList changes = new ArrayList();
        this.elementData.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
        MapPutChange change = (MapPutChange)changes.get(0);
        Assert.assertEquals((Object)"tag", (Object)change.getKey());
        Assert.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assert.assertEquals((Object)"foo", (Object)change.getValue());
    }

    @Test
    public void collectChanges_setPayloadOnly_onlyOneChanges() {
        ObjectNode object = JacksonUtils.createObjectNode();
        this.elementData.setPayload((BaseJsonNode)object);
        ArrayList changes = new ArrayList();
        this.elementData.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
        MapPutChange change = (MapPutChange)changes.get(0);
        Assert.assertEquals((Object)"payload", (Object)change.getKey());
        Assert.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assert.assertEquals((Object)object, (Object)change.getValue());
    }

    @Test
    public void collectChanges_setBothTagAndPayload_twoChanges() {
        ObjectNode object = JacksonUtils.createObjectNode();
        this.elementData.setPayload((BaseJsonNode)object);
        this.elementData.setTag("foo");
        ArrayList<NodeChange> changes = new ArrayList<NodeChange>();
        this.elementData.collectChanges(changes::add);
        Assert.assertEquals((long)2L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
        Assert.assertTrue((boolean)(changes.get(1) instanceof MapPutChange));
        MapPutChange change = this.getChange(changes, "tag");
        Assert.assertEquals((Object)"tag", (Object)change.getKey());
        Assert.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assert.assertEquals((Object)"foo", (Object)change.getValue());
        change = this.getChange(changes, "payload");
        Assert.assertEquals((Object)"payload", (Object)change.getKey());
        Assert.assertEquals((Object)this.elementData.getNode(), (Object)change.getNode());
        Assert.assertEquals((Object)object, (Object)change.getValue());
    }

    private MapPutChange getChange(List<NodeChange> changes, String key) {
        Optional<MapPutChange> keyFound = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals(key)).findFirst();
        Assert.assertTrue((String)("No " + key + " change found"), (boolean)keyFound.isPresent());
        return keyFound.get();
    }
}

