/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BeanUtil;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BeanUtilTest {
    @Test
    public void getBeanPropertyDescriptors_regularClass() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestBean.class);
        Assert.assertNotNull((Object)descriptors);
        Assert.assertEquals((long)4L, (long)descriptors.size());
        boolean foundName = false;
        boolean foundAge = false;
        boolean foundNested = false;
        for (PropertyDescriptor descriptor : descriptors) {
            Assert.assertNotNull((Object)descriptor.getReadMethod());
            if (!"class".equals(descriptor.getName())) {
                Assert.assertNotNull((Object)descriptor.getWriteMethod());
            }
            if ("name".equals(descriptor.getName())) {
                foundName = true;
                Assert.assertEquals(String.class, descriptor.getPropertyType());
                continue;
            }
            if ("age".equals(descriptor.getName())) {
                foundAge = true;
                Assert.assertEquals(Integer.TYPE, descriptor.getPropertyType());
                continue;
            }
            if (!"nested".equals(descriptor.getName())) continue;
            foundNested = true;
            Assert.assertEquals(TestNestedBean.class, descriptor.getPropertyType());
        }
        Assert.assertTrue((String)"Should find 'name' property", (boolean)foundName);
        Assert.assertTrue((String)"Should find 'age' property", (boolean)foundAge);
        Assert.assertTrue((String)"Should find 'nested' property", (boolean)foundNested);
    }

    @Test
    public void getBeanPropertyDescriptors_record() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestRecord.class);
        Assert.assertNotNull((Object)descriptors);
        Assert.assertEquals((long)2L, (long)descriptors.size());
        boolean foundRecordProperty = false;
        boolean foundRecordAge = false;
        for (PropertyDescriptor descriptor : descriptors) {
            Assert.assertNotNull((Object)descriptor.getReadMethod());
            Assert.assertNull((Object)descriptor.getWriteMethod());
            if ("recordProperty".equals(descriptor.getName())) {
                foundRecordProperty = true;
                Assert.assertEquals(String.class, descriptor.getPropertyType());
                continue;
            }
            if (!"recordAge".equals(descriptor.getName())) continue;
            foundRecordAge = true;
            Assert.assertEquals(Integer.TYPE, descriptor.getPropertyType());
        }
        Assert.assertTrue((String)"Should find 'recordProperty' property", (boolean)foundRecordProperty);
        Assert.assertTrue((String)"Should find 'recordAge' property", (boolean)foundRecordAge);
    }

    @Test
    public void getBeanPropertyDescriptors_interface() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestInterface.class);
        Assert.assertNotNull((Object)descriptors);
        Assert.assertEquals((long)1L, (long)descriptors.size());
        Assert.assertEquals((Object)"interfaceProperty", (Object)((PropertyDescriptor)descriptors.get(0)).getName());
        Assert.assertEquals(String.class, ((PropertyDescriptor)descriptors.get(0)).getPropertyType());
        Assert.assertNotNull((Object)((PropertyDescriptor)descriptors.get(0)).getReadMethod());
        Assert.assertNotNull((Object)((PropertyDescriptor)descriptors.get(0)).getWriteMethod());
    }

    @Test
    public void getPropertyType_simpleProperty() throws IntrospectionException {
        Class nameType = BeanUtil.getPropertyType(TestBean.class, (String)"name");
        Assert.assertEquals(String.class, (Object)nameType);
        Class ageType = BeanUtil.getPropertyType(TestBean.class, (String)"age");
        Assert.assertEquals(Integer.TYPE, (Object)ageType);
    }

    @Test
    public void getPropertyType_nestedProperty() throws IntrospectionException {
        Class nestedValueType = BeanUtil.getPropertyType(TestBean.class, (String)"nested.value");
        Assert.assertEquals(String.class, (Object)nestedValueType);
    }

    @Test
    public void getPropertyType_nonExistentProperty() throws IntrospectionException {
        Class nonExistentType = BeanUtil.getPropertyType(TestBean.class, (String)"nonExistent");
        Assert.assertNull((Object)nonExistentType);
    }

    @Test
    public void getPropertyDescriptor_simpleProperty() throws IntrospectionException {
        PropertyDescriptor nameDescriptor = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"name");
        Assert.assertNotNull((Object)nameDescriptor);
        Assert.assertEquals((Object)"name", (Object)nameDescriptor.getName());
        Assert.assertEquals(String.class, nameDescriptor.getPropertyType());
        Assert.assertNotNull((Object)nameDescriptor.getReadMethod());
        Assert.assertNotNull((Object)nameDescriptor.getWriteMethod());
    }

    @Test
    public void getPropertyDescriptor_nestedProperty() throws IntrospectionException {
        PropertyDescriptor nestedValueDescriptor = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"nested.value");
        Assert.assertNotNull((Object)nestedValueDescriptor);
        Assert.assertEquals((Object)"value", (Object)nestedValueDescriptor.getName());
        Assert.assertEquals(String.class, nestedValueDescriptor.getPropertyType());
        Assert.assertNotNull((Object)nestedValueDescriptor.getReadMethod());
        Assert.assertNotNull((Object)nestedValueDescriptor.getWriteMethod());
    }

    @Test
    public void getPropertyDescriptor_nonExistentProperty() throws IntrospectionException {
        PropertyDescriptor nonExistentDescriptor = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"nonExistent");
        Assert.assertNull((Object)nonExistentDescriptor);
    }

    @Test
    public void getBeanPropertyDescriptors_nullInput() throws IntrospectionException {
        List result = BeanUtil.getBeanPropertyDescriptors(null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void getPropertyType_emptyPropertyName() throws IntrospectionException {
        Class result = BeanUtil.getPropertyType(TestBean.class, (String)"");
        Assert.assertNull((Object)result);
    }

    @Test
    public void getPropertyDescriptor_emptyPropertyName() throws IntrospectionException {
        PropertyDescriptor result = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"");
        Assert.assertNull((Object)result);
    }

    @Test
    public void getPropertyType_deepNestedProperty() throws IntrospectionException {
        Class result = BeanUtil.getPropertyType(TestBean.class, (String)"nested.nonExistent.value");
        Assert.assertNull((Object)result);
    }

    @Test
    public void getPropertyType_recordProperty() throws IntrospectionException {
        Class recordPropertyType = BeanUtil.getPropertyType(TestRecord.class, (String)"recordProperty");
        Assert.assertEquals(String.class, (Object)recordPropertyType);
        Class recordAgeType = BeanUtil.getPropertyType(TestRecord.class, (String)"recordAge");
        Assert.assertEquals(Integer.TYPE, (Object)recordAgeType);
    }

    @Test
    public void getPropertyType_interfaceProperty() throws IntrospectionException {
        Class interfacePropertyType = BeanUtil.getPropertyType(TestInterface.class, (String)"interfaceProperty");
        Assert.assertEquals(String.class, (Object)interfacePropertyType);
    }

    @Test
    public void getPropertyDescriptor_objectMethodsFiltered() throws IntrospectionException {
        PropertyDescriptor classProperty = BeanUtil.getPropertyDescriptor(TestBean.class, (String)"class");
        Assert.assertNull((String)"Object.getClass() should be filtered out", (Object)classProperty);
    }

    @Test
    public void getBeanPropertyDescriptors_includesAllValidProperties() throws IntrospectionException {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestBean.class);
        List<String> names = descriptors.stream().map(FeatureDescriptor::getName).toList();
        Assert.assertTrue((String)"should include property 'name'", (boolean)names.contains("name"));
        Assert.assertTrue((String)"should include property 'age'", (boolean)names.contains("age"));
        Assert.assertTrue((String)"should include property 'nested'", (boolean)names.contains("nested"));
        Assert.assertTrue((String)"should include property 'class'", (boolean)names.contains("class"));
    }

    @Test
    public void duplicatesAreRemoved() throws Exception {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestSomething.class);
        List<PropertyDescriptor> existsInAllPlacesProperties = descriptors.stream().filter(desc -> desc.getName().equals("existsInAllPlaces")).toList();
        Assert.assertEquals((String)"There should be only one 'existsInAllPlaces' property descriptor", (long)1L, (long)existsInAllPlacesProperties.size());
        List<PropertyDescriptor> oneInterfaceProperties = descriptors.stream().filter(desc -> desc.getName().equals("oneInterface")).toList();
        Assert.assertEquals((String)"There should be only one 'oneInterface' property descriptor", (long)1L, (long)oneInterfaceProperties.size());
        PropertyDescriptor oneInterfaceProperty = oneInterfaceProperties.get(0);
        Assert.assertEquals(FirstInterface.class, oneInterfaceProperty.getReadMethod().getDeclaringClass());
    }

    public static class TestBean {
        private String name;
        private int age;
        private TestNestedBean nested;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public TestNestedBean getNested() {
            return this.nested;
        }

        public void setNested(TestNestedBean nested) {
            this.nested = nested;
        }
    }

    public static class TestNestedBean {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public record TestRecord(String recordProperty, int recordAge) {
    }

    public static interface TestInterface {
        public String getInterfaceProperty();

        public void setInterfaceProperty(String var1);
    }

    public class TestSomething
    implements FirstInterface,
    SecondInterface {
        public TestSomething(BeanUtilTest this$0) {
        }

        @Override
        public void setExistsInAllPlaces(boolean visible) {
        }

        @Override
        public boolean isExistsInAllPlaces() {
            return true;
        }
    }

    public static interface FirstInterface {
        default public void setOneInterface(boolean bothInterfaces) {
        }

        default public boolean isOneInterface() {
            return true;
        }

        default public void setExistsInAllPlaces(boolean visible) {
        }

        default public boolean isExistsInAllPlaces() {
            return true;
        }
    }

    public static interface SecondInterface {
        default public void setExistsInAllPlaces(boolean visible) {
        }

        default public boolean isExistsInAllPlaces() {
            return true;
        }
    }
}

