/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyDescriptorsTest {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Double ZERO_DOUBLE = 0.0;
    private static final Double ONE_DOUBLE = 1.0;
    private static final String EMPTY_STRING = "";
    private static final String FOO = "foo";
    private static final String SOME_STRING_VALUE = "foobar123456";
    private static final Integer SOME_INTEGER_VALUE = 129837419;
    private static final Double SOME_DOUBLE_VALUE = 3.14;
    private static final String TEST_PROPERTY = "someproperty";
    private ComponentTest.TestComponent component;
    private static PropertyDescriptor<String, String> stringAttributeDefaultEmpty = PropertyDescriptors.attributeWithDefault((String)"someproperty", (String)"");
    private static PropertyDescriptor<String, String> stringAttributeDefaultFoo = PropertyDescriptors.attributeWithDefault((String)"someproperty", (String)"foo");
    private static PropertyDescriptor<String, Optional<String>> stringAttributeOptionalDefaultEmpty = PropertyDescriptors.optionalAttributeWithDefault((String)"someproperty", (String)"");
    private static PropertyDescriptor<String, Optional<String>> stringAttributeOptionalDefaultFoo = PropertyDescriptors.optionalAttributeWithDefault((String)"someproperty", (String)"foo");
    private static PropertyDescriptor<String, String> stringPropertyDefaultEmpty = PropertyDescriptors.propertyWithDefault((String)"someproperty", (String)"");
    private static PropertyDescriptor<String, String> stringPropertyDefaultFoo = PropertyDescriptors.propertyWithDefault((String)"someproperty", (String)"foo");
    private static PropertyDescriptor<Integer, Integer> integerPropertyDefaultZero = PropertyDescriptors.propertyWithDefault((String)"someproperty", (Integer)0);
    private static PropertyDescriptor<Integer, Integer> integerPropertyDefaultOne = PropertyDescriptors.propertyWithDefault((String)"someproperty", (Integer)1);
    private static PropertyDescriptor<Double, Double> doublePropertyDefaultZero = PropertyDescriptors.propertyWithDefault((String)"someproperty", (Double)0.0);
    private static PropertyDescriptor<Double, Double> doublePropertyDefaultOne = PropertyDescriptors.propertyWithDefault((String)"someproperty", (Double)1.0);
    private static PropertyDescriptor<Boolean, Boolean> booleanPropertyDefaultFalse = PropertyDescriptors.propertyWithDefault((String)"someproperty", (Boolean)false);
    private static PropertyDescriptor<Boolean, Boolean> booleanPropertyDefaultTrue = PropertyDescriptors.propertyWithDefault((String)"someproperty", (Boolean)true);

    @Before
    public void setup() {
        this.component = new ComponentTest.TestComponent();
    }

    @Test
    public void stringPropertyDefaultEmptyString_initial() {
        Assert.assertEquals((Object)EMPTY_STRING, (Object)stringPropertyDefaultEmpty.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void stringPropertyDefaultEmptyString_setNonDefault() {
        stringPropertyDefaultEmpty.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)stringPropertyDefaultEmpty.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)this.component.getElement().getPropertyRaw(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void stringPropertyDefaultEmptyString_resetToDefault() {
        stringPropertyDefaultEmpty.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        stringPropertyDefaultEmpty.set((HasElement)this.component, (Object)EMPTY_STRING);
        Assert.assertEquals((Object)EMPTY_STRING, (Object)stringPropertyDefaultEmpty.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringPropertyDefaultEmptyString_setToNull() {
        stringPropertyDefaultEmpty.set((HasElement)this.component, null);
    }

    @Test
    public void stringPropertyDefaultFoo_initial() {
        Assert.assertEquals((Object)FOO, (Object)stringPropertyDefaultFoo.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void stringPropertyDefaultFoo_setNonDefault() {
        stringPropertyDefaultFoo.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)stringPropertyDefaultFoo.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)this.component.getElement().getPropertyRaw(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void stringPropertyDefaultFoo_resetToDefault() {
        stringPropertyDefaultFoo.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        stringPropertyDefaultFoo.set((HasElement)this.component, (Object)FOO);
        Assert.assertEquals((Object)FOO, (Object)stringPropertyDefaultFoo.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringPropertyDefaultFoo_setToNull() {
        stringPropertyDefaultFoo.set((HasElement)this.component, null);
    }

    @Test
    public void integerPropertyDefaultZero_initial() {
        Assert.assertEquals((Object)ZERO, (Object)integerPropertyDefaultZero.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void integerPropertyDefaultZero_setNonDefault() {
        integerPropertyDefaultZero.set((HasElement)this.component, (Object)SOME_INTEGER_VALUE);
        Assert.assertEquals((Object)SOME_INTEGER_VALUE, (Object)integerPropertyDefaultZero.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_INTEGER_VALUE, (Object)this.component.getElement().getProperty(TEST_PROPERTY, -1));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void integerPropertyDefaultZero_resetToDefault() {
        integerPropertyDefaultZero.set((HasElement)this.component, (Object)SOME_INTEGER_VALUE);
        integerPropertyDefaultZero.set((HasElement)this.component, (Object)ZERO);
        Assert.assertEquals((Object)ZERO, (Object)integerPropertyDefaultZero.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void integerPropertyDefaultZero_setToNull() {
        integerPropertyDefaultZero.set((HasElement)this.component, null);
    }

    @Test
    public void integerPropertyDefaultOne_initial() {
        Assert.assertEquals((Object)ONE, (Object)integerPropertyDefaultOne.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void integerPropertyDefaultOne_setNonDefault() {
        integerPropertyDefaultOne.set((HasElement)this.component, (Object)SOME_INTEGER_VALUE);
        Assert.assertEquals((Object)SOME_INTEGER_VALUE, (Object)integerPropertyDefaultOne.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_INTEGER_VALUE, (Object)this.component.getElement().getProperty(TEST_PROPERTY, -1));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void integerPropertyDefaultOne_resetToDefault() {
        integerPropertyDefaultOne.set((HasElement)this.component, (Object)SOME_INTEGER_VALUE);
        integerPropertyDefaultOne.set((HasElement)this.component, (Object)ONE);
        Assert.assertEquals((Object)ONE, (Object)integerPropertyDefaultOne.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void integerPropertyDefaultOne_setToNull() {
        integerPropertyDefaultOne.set((HasElement)this.component, null);
    }

    @Test
    public void doublePropertyDefaultZero_initial() {
        Assert.assertEquals((Object)ZERO_DOUBLE, (Object)doublePropertyDefaultZero.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void doublePropertyDefaultZero_setNonDefault() {
        doublePropertyDefaultZero.set((HasElement)this.component, (Object)SOME_DOUBLE_VALUE);
        Assert.assertEquals((Object)SOME_DOUBLE_VALUE, (Object)doublePropertyDefaultZero.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_DOUBLE_VALUE, (Object)this.component.getElement().getProperty(TEST_PROPERTY, -1.0));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void doublePropertyDefaultZero_resetToDefault() {
        doublePropertyDefaultZero.set((HasElement)this.component, (Object)SOME_DOUBLE_VALUE);
        doublePropertyDefaultZero.set((HasElement)this.component, (Object)ZERO_DOUBLE);
        Assert.assertEquals((Object)ZERO_DOUBLE, (Object)doublePropertyDefaultZero.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void doublePropertyDefaultZero_setToNull() {
        doublePropertyDefaultZero.set((HasElement)this.component, null);
    }

    @Test
    public void doublePropertyDefaultOne_initial() {
        Assert.assertEquals((Object)ONE_DOUBLE, (Object)doublePropertyDefaultOne.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void doublePropertyDefaultOne_setNonDefault() {
        doublePropertyDefaultOne.set((HasElement)this.component, (Object)SOME_DOUBLE_VALUE);
        Assert.assertEquals((Object)SOME_DOUBLE_VALUE, (Object)doublePropertyDefaultOne.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_DOUBLE_VALUE, (Object)this.component.getElement().getProperty(TEST_PROPERTY, -1.0));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void doublePropertyDefaultOne_resetToDefault() {
        doublePropertyDefaultOne.set((HasElement)this.component, (Object)SOME_DOUBLE_VALUE);
        doublePropertyDefaultOne.set((HasElement)this.component, (Object)ONE_DOUBLE);
        Assert.assertEquals((Object)ONE_DOUBLE, (Object)doublePropertyDefaultOne.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void doublePropertyDefaultOne_setToNull() {
        doublePropertyDefaultOne.set((HasElement)this.component, null);
    }

    @Test
    public void booleanPropertyDefaultFalse_initial() {
        Assert.assertEquals((Object)false, (Object)booleanPropertyDefaultFalse.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void booleanPropertyDefaultFalse_setNonDefault() {
        booleanPropertyDefaultFalse.set((HasElement)this.component, (Object)true);
        Assert.assertEquals((Object)true, (Object)booleanPropertyDefaultFalse.get((HasElement)this.component));
        Assert.assertEquals((Object)true, (Object)Boolean.valueOf(this.component.getElement().getProperty(TEST_PROPERTY, "neverused")));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void booleanPropertyDefaultFalse_resetToDefault() {
        booleanPropertyDefaultFalse.set((HasElement)this.component, (Object)true);
        booleanPropertyDefaultFalse.set((HasElement)this.component, (Object)false);
        Assert.assertEquals((Object)false, (Object)booleanPropertyDefaultFalse.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void booleanPropertyDefaultFalse_setToNull() {
        booleanPropertyDefaultFalse.set((HasElement)this.component, null);
    }

    @Test
    public void booleanPropertyDefaultTrue_initial() {
        Assert.assertEquals((Object)true, (Object)booleanPropertyDefaultTrue.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void booleanPropertyDefaultTrue_setNonDefault() {
        booleanPropertyDefaultTrue.set((HasElement)this.component, (Object)false);
        Assert.assertEquals((Object)false, (Object)booleanPropertyDefaultTrue.get((HasElement)this.component));
        Assert.assertEquals((Object)false, (Object)Boolean.valueOf(this.component.getElement().getProperty(TEST_PROPERTY, "neverused")));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test
    public void booleanPropertyDefaultTrue_resetToDefault() {
        booleanPropertyDefaultTrue.set((HasElement)this.component, (Object)false);
        booleanPropertyDefaultTrue.set((HasElement)this.component, (Object)true);
        Assert.assertEquals((Object)true, (Object)booleanPropertyDefaultTrue.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void booleanPropertyDefaultTrue_setToNull() {
        booleanPropertyDefaultTrue.set((HasElement)this.component, null);
    }

    @Test
    public void stringAttributeDefaultEmpty_initial() {
        Assert.assertEquals((Object)EMPTY_STRING, (Object)stringAttributeDefaultEmpty.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeDefaultEmpty_setNonDefault() {
        stringAttributeDefaultEmpty.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)stringAttributeDefaultEmpty.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)this.component.getElement().getAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeDefaultEmpty_resetToDefault() {
        stringAttributeDefaultEmpty.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        stringAttributeDefaultEmpty.set((HasElement)this.component, (Object)EMPTY_STRING);
        Assert.assertEquals((Object)EMPTY_STRING, (Object)stringAttributeDefaultEmpty.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringAttributeDefaultEmpty_setToNull() {
        stringAttributeDefaultEmpty.set((HasElement)this.component, null);
    }

    @Test
    public void stringAttributeDefaultFoo_initial() {
        Assert.assertEquals((Object)FOO, (Object)stringAttributeDefaultFoo.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeDefaultFoo_setNonDefault() {
        stringAttributeDefaultFoo.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)stringAttributeDefaultFoo.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)this.component.getElement().getAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeDefaultFoo_resetToDefault() {
        stringAttributeDefaultFoo.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        stringAttributeDefaultFoo.set((HasElement)this.component, (Object)FOO);
        Assert.assertEquals((Object)FOO, (Object)stringAttributeDefaultFoo.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringAttributeDefaultFoo_setToNull() {
        stringAttributeDefaultFoo.set((HasElement)this.component, null);
    }

    @Test
    public void stringAttributeOptionalDefaultEmpty_initial() {
        Assert.assertEquals(Optional.empty(), (Object)stringAttributeOptionalDefaultEmpty.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeOptionalDefaultEmpty_setNonOptionalDefault() {
        stringAttributeOptionalDefaultEmpty.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        Assert.assertEquals(Optional.of(SOME_STRING_VALUE), (Object)stringAttributeOptionalDefaultEmpty.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)this.component.getElement().getAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeOptionalDefaultEmpty_resetToOptionalDefault() {
        stringAttributeOptionalDefaultEmpty.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        stringAttributeOptionalDefaultEmpty.set((HasElement)this.component, (Object)EMPTY_STRING);
        Assert.assertEquals(Optional.empty(), (Object)stringAttributeOptionalDefaultEmpty.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringAttributeOptionalDefaultEmpty_setToNull() {
        stringAttributeOptionalDefaultEmpty.set((HasElement)this.component, null);
    }

    @Test
    public void stringAttributeOptionalDefaultFoo_initial() {
        Assert.assertEquals(Optional.empty(), (Object)stringAttributeOptionalDefaultFoo.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeOptionalDefaultFoo_setNonOptionalDefault() {
        stringAttributeOptionalDefaultFoo.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        Assert.assertEquals(Optional.of(SOME_STRING_VALUE), (Object)stringAttributeOptionalDefaultFoo.get((HasElement)this.component));
        Assert.assertEquals((Object)SOME_STRING_VALUE, (Object)this.component.getElement().getAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test
    public void stringAttributeOptionalDefaultFoo_resetToOptionalDefault() {
        stringAttributeOptionalDefaultFoo.set((HasElement)this.component, (Object)SOME_STRING_VALUE);
        stringAttributeOptionalDefaultFoo.set((HasElement)this.component, (Object)FOO);
        Assert.assertEquals(Optional.empty(), (Object)stringAttributeOptionalDefaultFoo.get((HasElement)this.component));
        Assert.assertFalse((boolean)this.component.getElement().hasAttribute(TEST_PROPERTY));
        Assert.assertFalse((boolean)this.component.getElement().hasProperty(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void stringAttributeOptionalDefaultFoo_setToNull() {
        stringAttributeOptionalDefaultFoo.set((HasElement)this.component, null);
    }

    @Test
    public void propertyName() {
        Assert.assertEquals((Object)TEST_PROPERTY, (Object)stringAttributeDefaultEmpty.getPropertyName());
    }
}

