/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.Tag;
import org.junit.Assert;
import org.junit.Test;

public class HasLabelTest {
    @Test
    public void withoutLabelComponent_getLabelReturnsNull() {
        TestComponent component = new TestComponent();
        Assert.assertNull((Object)component.getLabel());
    }

    @Test
    public void withNullLabel_getLabelReturnsNull() {
        TestComponent component = new TestComponent();
        component.setLabel(null);
        Assert.assertNull((Object)component.getLabel());
    }

    @Test
    public void withEmptyLabel_getLabelReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setLabel("");
        Assert.assertEquals((Object)"", (Object)component.getLabel());
    }

    @Test
    public void setLabel() {
        TestComponent component = new TestComponent();
        component.setLabel("test label");
        Assert.assertEquals((Object)"test label", (Object)component.getLabel());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasLabel {
        private TestComponent() {
        }
    }
}

