/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractSinglePropertyFieldTest;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.WritableSignal;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class AbstractCompositeFieldBindValueTest
extends SignalsUnitTest {
    @Test
    public void multipleFieldsField_bindValue_detached_setValueDoesNotUpdateSignal() {
        MultipleFieldsField field = new MultipleFieldsField();
        ValueSignal signal = new ValueSignal((Object)"Hello Cool World");
        field.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"", (Object)field.start.getValue());
        Assert.assertEquals((Object)"", (Object)field.rest.getValue());
        field.setValue("Hey You");
        Assert.assertEquals((Object)"Hey You", (Object)field.getValue());
        Assert.assertEquals((Object)"Hello Cool World", (Object)signal.peek());
    }

    @Test
    public void multipleFieldsField_bindValue_detached_setModelValueDoesNotUpdateSignal() {
        MultipleFieldsField field = new MultipleFieldsField();
        ValueSignal signal = new ValueSignal((Object)"Hello Cool World");
        field.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"", (Object)field.start.getValue());
        Assert.assertEquals((Object)"", (Object)field.rest.getValue());
        field.start.setValue("Hey");
        field.rest.setValue("You");
        Assert.assertEquals((Object)"Hey You", (Object)field.getValue());
        Assert.assertEquals((Object)"Hello Cool World", (Object)signal.peek());
    }

    @Test
    public void multipleFieldsField_bindValue_attached() {
        MultipleFieldsField field = new MultipleFieldsField();
        UI.getCurrent().add(new Component[]{field});
        ValueSignal signal = new ValueSignal((Object)"Hello Cool World");
        field.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"Hello", (Object)field.start.getValue());
        Assert.assertEquals((Object)"Cool World", (Object)field.rest.getValue());
        field.setValue("");
        Assert.assertEquals((Object)"", (Object)field.getValue());
        Assert.assertEquals((Object)"", (Object)signal.peek());
        signal.value((Object)"Hello Cool World");
        field.rest.setValue("");
        Assert.assertEquals((Object)"Hello", (Object)field.getValue());
        Assert.assertEquals((Object)"Hello", (Object)signal.peek());
        field.rest.setValue("Vaadin");
        Assert.assertEquals((Object)"Hello Vaadin", (Object)field.getValue());
        Assert.assertEquals((Object)"Hello Vaadin", (Object)signal.peek());
        field.bindValue(null);
        Assert.assertEquals((Object)"Hello Vaadin", (Object)field.getValue());
        Assert.assertEquals((Object)"Hello Vaadin", (Object)signal.peek());
        field.setValue("Hey You");
        Assert.assertEquals((Object)"Hey You", (Object)field.getValue());
        Assert.assertEquals((Object)"Hello Vaadin", (Object)signal.peek());
    }

    private static class MultipleFieldsField
    extends AbstractCompositeField<ComponentTest.TestDiv, MultipleFieldsField, String> {
        private final AbstractSinglePropertyFieldTest.StringField start = new AbstractSinglePropertyFieldTest.StringField();
        private final AbstractSinglePropertyFieldTest.StringField rest = new AbstractSinglePropertyFieldTest.StringField();

        public MultipleFieldsField() {
            super(null);
            ((ComponentTest.TestDiv)this.getContent()).getElement().appendChild(new Element[]{this.start.getElement(), this.rest.getElement()});
            this.start.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue(event.isFromClient()));
            this.rest.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue(event.isFromClient()));
        }

        private void updateValue(boolean fromClient) {
            Object value = (String)this.start.getValue();
            String restValue = (String)this.rest.getValue();
            if (!restValue.isEmpty()) {
                value = (String)value + " " + restValue;
            }
            this.setModelValue(value, fromClient);
        }

        protected void setPresentationValue(String newPresentationValue) {
            String[] parts = newPresentationValue.split(" ", 2);
            this.start.setValue(parts[0]);
            if (parts.length > 1) {
                this.rest.setValue(parts[1]);
            } else {
                this.rest.setValue("");
            }
        }
    }
}

