/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeList;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import java.util.Optional;

public class ElementClassList
extends SerializableNodeList<String> {
    public ElementClassList(StateNode node) {
        super(node);
    }

    public ClassList getClassList() {
        return new ClassListView(this);
    }

    private static class ClassListView
    extends NodeList.SetView<String>
    implements ClassList {
        private final ElementClassList elementClassList;

        private ClassListView(ElementClassList elementClassList) {
            super(elementClassList);
            this.elementClassList = elementClassList;
        }

        @Override
        protected void validate(String className) {
            if (className == null) {
                throw new IllegalArgumentException("Class name cannot be null");
            }
            if (className.isEmpty()) {
                throw new IllegalArgumentException("Class name cannot be empty");
            }
            if (className.indexOf(32) != -1) {
                throw new IllegalArgumentException("Class name cannot contain spaces");
            }
        }

        private void internalSetPresence(String name, boolean set) {
            ElementClassList list = this.elementClassList;
            int index = list.indexOf(name);
            if (set) {
                if (index == -1) {
                    list.add(list.size(), name);
                }
            } else if (index != -1) {
                list.remove(index);
            }
        }

        private StateNode getNode() {
            return this.elementClassList.getNode();
        }

        @Override
        public void bind(String name, Signal<Boolean> signal) {
            this.validate(name);
            SignalBindingFeature feature = this.getNode().getFeature(SignalBindingFeature.class);
            if (signal == null) {
                feature.removeBinding("classes/" + name);
            } else {
                if (feature.hasBinding("classes/" + name)) {
                    throw new BindingActiveException("Class name '" + name + "' is already bound to a signal");
                }
                Registration registration = ElementEffect.bind(Element.get(this.getNode()), signal, (element, value) -> this.internalSetPresence(name, Boolean.TRUE.equals(value)));
                feature.setBinding("classes/" + name, registration, signal);
            }
        }

        @Override
        public boolean add(String className) {
            this.throwIfBound(className);
            return super.add(className);
        }

        @Override
        public boolean remove(Object className) {
            if (className instanceof String) {
                String name = (String)className;
                this.throwIfBound(name);
            }
            return super.remove(className);
        }

        @Override
        public void clear() {
            this.clearBindings();
            super.clear();
        }

        public void clearBindings() {
            this.getSignalBindingFeatureIfInitialized().ifPresent(feature -> feature.clearBindings("classes/"));
        }

        private void throwIfBound(String className) {
            this.getSignalBindingFeatureIfInitialized().ifPresent(feature -> {
                if (feature.hasBinding("classes/" + className)) {
                    throw new BindingActiveException("Class name '" + className + "' is bound and cannot be modified manually");
                }
            });
        }

        private Optional<SignalBindingFeature> getSignalBindingFeatureIfInitialized() {
            try {
                return this.getNode().getFeatureIfInitialized(SignalBindingFeature.class);
            }
            catch (IllegalStateException e) {
                return Optional.empty();
            }
        }
    }
}

