/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.server.webcomponent.WebComponentModulesWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class WebComponentModulesWriterTest {
    private ExpectedException exception = ExpectedException.none();
    private TemporaryFolder folder = new TemporaryFolder();
    private File outputDirectory;

    @Before
    public void init() throws IOException {
        this.folder.create();
        this.outputDirectory = this.folder.newFolder();
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_canCallMethodReflectively_js() {
        Set files = WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, Collections.singleton(MyExporter.class), (File)this.outputDirectory, null);
        Assert.assertEquals((String)"One file was created", (long)1L, (long)files.size());
        Assert.assertEquals((String)"File is js module with correct name", (Object)"real-tag.js", (Object)((File)files.stream().findFirst().get()).getName());
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectoryUsingFactory_canCallMethodReflectively_js() {
        Set files = WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, Collections.singleton(ExporterFactory.class), (File)this.outputDirectory, null);
        Assert.assertEquals((String)"One file was created", (long)1L, (long)files.size());
        Assert.assertEquals((String)"File is js module with correct name", (Object)"foo-bar.js", (Object)((File)files.stream().findFirst().get()).getName());
    }

    @Test
    public void directoryWriter_generateWebComponentsToDirectory_zeroExportersCreatesZeroFiles() {
        Set files = WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, new HashSet(), (File)this.outputDirectory, null);
        Assert.assertEquals((String)"No files were created", (long)0L, (long)files.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void directoryWriter_generateWebComponentsToDirectory_nonWriterClassThrows() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("but it is '" + MyComponent.class.getName() + "'");
        WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(MyComponent.class, new HashSet(), (File)this.outputDirectory, null);
    }

    @Test(expected=NullPointerException.class)
    public void directoryWriter_generateWebComponentsToDirectory_nullWriterThrows() {
        WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(null, new HashSet(), (File)this.outputDirectory, null);
    }

    @Test(expected=NullPointerException.class)
    public void directoryWriter_generateWebComponentsToDirectory_nullExporterSetThrows() {
        WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, null, (File)this.outputDirectory, null);
    }

    @Test(expected=NullPointerException.class)
    public void directoryWriter_generateWebComponentsToDirectory_nullOutputDirectoryThrows() {
        WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(WebComponentModulesWriter.class, new HashSet(), null, null);
    }

    public static class MyExporter
    extends WebComponentExporter<MyComponent> {
        public MyExporter() {
            super("real-tag");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class ExporterFactory
    implements WebComponentExporterFactory<MyComponent> {
        public WebComponentExporter<MyComponent> create() {
            return new PrivateExporter();
        }
    }

    public static class MyComponent
    extends Component {
    }

    private static class PrivateExporter
    extends WebComponentExporter<MyComponent> {
        public PrivateExporter() {
            super("foo-bar");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }
}

