/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.RouteRegistryTestBase;
import jakarta.servlet.ServletContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ApplicationRouteRegistryTest
extends RouteRegistryTestBase {
    private ApplicationRouteRegistry registry;

    @Before
    public void init() {
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext((ServletContext)Mockito.mock(ServletContext.class)));
    }

    @Test
    public void assertApplicationRegistry() {
        Assert.assertEquals(ApplicationRouteRegistry.class, (Object)this.getTestedRegistry().getClass());
    }

    @Test
    public void updateRoutesFromMultipleThreads_allRoutesAreRegistered() throws InterruptedException, ExecutionException {
        ArrayList<Callable<Result>> callables = new ArrayList<Callable<Result>>();
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("home", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("info", RouteRegistryTestBase.MyInfo.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("palace", RouteRegistryTestBase.MyPalace.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assert.assertEquals((String)"No exceptions should have been thrown for threaded updates.", (long)0L, (long)exceptions.size());
        Assert.assertTrue((String)"Route 'home' was not registered into the scope.", (boolean)this.getTestedRegistry().getNavigationTarget("home").isPresent());
        Assert.assertTrue((String)"Route 'info' was not registered into the scope.", (boolean)this.getTestedRegistry().getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"Route 'palace' was not registered into the scope.", (boolean)this.getTestedRegistry().getNavigationTarget("palace").isPresent());
    }

    @Test
    public void updateAndRemoveFromMultipleThreads_endResultAsExpected() throws InterruptedException, ExecutionException {
        this.getTestedRegistry().setRoute("home", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
        this.getTestedRegistry().setRoute("info", RouteRegistryTestBase.MyInfo.class, Collections.emptyList());
        ArrayList<Callable<Result>> callables = new ArrayList<Callable<Result>>();
        callables.add(() -> {
            try {
                this.getTestedRegistry().removeRoute("info");
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("modular", RouteRegistryTestBase.MyModular.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("palace", RouteRegistryTestBase.MyPalace.class, Collections.emptyList());
                this.getTestedRegistry().removeRoute("home");
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assert.assertEquals((String)"No exceptions should have been thrown for threaded updates.", (long)0L, (long)exceptions.size());
        Assert.assertFalse((String)"Route 'home' was still registered even though it should have been removed.", (boolean)this.getTestedRegistry().getNavigationTarget("home").isPresent());
        Assert.assertFalse((String)"Route 'info' was still registered even though it should have been removed.", (boolean)this.getTestedRegistry().getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"Route 'modular' was not registered into the scope.", (boolean)this.getTestedRegistry().getNavigationTarget("modular").isPresent());
        Assert.assertTrue((String)"Route 'palace' was not registered into the scope.", (boolean)this.getTestedRegistry().getNavigationTarget("palace").isPresent());
    }

    @Test
    public void lockingConfiguration_newConfigurationIsGottenOnlyAfterUnlock() {
        final CountDownLatch waitReaderThread = new CountDownLatch(1);
        final CountDownLatch waitUpdaterThread = new CountDownLatch(2);
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                ApplicationRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assert.assertTrue((String)"Registry should still remain empty", (boolean)ApplicationRouteRegistryTest.this.getTestedRegistry().getRegisteredRoutes().isEmpty());
                ApplicationRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assert.assertTrue((String)"Registry should still remain empty", (boolean)ApplicationRouteRegistryTest.this.getTestedRegistry().getRegisteredRoutes().isEmpty());
                waitReaderThread.countDown();
            }
        };
        readerThread.start();
        this.getTestedRegistry().update((Command & Serializable)() -> {
            this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            this.getTestedRegistry().setRoute("path", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            this.awaitCountDown(waitReaderThread);
        });
        Assert.assertEquals((String)"After unlock registry should be updated for others to configure with new data", (long)2L, (long)this.getTestedRegistry().getRegisteredRoutes().size());
    }

    @Test
    public void routeChangeListener_correctChangesAreReturned() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.getTestedRegistry().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
        Assert.assertFalse((String)"Added should contain data for one entry", (boolean)added.isEmpty());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        Assert.assertEquals(RouteRegistryTestBase.MyRoute.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assert.assertEquals((Object)"", (Object)((RouteBaseData)added.get(0)).getTemplate());
        this.getTestedRegistry().setRoute("home", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
        Assert.assertFalse((String)"Added should contain data for one entry", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Only latest change should be available", (long)1L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        Assert.assertEquals(RouteRegistryTestBase.Secondary.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assert.assertEquals((Object)"home", (Object)((RouteBaseData)added.get(0)).getTemplate());
        this.getTestedRegistry().removeRoute("home");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertFalse((String)"One route should have gotten removed", (boolean)removed.isEmpty());
        Assert.assertEquals(RouteRegistryTestBase.Secondary.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assert.assertEquals((String)"The 'home' route should have been removed", (Object)"home", (Object)((RouteBaseData)removed.get(0)).getTemplate());
    }

    @Test
    public void routeChangeListener_blockChangesAreGivenCorrectlyInEvent() {
        this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.getTestedRegistry().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.getTestedRegistry().update((Command & Serializable)() -> {
            this.getTestedRegistry().removeRoute("");
            this.getTestedRegistry().setRoute("path", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.singletonList(RouteRegistryTestBase.MainLayout.class));
        });
        Assert.assertFalse((String)"", (boolean)added.isEmpty());
        Assert.assertEquals((String)"", (long)2L, (long)added.size());
        Assert.assertFalse((String)"", (boolean)removed.isEmpty());
        for (RouteBaseData data : added) {
            if (data.getTemplate().equals("")) {
                Assert.assertEquals((String)"MyRoute should have been added", RouteRegistryTestBase.MyRoute.class, (Object)data.getNavigationTarget());
                Assert.assertEquals((String)"MyRoute should have been seen as a update as the parent layouts changed.", RouteRegistryTestBase.MainLayout.class, (Object)data.getParentLayout());
                continue;
            }
            Assert.assertEquals((String)"", RouteRegistryTestBase.Secondary.class, (Object)data.getNavigationTarget());
        }
        Assert.assertEquals((String)"MyRoute should have been both removed and added", RouteRegistryTestBase.MyRoute.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assert.assertEquals((String)"Removed version should not have a parent layout", Collections.emptyList(), (Object)((RouteBaseData)removed.get(0)).getParentLayouts());
    }

    @Test
    public void routeWithAliases_eventShowsCorrectlyAsRemoved() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.getTestedRegistry().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.getTestedRegistry().update((Command & Serializable)() -> {
            this.getTestedRegistry().setRoute("main", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            this.getTestedRegistry().setRoute("Alias1", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            this.getTestedRegistry().setRoute("Alias2", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
        });
        Assert.assertEquals((String)"Main route and aliases should all be seen as added.", (long)3L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        this.getTestedRegistry().removeRoute("Alias2");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Removing the alias route should be seen in the event", (long)1L, (long)removed.size());
    }

    @Test
    public void setErrorNavigationTargets_abstractClassesAreIgnored() {
        this.registry.setErrorNavigationTargets(new HashSet<Class>(Arrays.asList(RouteRegistryTestBase.ErrorView.class, RouteRegistryTestBase.AbstractErrorView.class)));
        Optional errorNavigationTarget = this.registry.getErrorNavigationTarget((Exception)new NullPointerException());
        Assert.assertTrue((String)"Error navigation target was not registered", (boolean)errorNavigationTarget.isPresent());
        Assert.assertEquals((String)"Wrong errorNavigationTarget was registered", RouteRegistryTestBase.ErrorView.class, (Object)((ErrorTargetEntry)errorNavigationTarget.get()).getNavigationTarget());
    }

    @Override
    protected RouteRegistry getInitializationRegistry() {
        return this.registry;
    }

    @Override
    protected RouteRegistry getTestedRegistry() {
        return this.registry;
    }

    private void awaitCountDown(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private static class Result {
        final String value;

        Result(String value) {
            this.value = value;
        }
    }
}

