/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameters;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RouteParametersTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void getters_provide_correct_values() {
        RouteParameters parameters = this.getParameters();
        Assert.assertEquals((String)"Wrong value", (Object)"foo", parameters.get("string").get());
        Assert.assertEquals((String)"Wrong value", (Object)"123", parameters.get("integer").get());
        Assert.assertEquals((String)"Wrong value", (Object)"12345678900", parameters.get("long").get());
        Assert.assertEquals((String)"Wrong value", (Object)"path/to/foo/bar", parameters.get("varargs").get());
        Assert.assertEquals((String)"Wrong value", (Object)123, parameters.getInteger("integer").get());
        Assert.assertEquals((String)"Wrong value", (Object)123L, parameters.getLong("integer").get());
        Assert.assertEquals((String)"Wrong value", (Object)12345678900L, parameters.getLong("long").get());
        Assert.assertEquals((String)"Wrong value", Arrays.asList("foo"), (Object)parameters.getWildcard("string"));
        Assert.assertEquals((String)"Wrong value", Arrays.asList("123"), (Object)parameters.getWildcard("integer"));
        Assert.assertEquals((String)"Wrong value", Arrays.asList("12345678900"), (Object)parameters.getWildcard("long"));
        Assert.assertEquals((String)"Wrong value", Arrays.asList("path", "to", "foo", "bar"), (Object)parameters.getWildcard("varargs"));
    }

    @Test
    public void getters_provide_empty_values() {
        RouteParameters parameters = this.getParameters();
        Assert.assertFalse((String)"Getting the String value of a non-existing parameter should return empty Optional", (boolean)parameters.get("foo").isPresent());
        Assert.assertFalse((String)"Getting the Integer value of a non-existing parameter should return empty Optional", (boolean)parameters.getInteger("foo").isPresent());
        Assert.assertFalse((String)"Getting the Long value of a non-existing parameter should return empty Optional", (boolean)parameters.getLong("foo").isPresent());
        Assert.assertTrue((String)"Getting the Wildcard value of a non-existing parameter should return empty List", (boolean)parameters.getWildcard("foo").isEmpty());
    }

    @Test
    public void integer_getter_stringParameter_throws() {
        RouteParameters parameters = this.getParameters();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Couldn't parse 'string' parameter value 'foo' as integer");
        parameters.getInteger("string");
    }

    @Test
    public void integer_getter_longParameter_throws() {
        RouteParameters parameters = this.getParameters();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Couldn't parse 'long' parameter value '12345678900' as integer");
        parameters.getInteger("long");
    }

    @Test
    public void integer_getter_varaargsParameter_throws() {
        RouteParameters parameters = this.getParameters();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Couldn't parse 'varargs' parameter value 'path/to/foo/bar' as integer");
        parameters.getInteger("varargs");
    }

    @Test
    public void long_getter_varaargsParameter_throws() {
        RouteParameters parameters = this.getParameters();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Couldn't parse 'varargs' parameter value 'path/to/foo/bar' as long");
        parameters.getLong("varargs");
    }

    @Test
    public void long_getter_stringParameter_throws() {
        RouteParameters parameters = this.getParameters();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Couldn't parse 'string' parameter value 'foo' as long");
        parameters.getLong("string");
    }

    @Test
    public void varargs_initializer_throws_exception() {
        try {
            new RouteParameters(new RouteParam[]{new RouteParam("int", "123"), new RouteParam("int", "123")});
            Assert.fail((String)"RouteParameters initializer should have failed with same parameter defined more than once.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private RouteParameters getParameters() {
        return new RouteParameters(new RouteParam[]{new RouteParam("string", "foo"), new RouteParam("integer", "123"), new RouteParam("long", "12345678900"), new RouteParam("varargs", "path/to/foo/bar")});
    }
}

