/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class StateNodeNodeListTest
extends AbstractNodeFeatureTest<ElementChildrenList> {
    private NodeList<StateNode> nodeList = (NodeList)this.createFeature();

    @Test
    public void testAddingAndRemoving() {
        StateNode value1 = StateNodeTest.createEmptyNode("value1");
        StateNode value2 = StateNodeTest.createEmptyNode("value2");
        this.nodeList.add((Serializable)value1);
        Assert.assertEquals((long)1L, (long)this.nodeList.size());
        Assert.assertSame((Object)value1, (Object)this.nodeList.get(0));
        List<NodeChange> firstAddChanges = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)firstAddChanges.size());
        ListAddChange firstAddChange = (ListAddChange)firstAddChanges.get(0);
        Assert.assertEquals((long)0L, (long)firstAddChange.getIndex());
        Assert.assertEquals(Arrays.asList(value1), (Object)firstAddChange.getNewItems());
        this.nodeList.add(0, (Serializable)value2);
        Assert.assertEquals((long)2L, (long)this.nodeList.size());
        Assert.assertSame((Object)value2, (Object)this.nodeList.get(0));
        Assert.assertSame((Object)value1, (Object)this.nodeList.get(1));
        List<NodeChange> secondAddChanges = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)secondAddChanges.size());
        ListAddChange secondAddChange = (ListAddChange)secondAddChanges.get(0);
        Assert.assertEquals((long)0L, (long)secondAddChange.getIndex());
        Assert.assertEquals(Arrays.asList(value2), (Object)secondAddChange.getNewItems());
        StateNode removedItem = (StateNode)this.nodeList.remove(0);
        Assert.assertEquals((long)1L, (long)this.nodeList.size());
        Assert.assertSame((Object)value1, (Object)this.nodeList.get(0));
        Assert.assertSame((Object)value2, (Object)removedItem);
        List<NodeChange> removeChanges = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)removeChanges.size());
        ListRemoveChange removeChange = (ListRemoveChange)removeChanges.get(0);
        Assert.assertEquals((long)0L, (long)removeChange.getIndex());
    }

    @Test
    public void testChangesAfterReset() {
        StateNode value1 = StateNodeTest.createEmptyNode("value1");
        StateNode value2 = StateNodeTest.createEmptyNode("value2");
        this.nodeList.add((Serializable)value1);
        this.nodeList.add((Serializable)value2);
        this.nodeList.getNode().clearChanges();
        this.nodeList.generateChangesFromEmpty();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        ListAddChange change = (ListAddChange)changes.get(0);
        Assert.assertEquals((long)0L, (long)change.getIndex());
        Assert.assertEquals(Arrays.asList(value1, value2), (Object)change.getNewItems());
    }

    @Test
    public void testAttachDetachChildren() {
        StateNode child = StateNodeTest.createEmptyNode("child");
        Assert.assertNull((Object)child.getParent());
        this.nodeList.add((Serializable)child);
        Assert.assertSame((Object)this.nodeList.getNode(), (Object)child.getParent());
        this.nodeList.remove(0);
        Assert.assertNull((Object)child.getParent());
    }

    @Test
    public void testIndexOf() {
        StateNode one = StateNodeTest.createEmptyNode("one");
        StateNode two = StateNodeTest.createEmptyNode("two");
        StateNode three = StateNodeTest.createEmptyNode("three");
        this.nodeList.add((Serializable)one);
        this.nodeList.add((Serializable)two);
        Assert.assertEquals((long)0L, (long)this.nodeList.indexOf((Serializable)one));
        Assert.assertEquals((long)1L, (long)this.nodeList.indexOf((Serializable)two));
        Assert.assertEquals((long)-1L, (long)this.nodeList.indexOf((Serializable)three));
    }

    @Test
    public void testClear() {
        StateNode one = StateNodeTest.createEmptyNode("one");
        StateNode two = StateNodeTest.createEmptyNode("two");
        this.nodeList.add((Serializable)one);
        this.nodeList.add((Serializable)two);
        Assert.assertEquals((long)2L, (long)this.nodeList.size());
        this.nodeList.clear();
        Assert.assertEquals((long)0L, (long)this.nodeList.size());
    }

    @Test(expected=AssertionError.class)
    public void nullNotAllowed() {
        this.nodeList.add(null);
    }

    @Test
    public void testSerializable() {
        int i;
        StateNode one = StateNodeTest.createTestNode("one", ElementClassList.class);
        ((ElementClassList)one.getFeature(ElementClassList.class)).add((Serializable)((Object)"foo"));
        ((ElementClassList)one.getFeature(ElementClassList.class)).add((Serializable)((Object)"bar"));
        StateNode two = StateNodeTest.createTestNode("two", ElementClassList.class);
        ((ElementClassList)two.getFeature(ElementClassList.class)).add((Serializable)((Object)"baz"));
        this.nodeList.add((Serializable)one);
        this.nodeList.add((Serializable)two);
        ArrayList<StateNode> values = new ArrayList<StateNode>();
        int size = this.nodeList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            values.add((StateNode)this.nodeList.get(i2));
        }
        NodeList copy = (NodeList)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(this.nodeList));
        Assert.assertNotSame(this.nodeList, (Object)copy);
        Assert.assertEquals((long)values.size(), (long)copy.size());
        for (i = 0; i < size; ++i) {
            this.assertNodeEquals((StateNode)values.get(i), (StateNode)copy.get(i));
        }
        Assert.assertEquals((long)values.size(), (long)this.nodeList.size());
        for (i = 0; i < size; ++i) {
            this.assertNodeEquals((StateNode)values.get(i), (StateNode)this.nodeList.get(i));
        }
    }
}

