/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void commentRemoval_handlesCommentsCorrectly() {
        String singleLineBlock = StringUtil.removeComments((String)"return html'/* single line block comment*/';");
        Assert.assertEquals((Object)"return html'';", (Object)singleLineBlock);
        String blockComment = StringUtil.removeComments((String)"return html'/* block with new lines\n* still in my/their block */';");
        Assert.assertEquals((Object)"return html'';", (Object)blockComment);
        String newLineSingleBlock = StringUtil.removeComments((String)"return html'/* not here \n*/';");
        Assert.assertEquals((Object)"return html'';", (Object)newLineSingleBlock);
        String noComments = "<vaadin-text-field label=\"Nats Url(s)\" placeholder=\"nats://server:port\" id=\"natsUrlTxt\" style=\"width:100%\"></vaadin-text-field>`";
        Assert.assertEquals((Object)noComments, (Object)StringUtil.removeComments((String)noComments));
        String lineComment = StringUtil.removeComments((String)"return html'// this line comment\n';");
        Assert.assertEquals((Object)"return html'\n';", (Object)lineComment);
        String mixedComments = StringUtil.removeComments((String)"return html'/* not here \n*/\nCode;// neither this\n/* this should // be fine\n* to remove / */';");
        Assert.assertEquals((Object)"return html'\nCode;\n';", (Object)mixedComments);
    }

    @Test
    public void commentRemoval_emojiInString_removalDoesnotThrowResultIsTheSame() {
        String initialTemplate = "import { html } from '@polymer/polymer/lib/utils/html-tag.js';\nclass EmployeeForm extends PolymerElement {\n  static get template() {\n    return html`\n   <div style=\"width: 100%; height: 100%;\" class=\"scroll-div\"> \n    <iron-pages selected=\"[[page]]\"> \n     <page>\n\ud83d\udea7 Training: Coming soon \ud83d\udea7\n</page> \n    </iron-pages> \n   </div> \n`;\n  }\n\n";
        String template = StringUtil.removeComments((String)initialTemplate);
        Assert.assertEquals((Object)initialTemplate, (Object)template);
    }

    @Test
    public void removeComments_commentsWithAsterisksInside_commentIsRemoved() {
        String result = StringUtil.removeComments((String)"/* comment **/ ;");
        Assert.assertEquals((Object)" ;", (Object)result);
    }

    @Test
    public void removeJsComments_handlesApostropheAsInString() {
        String httpImport = "import 'http://localhost:56445/files/transformed/@vaadin/vaadin-text-field/vaadin-text-field.js';";
        Assert.assertEquals((String)"Nothing shoiuld be removed for import", (Object)httpImport, (Object)StringUtil.removeComments((String)httpImport, (boolean)true));
        String result = StringUtil.removeComments((String)"/* comment **/ ;", (boolean)true);
        Assert.assertEquals((Object)" ;", (Object)result);
        String singleLineBlock = StringUtil.removeComments((String)"return html`/* single line block comment*/`;", (boolean)true);
        Assert.assertEquals((Object)"return html``;", (Object)singleLineBlock);
        String blockComment = StringUtil.removeComments((String)"return html`/* block with new lines\n* still in my/their block */`;", (boolean)true);
        Assert.assertEquals((Object)"return html``;", (Object)blockComment);
        String newLineSingleBlock = StringUtil.removeComments((String)"return html`/* not here \n*/`;", (boolean)true);
        Assert.assertEquals((Object)"return html``;", (Object)newLineSingleBlock);
        String noComments = "<vaadin-text-field label=\"Nats Url(s)\" placeholder=\"nats://server:port\" id=\"natsUrlTxt\" style=\"width:100%\"></vaadin-text-field>`";
        Assert.assertEquals((Object)noComments, (Object)StringUtil.removeComments((String)noComments, (boolean)true));
        String lineComment = StringUtil.removeComments((String)"return html`// this line comment\n`;", (boolean)true);
        Assert.assertEquals((Object)"return html`\n`;", (Object)lineComment);
        String mixedComments = StringUtil.removeComments((String)"return html`/* not here \n*/\nCode;// neither this\n/* this should // be fine\n* to remove / */`;", (boolean)true);
        Assert.assertEquals((Object)"return html`\nCode;\n`;", (Object)mixedComments);
    }

    @Test
    public void stripSuffix() {
        Assert.assertEquals((Object)"foo", (Object)StringUtil.stripSuffix((String)"foo", (String)"bar"));
        Assert.assertEquals((Object)"foo", (Object)StringUtil.stripSuffix((String)"foobar", (String)"bar"));
        Assert.assertEquals((Object)"foobar", (Object)StringUtil.stripSuffix((String)"foobarbar", (String)"bar"));
        Assert.assertEquals((Object)"", (Object)StringUtil.stripSuffix((String)"", (String)"bar"));
    }
}

