/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.PollEvent;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ComponentUtilTest {
    private Component component = new ComponentTest.TestDiv();

    @Test
    public void setData_byString() {
        Assert.assertNull((String)"There should initially not be any value", (Object)ComponentUtil.getData((Component)this.component, (String)"name"));
        ComponentUtil.setData((Component)this.component, (String)"name", (Object)"value");
        Assert.assertEquals((String)"The stored value should be returned", (Object)"value", (Object)ComponentUtil.getData((Component)this.component, (String)"name"));
        ComponentUtil.setData((Component)this.component, (String)"name", (Object)"value2");
        Assert.assertEquals((String)"The replaced value should be returned", (Object)"value2", (Object)ComponentUtil.getData((Component)this.component, (String)"name"));
        ComponentUtil.setData((Component)this.component, (String)"name", null);
        Assert.assertNull((String)"The value should be removed", (Object)ComponentUtil.getData((Component)this.component, (String)"name"));
        Assert.assertNull((String)"Storage should be cleared after removing the last attribute", (Object)this.component.attributes);
    }

    @Test
    public void setData_byClass() {
        Integer instance1 = new Integer(1);
        Integer instance2 = new Integer(2);
        Assert.assertNull((String)"There should initially not be any value", (Object)ComponentUtil.getData((Component)this.component, Integer.class));
        ComponentUtil.setData((Component)this.component, Integer.class, (Object)instance1);
        Assert.assertSame((String)"The stored value should be returned", (Object)instance1, (Object)ComponentUtil.getData((Component)this.component, Integer.class));
        Assert.assertNull((String)"Attribute should not be available based on super type", (Object)ComponentUtil.getData((Component)this.component, Number.class));
        ComponentUtil.setData((Component)this.component, Integer.class, (Object)instance2);
        Assert.assertSame((String)"The replaced value should be returned", (Object)instance2, (Object)ComponentUtil.getData((Component)this.component, Integer.class));
        ComponentUtil.setData((Component)this.component, Integer.class, null);
        Assert.assertNull((String)"The value should be removed", (Object)ComponentUtil.getData((Component)this.component, Integer.class));
        Assert.assertNull((String)"Storage should be cleared after removing the last attribute", (Object)this.component.attributes);
    }

    @Test
    public void addListenerToComponent_hasListener_returnsTrue() {
        Assert.assertFalse((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
        Registration listener = ComponentUtil.addListener((Component)this.component, PollEvent.class, (ComponentEventListener & Serializable)event -> {});
        Assert.assertTrue((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
        listener.remove();
        Assert.assertFalse((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
    }

    @Test
    public void addListenerToComponent_getListeners_returnsCollection() {
        Assert.assertFalse((boolean)ComponentUtil.hasEventListener((Component)this.component, PollEvent.class));
        Registration listener = ComponentUtil.addListener((Component)this.component, PollEvent.class, (ComponentEventListener & Serializable)event -> {});
        Collection listeners = ComponentUtil.getListeners((Component)this.component, PollEvent.class);
        Assert.assertEquals((long)1L, (long)listeners.size());
        listener.remove();
        Assert.assertTrue((boolean)ComponentUtil.getListeners((Component)this.component, PollEvent.class).isEmpty());
    }

    @Test
    public void registerComponentClass_and_getComponentsByTag_shouldReturnCorrectComponent() {
        Class<ComponentTest.TestDiv> testComponentClass = ComponentTest.TestDiv.class;
        String testTag = "test-div";
        ComponentUtil.registerComponentClass((String)testTag, testComponentClass);
        Set retrievedClasses = ComponentUtil.getComponentsByTag((String)testTag);
        Assert.assertTrue((String)"The retrieved classes should contain the registered component class", (boolean)retrievedClasses.contains(testComponentClass));
        ComponentUtil.getComponentsByTag((String)testTag).clear();
    }

    @Test
    public void getComponentsByTag_withUnregisteredTag_shouldReturnEmptySet() {
        String unregisteredTag = "unregistered-tag";
        Set retrievedClasses = ComponentUtil.getComponentsByTag((String)unregisteredTag);
        Assert.assertTrue((String)"The retrieved classes should be empty for an unregistered tag", (boolean)retrievedClasses.isEmpty());
    }
}

