/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinSession;
import java.util.List;
import org.mockito.Mockito;

public class MockUI
extends UI {
    private Page page;

    public MockUI() {
        this(MockUI.findOrCreateSession());
    }

    public MockUI(VaadinSession session) {
        this.getInternals().setSession(session);
        MockUI.setCurrent((UI)this);
    }

    public MockUI(Router router) {
        this(MockUI.createSession(router));
    }

    public Page getPage() {
        if (this.page != null) {
            return this.page;
        }
        return super.getPage();
    }

    public void setPage(Page page) {
        this.page = page;
    }

    protected void init(VaadinRequest request) {
    }

    public List<PendingJavaScriptInvocation> dumpPendingJsInvocations() {
        this.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        return this.getInternals().dumpPendingJavaScriptInvocations();
    }

    private static VaadinSession findOrCreateSession() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            session = MockUI.createSession();
        }
        return session;
    }

    private static VaadinSession createSession() {
        return MockUI.createSession(null);
    }

    private static VaadinSession createSession(Router router) {
        MockServletServiceSessionSetup setup = new MockServletServiceSessionSetup();
        VaadinSession session = setup.getSession();
        if (router != null) {
            setup.getService().setRouter(router);
        }
        VaadinSession.setCurrent((VaadinSession)session);
        return session;
    }

    private static DeploymentConfiguration createConfiguration() {
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        return configuration;
    }

    public static MockUI createUI() {
        return new MockUI(MockUI.createSession());
    }
}

