/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.dau.DAUCustomizer;
import com.vaadin.flow.server.dau.DAUVaadinRequestInterceptor;
import com.vaadin.flow.server.dau.UserIdentitySupplier;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.http.Cookie;
import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DAUVaadinRequestInterceptorTest {
    public static final String APP_ID = "MY-APP";
    private MockDeploymentConfiguration configuration;
    private MockVaadinServletService vaadinService;
    private DAUVaadinRequestInterceptor interceptor;
    private String originalSubscriptionKey;

    @Before
    public void setUp() throws Exception {
        this.configuration = new MockDeploymentConfiguration();
        this.configuration.setApplicationOrSystemProperty("applicationIdentifier", APP_ID);
        this.vaadinService = new MockVaadinServletService((DeploymentConfiguration)this.configuration);
        this.interceptor = new DAUVaadinRequestInterceptor((DeploymentConfiguration)this.configuration, null);
        this.originalSubscriptionKey = System.getProperty("vaadin.subscriptionKey");
        System.setProperty("vaadin.subscriptionKey", "sub-123");
    }

    @After
    public void tearDown() throws Exception {
        if (this.originalSubscriptionKey != null) {
            System.setProperty("vaadin.subscriptionKey", this.originalSubscriptionKey);
        } else {
            System.clearProperty("vaadin.subscriptionKey");
        }
    }

    @Test
    public void requestStart_initRequest_dauCookieAbsent_createCookie() {
        this.assertCookieCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
            Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        });
    }

    @Test
    public void requestStart_uidlRequest_dauCookieAbsent_createCookie() {
        this.assertCookieCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"POST");
            Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.UIDL.getIdentifier());
        });
    }

    @Test
    public void requestStart_indexHtmlRequest_dauCookieAbsent_createCookie() {
        this.assertCookieCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        });
        this.assertCookieCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn(null);
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        });
        this.assertCookieCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        });
    }

    @Test
    public void requestStart_trackableRequest_dauCookieAbsent_pushWebsocket_doNotCreateCookie() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.UIDL.getIdentifier());
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[0]);
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try {
            this.interceptor.requestStart(request, null);
        }
        finally {
            VaadinSession.setCurrent(null);
        }
        ((VaadinResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addCookie((Cookie)ArgumentMatchers.any());
    }

    @Test
    public void requestStart_notTrackableRequest_dauCookieAbsent_doNotCreateCookie() {
        this.assertCookieNotCreated(request -> Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.HEARTBEAT.getIdentifier()));
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"POST");
        });
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn(null);
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"POST");
        });
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"POST");
        });
    }

    @Test
    public void requestStart_notTrackableInternalRequests_dauCookieAbsent_doNotCreateCookie() {
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/VAADIN/something");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        });
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/VAADIN/dynamic");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"POST");
        });
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/HILLA/push");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"POST");
        });
        this.assertCookieNotCreated(request -> {
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/HILLA/push");
            Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        });
    }

    @Test
    public void requestStart_notTrackableStaticResourceRequest_dauCookieAbsent_doNotCreateCookie() {
        for (String resourcePath : HandlerHelper.getPublicResources()) {
            this.assertCookieNotCreated(request -> {
                Mockito.when((Object)request.getPathInfo()).thenReturn((Object)resourcePath);
                Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
            });
        }
        for (String resourcePath : HandlerHelper.getPublicResourcesRoot()) {
            this.assertCookieNotCreated(request -> {
                Mockito.when((Object)request.getPathInfo()).thenReturn((Object)resourcePath);
                Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_notTrackablePWAIconsRequests_dauCookieAbsent_doNotCreateCookie() {
        final Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                VaadinContext context = super.getContext();
                if (context.getAttribute(Lookup.class) == null) {
                    context.setAttribute(Lookup.class, (Object)lookup);
                }
                return context;
            }
        };
        AppShellRegistry.getInstance((VaadinContext)service.getContext()).setShell(FakeAppShell.class);
        VaadinService.setCurrent((VaadinService)service);
        try {
            for (String resourcePath : HandlerHelper.getIconVariants((String)"/my/icons/icon.png")) {
                this.assertCookieNotCreated(request -> {
                    Mockito.when((Object)request.getService()).thenReturn((Object)service);
                    Mockito.when((Object)request.getPathInfo()).thenReturn((Object)resourcePath);
                    Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
                });
            }
        }
        finally {
            VaadinService.setCurrent(null);
        }
    }

    @Test
    public void serviceInit_shouldStartDauTracking() {
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.serviceInit(new ServiceInitEvent((VaadinService)this.vaadinService));
            dauIntegration.verify(() -> DauIntegration.startTracking((String)APP_ID));
        }
    }

    @Test
    public void serviceDestroy_shouldStopDauTracking() {
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.serviceDestroy(new ServiceDestroyEvent((VaadinService)this.vaadinService));
            dauIntegration.verify(DauIntegration::stopTracking);
        }
    }

    @Test
    public void serviceInit_shouldInstallServiceDestroyListenerToStopDauTrackingOnShutdown() {
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.serviceInit(new ServiceInitEvent((VaadinService)this.vaadinService));
            dauIntegration.verify(() -> DauIntegration.startTracking((String)APP_ID));
            this.vaadinService.destroy();
            dauIntegration.verify(DauIntegration::stopTracking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_dauCookiePresent_activeUser_trackUser() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        String trackingHash = "trackingHash";
        Cookie cookie = DAUVaadinRequestInterceptorTest.createCookie(trackingHash, true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.requestStart(request, response);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)trackingHash, null));
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_dauCookiePresent_activeUser_identitySupplier_trackUser() {
        String userIdentity = "user";
        final UserIdentitySupplier & Serializable identitySupplier = (UserIdentitySupplier & Serializable)userIdentityContext -> Optional.of(userIdentity);
        DAUCustomizer dauCustomizer = new DAUCustomizer(){

            public UserIdentitySupplier getUserIdentitySupplier() {
                return identitySupplier;
            }
        };
        this.interceptor = new DAUVaadinRequestInterceptor((DeploymentConfiguration)this.configuration, dauCustomizer);
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        String trackingHash = "trackingHash";
        Cookie cookie = DAUVaadinRequestInterceptorTest.createCookie(trackingHash, true);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.requestStart(request, response);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)trackingHash, (String)userIdentity));
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_dauCookiePresent_notActiveUser_trackUser() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        String trackingHash = "trackingHash";
        Cookie cookie = DAUVaadinRequestInterceptorTest.createCookie(trackingHash, false);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.requestStart(request, response);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)trackingHash, null), Mockito.never());
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_invalidCookie_doNotTrack() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        Cookie cookie = new Cookie("DailyActiveUser", "invalid-cookie-value");
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            this.interceptor.requestStart(request, response);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)ArgumentMatchers.anyString(), (String)((String)ArgumentMatchers.any())), Mockito.never());
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_dauCookiePresent_notActiveUser_enforcement_tracksUser() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        String trackingHash = "trackingHash";
        Instant creationTime = Instant.now().minusSeconds(30L);
        Cookie cookie = new Cookie("DailyActiveUser", trackingHash + "$" + creationTime.toEpochMilli());
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            dauIntegration.when(DauIntegration::shouldEnforce).thenReturn((Object)true);
            this.interceptor.requestStart(request, response);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)trackingHash, null));
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestStart_noDauCookie_notActiveUser_enforcement_tracksUser() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        String trackingHash = "trackingHash";
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            dauIntegration.when(DauIntegration::shouldEnforce).thenReturn((Object)true);
            dauIntegration.when(DauIntegration::newTrackingHash).thenReturn((Object)trackingHash);
            this.interceptor.requestStart(request, response);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)trackingHash, null));
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    private static Cookie createCookie(String trackingHash, boolean active) {
        Instant creationTime = Instant.now();
        if (active) {
            creationTime = creationTime.minusSeconds(120L);
        }
        return new Cookie("DailyActiveUser", trackingHash + "$" + creationTime.toEpochMilli());
    }

    private void assertCookieCreated(Consumer<VaadinRequest> requestCustomizer) {
        this.assertDauCookie(requestCustomizer, true);
    }

    private void assertCookieNotCreated(Consumer<VaadinRequest> requestCustomizer) {
        this.assertDauCookie(requestCustomizer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertDauCookie(Consumer<VaadinRequest> requestCustomizer, boolean expectCookieCreated) {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[0]);
        requestCustomizer.accept(request);
        VaadinSession.setCurrent((VaadinSession)new MockVaadinSession((VaadinService)this.vaadinService));
        try {
            this.interceptor.requestStart(request, response);
        }
        finally {
            VaadinSession.setCurrent(null);
        }
        if (expectCookieCreated) {
            ((VaadinResponse)Mockito.verify((Object)response)).addCookie((Cookie)ArgumentMatchers.argThat(cookie -> "DailyActiveUser".equals(cookie.getName())));
        } else {
            ((VaadinResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addCookie((Cookie)ArgumentMatchers.any());
        }
    }

    @PWA(iconPath="/my/icons/icon.png", name="A", shortName="B")
    public static class FakeAppShell
    implements AppShellConfigurator {
        static final String BASE_ICON_PATH = "/my/icons/icon.png";
    }
}

