/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamRequestHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@NotThreadSafe
public class StreamRequestHandlerTest {
    private StreamRequestHandler handler = new StreamRequestHandler();
    private MockVaadinSession session;
    private VaadinServletRequest request;
    private VaadinResponse response;
    private StreamResourceRegistry streamResourceRegistry;
    private UI ui;

    @Before
    public void setUp() throws ServletException, ServiceException {
        MockVaadinServletService service = new MockVaadinServletService();
        this.session = new AlwaysLockedVaadinSession((VaadinService)service){

            public StreamResourceRegistry getResourceRegistry() {
                return StreamRequestHandlerTest.this.streamResourceRegistry;
            }
        };
        this.streamResourceRegistry = new StreamResourceRegistry((VaadinSession)this.session);
        this.request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getMimeType(Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)servletContext);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.ui = new MockUI();
        UI.setCurrent((UI)this.ui);
    }

    @After
    public void cleanup() {
        CurrentInstance.clearAll();
    }

    @Test
    public void streamResourceNameEndsWithPluses_streamFactory_resourceIsStreamed() throws IOException {
        this.testStreamResourceInputStreamFactory("end with multiple pluses", "readme++.md");
    }

    @Test
    public void streamResourceNameEndsWithPluses_resourceWriter_resourceIsStreamed() throws IOException {
        this.testStreamResourceStreamResourceWriter("end with multiple pluses", "readme++.md");
    }

    @Test
    public void streamResourceNameContainsSpaceEndsWithPluses_streamFactory_resourceIsStreamed() throws IOException {
        this.testStreamResourceInputStreamFactory("end with space and multiple pluses", "readme ++.md");
    }

    @Test
    public void streamResourceNameContainsSpaceEndsWithPluses_resourceWriter_resourceIsStreamed() throws IOException {
        this.testStreamResourceStreamResourceWriter("end with space and multiple pluses", "readme ++.md");
    }

    @Test
    public void streamResourceNameEndsInPlus_streamFactory_resourceIsStreamed() throws IOException {
        this.testStreamResourceInputStreamFactory("end in plus", "readme+.md");
    }

    @Test
    public void streamResourceNameEndsInPlus_resourceWriter_resourceIsStreamed() throws IOException {
        this.testStreamResourceStreamResourceWriter("end in plus", "readme+.md");
    }

    @Test
    public void streamResourceNameContainsPlus_streamFactory_resourceIsStreamed() throws IOException {
        this.testStreamResourceInputStreamFactory("plus in middle", "readme+mine.md");
    }

    @Test
    public void streamResourceNameContainsPlus_resourceWriter_resourceIsStreamed() throws IOException {
        this.testStreamResourceStreamResourceWriter("plus in middle", "readme+mine.md");
    }

    @Test
    public void streamResourceNameContainsPlusAndSpaces_streamFactory_resourceIsStreamed() throws IOException {
        this.testStreamResourceInputStreamFactory("plus surrounded by spaces", "readme + mine.md");
    }

    @Test
    public void streamResourceNameContainsPlusAndSpaces_resourceWriter_resourceIsStreamed() throws IOException {
        this.testStreamResourceStreamResourceWriter("plus surrounded by spaces", "readme + mine.md");
    }

    @Test
    public void stateNodeStates_handlerMustNotReplyWhenNodeDisabled() throws IOException {
        this.stateNodeStatesTestInternal(false, true);
        ((VaadinResponse)Mockito.verify((Object)this.response)).sendError(403, "Resource not available");
    }

    @Test
    public void nodeDisabled_shouldReplyForDisabledUpdateModeAlways() throws IOException {
        TestElementHandlerBuilder builder = new TestElementHandlerBuilder().withDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        this.stateNodeStatesTestInternal(builder);
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(Mockito.anyInt(), Mockito.anyString());
    }

    @Test
    public void nodeInert_shouldRespondWithResourceNotAvailable() throws IOException {
        TestElementHandlerBuilder builder = new TestElementHandlerBuilder().withInert(true);
        this.stateNodeStatesTestInternal(builder);
        ((VaadinResponse)Mockito.verify((Object)this.response)).sendError(403, "Resource not available");
    }

    @Test
    public void nodeInert_handlerShouldReplyForAllowInert() throws IOException {
        TestElementHandlerBuilder builder = new TestElementHandlerBuilder().withInert(true).withAllowInert(true);
        this.stateNodeStatesTestInternal(builder);
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(Mockito.anyInt(), Mockito.anyString());
    }

    @Test
    public void nodeHidden_shouldRespondWithResourceNotAvailable() throws IOException {
        TestElementHandlerBuilder builder = new TestElementHandlerBuilder().withVisible(false);
        this.stateNodeStatesTestInternal(builder);
        ((VaadinResponse)Mockito.verify((Object)this.response)).sendError(403, "Resource not available");
    }

    @Test
    public void stateNodeStates_handlerMustNotReplyWhenNodeDetached() throws IOException {
        this.stateNodeStatesTestInternal(true, false);
        ((VaadinResponse)Mockito.verify((Object)this.response)).sendError(403, "Resource not available");
    }

    @Test
    public void stateNodeStates_handlerMustReplyWhenNodeAttachedAndEnabled() throws IOException {
        this.stateNodeStatesTestInternal(true, true);
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendError(Mockito.anyInt(), Mockito.anyString());
    }

    private VaadinResponse stateNodeStatesTestInternal(boolean enabled, boolean attached) throws IOException {
        TestElementHandlerBuilder builder = new TestElementHandlerBuilder().withEnalbed(enabled).withAttached(attached);
        return this.stateNodeStatesTestInternal(builder);
    }

    private VaadinResponse stateNodeStatesTestInternal(TestElementHandlerBuilder builder) throws IOException {
        ElementRequestHandler stateHandler = builder.buildElementRequestHandler();
        TestStateNodeProperties testStateNodeProperties = builder.buildStateNodeProperties();
        Element owner = (Element)Mockito.mock(Element.class);
        StateNode stateNode = (StateNode)Mockito.mock(StateNode.class);
        Mockito.when((Object)owner.getNode()).thenReturn((Object)stateNode);
        Mockito.when((Object)stateNode.isEnabled()).thenReturn((Object)testStateNodeProperties.enabled);
        Mockito.when((Object)stateNode.isAttached()).thenReturn((Object)testStateNodeProperties.attached);
        Mockito.when((Object)stateNode.isVisible()).thenReturn((Object)testStateNodeProperties.visible);
        Mockito.when((Object)stateNode.isInert()).thenReturn((Object)testStateNodeProperties.inert);
        StreamResourceRegistry.ElementStreamResource res = new StreamResourceRegistry.ElementStreamResource(stateHandler, owner);
        this.streamResourceRegistry.registerResource((AbstractStreamResource)res);
        ServletOutputStream outputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)String.format("/%s%s/%s/%s", "VAADIN/dynamic/resource/", this.ui.getId().orElse("-1"), res.getId(), res.getName()));
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        return this.response;
    }

    private void testStreamResourceInputStreamFactory(String testString, String fileName) throws IOException {
        byte[] testBytes = testString.getBytes();
        StreamResource res = new StreamResource(fileName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(testBytes));
        this.streamResourceRegistry.registerResource((AbstractStreamResource)res);
        ServletOutputStream outputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)String.format("/%s%s/%s/%s", "VAADIN/dynamic/resource/", this.ui.getId().orElse("-1"), res.getId(), res.getName()));
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        ((VaadinResponse)Mockito.verify((Object)this.response)).getOutputStream();
        ArgumentCaptor argument = ArgumentCaptor.forClass(byte[].class);
        ((ServletOutputStream)Mockito.verify((Object)outputStream)).write((byte[])argument.capture(), Mockito.anyInt(), Mockito.anyInt());
        byte[] buf = new byte[1024];
        for (int i = 0; i < testBytes.length; ++i) {
            buf[i] = testBytes[i];
        }
        Assert.assertArrayEquals((String)"Output differed from expected", (byte[])buf, (byte[])((byte[])argument.getValue()));
        ((VaadinResponse)Mockito.verify((Object)this.response)).setCacheTime(Mockito.anyLong());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/octet-stream");
    }

    private void testStreamResourceStreamResourceWriter(String testString, String fileName) throws IOException {
        byte[] testBytes = testString.getBytes();
        StreamResource res = new StreamResource(fileName, (StreamResourceWriter & Serializable)(stream, session) -> stream.write(testBytes));
        this.streamResourceRegistry.registerResource((AbstractStreamResource)res);
        ServletOutputStream outputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)String.format("/%s%s/%s/%s", "VAADIN/dynamic/resource/", this.ui.getId().orElse("-1"), res.getId(), res.getName()));
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, this.response);
        ((VaadinResponse)Mockito.verify((Object)this.response)).getOutputStream();
        ArgumentCaptor argument = ArgumentCaptor.forClass(byte[].class);
        ((ServletOutputStream)Mockito.verify((Object)outputStream)).write((byte[])argument.capture());
        Assert.assertArrayEquals((String)"Output differed from expected", (byte[])testBytes, (byte[])((byte[])argument.getValue()));
        ((VaadinResponse)Mockito.verify((Object)this.response)).setCacheTime(Mockito.anyLong());
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType("application/octet-stream");
    }

    private static final class TestElementHandlerBuilder {
        private final TestElementHandlerProperties elementHandlerProperties = new TestElementHandlerProperties(DisabledUpdateMode.ONLY_WHEN_ENABLED, false);
        private final TestStateNodeProperties stateNodeProperties = new TestStateNodeProperties(true, true, false, true);

        public TestElementHandlerBuilder withEnalbed(boolean enabled) {
            this.stateNodeProperties.enabled = enabled;
            return this;
        }

        public TestElementHandlerBuilder withAttached(boolean attached) {
            this.stateNodeProperties.attached = attached;
            return this;
        }

        public TestElementHandlerBuilder withInert(boolean inert) {
            this.stateNodeProperties.inert = inert;
            return this;
        }

        public TestElementHandlerBuilder withVisible(boolean visible) {
            this.stateNodeProperties.visible = visible;
            return this;
        }

        public TestElementHandlerBuilder withDisabledUpdateMode(DisabledUpdateMode disabledUpdateMode) {
            this.elementHandlerProperties.disabledUpdateMode = disabledUpdateMode;
            return this;
        }

        public TestElementHandlerBuilder withAllowInert(boolean allowInert) {
            this.elementHandlerProperties.allowInert = allowInert;
            return this;
        }

        public TestStateNodeProperties buildStateNodeProperties() {
            return new TestStateNodeProperties(this.stateNodeProperties.enabled, this.stateNodeProperties.attached, this.stateNodeProperties.inert, this.stateNodeProperties.visible);
        }

        public ElementRequestHandler buildElementRequestHandler() {
            return new ElementRequestHandler(){

                public void handleRequest(VaadinRequest request, VaadinResponse response, VaadinSession session, Element owner) {
                }

                public boolean isAllowInert() {
                    return elementHandlerProperties.allowInert;
                }

                public DisabledUpdateMode getDisabledUpdateMode() {
                    return elementHandlerProperties.disabledUpdateMode;
                }
            };
        }
    }

    private static final class TestStateNodeProperties {
        private boolean enabled;
        private boolean attached;
        private boolean inert;
        private boolean visible;

        private TestStateNodeProperties(boolean enabled, boolean attached, boolean inert, boolean visible) {
            this.enabled = enabled;
            this.attached = attached;
            this.inert = inert;
            this.visible = visible;
        }
    }

    private static final class TestElementHandlerProperties {
        private DisabledUpdateMode disabledUpdateMode;
        private boolean allowInert;

        private TestElementHandlerProperties(DisabledUpdateMode disabledUpdateMode, boolean allowInert) {
            this.disabledUpdateMode = disabledUpdateMode;
            this.allowInert = allowInert;
        }
    }
}

