/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.QueryParameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LocationTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void parseLocation() {
        Location location = new Location("foo/bar/baz");
        Assert.assertEquals(Arrays.asList("foo", "bar", "baz"), (Object)location.getSegments());
        Assert.assertEquals((Object)"foo/bar/baz", (Object)location.getPath());
    }

    @Test
    public void parseLocationWithEndingSlash() {
        Location location = new Location("foo/bar/");
        Assert.assertEquals(Arrays.asList("foo", "bar", ""), (Object)location.getSegments());
    }

    @Test
    public void parseLocationStartingWithSlash() {
        Location location = new Location("/foo/bar/");
        Assert.assertEquals(Arrays.asList("foo", "bar", ""), (Object)location.getSegments());
    }

    @Test
    public void parseNullLocation() {
        Location location = new Location((String)null);
        Assert.assertEquals(Arrays.asList(""), (Object)location.getSegments());
    }

    @Test
    public void parseNullLocationWithParameters() {
        Location location = new Location((String)null, QueryParameters.fromString((String)"foo"));
        Assert.assertEquals(Arrays.asList(""), (Object)location.getSegments());
    }

    @Test
    public void parseLocationWithQueryStringOnly() {
        Location location = new Location("?hey=hola&zz=");
        Assert.assertEquals((Object)"", (Object)location.getPath());
        HashMap<String, List<String>> queryMap = new HashMap<String, List<String>>();
        queryMap.put("hey", Collections.singletonList("hola"));
        queryMap.put("zz", Collections.emptyList());
        Assert.assertEquals(Collections.singletonList("hola"), location.getQueryParameters().getParameters().get("hey"));
        Assert.assertEquals(Collections.singletonList(""), location.getQueryParameters().getParameters().get("zz"));
    }

    @Test
    public void parseLocationWithQueryString_noValue() {
        Location location = new Location("path?query");
        Assert.assertEquals((Object)"path", (Object)location.getPath());
        Assert.assertEquals(Collections.singletonMap("query", Collections.singletonList("")), (Object)location.getQueryParameters().getParameters());
        Assert.assertEquals((Object)"path?query", (Object)location.getPathWithQueryParameters());
    }

    @Test
    public void parseLocationWithQueryString_emptyValue() {
        Location location = new Location("path?query=");
        Assert.assertEquals((Object)"path", (Object)location.getPath());
        Assert.assertEquals(Collections.singletonMap("query", Collections.singletonList("")), (Object)location.getQueryParameters().getParameters());
        Assert.assertEquals((Object)"path?query", (Object)location.getPathWithQueryParameters());
    }

    @Test
    public void locationFromSegments() {
        Location location = new Location(Arrays.asList("one", "two"));
        Assert.assertEquals(Arrays.asList("one", "two"), (Object)location.getSegments());
        Assert.assertEquals((Object)"one/two", (Object)location.getPath());
    }

    @Test
    public void queryValue_decodedCorrectly() {
        QueryParameters queryParameters = new Location("home?value+part").getQueryParameters();
        Assert.assertEquals((String)"'+' should be decoded in map", (Object)"value part", queryParameters.getParameters().keySet().iterator().next());
        Assert.assertEquals((String)"'+' should not be decoded in query param string", (Object)"value%20part", (Object)queryParameters.getQueryString());
        queryParameters = new Location("home?someValue1%2BsomeValue2").getQueryParameters();
        Assert.assertEquals((String)"'%2B' should be decoded in map", (Object)"someValue1+someValue2", queryParameters.getParameters().keySet().iterator().next());
        Assert.assertEquals((String)"'%2B' should not be decoded in query param string", (Object)"someValue1%2BsomeValue2", (Object)queryParameters.getQueryString());
        queryParameters = new Location("home?%25HF").getQueryParameters();
        Assert.assertEquals((String)"'%25' should be decoded in map", (Object)"%HF", queryParameters.getParameters().keySet().iterator().next());
        Assert.assertEquals((String)"'%25' should not be decoded in query param string", (Object)"%25HF", (Object)queryParameters.getQueryString());
        queryParameters = new Location("home?p=%26&q=%20").getQueryParameters();
        Assert.assertEquals((String)"'%26' should be decoded in map", (Object)"&", ((List)queryParameters.getParameters().get("p")).get(0));
        Assert.assertEquals((String)"'%20' should be decoded in map", (Object)" ", ((List)queryParameters.getParameters().get("q")).get(0));
        Assert.assertEquals((String)"'%26' and '%20' should not be decoded in query param string", (Object)"p=%26&q=%20", (Object)queryParameters.getQueryString());
    }

    @Test
    public void subLocation() {
        Location location = new Location(Arrays.asList("one", "two", "three"));
        Assert.assertEquals((Object)"one", (Object)location.getFirstSegment());
        Optional subLocation = location.getSubLocation();
        Assert.assertEquals(Arrays.asList("two", "three"), (Object)((Location)subLocation.get()).getSegments());
        Assert.assertEquals((Object)"two/three", (Object)((Location)subLocation.get()).getPath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyLocation() {
        new Location(Collections.emptyList());
    }

    @Test
    public void noSubLocation_emptyOptional() {
        Location location = new Location("foo");
        Optional maybeSubLocation = location.getSubLocation();
        Assert.assertFalse((boolean)maybeSubLocation.isPresent());
    }

    @Test
    public void spaceInLocation() {
        Location location = new Location("foo bar");
        Assert.assertEquals((Object)"foo bar", (Object)location.getFirstSegment());
    }

    @Test
    public void umlautInLocation() {
        Location location = new Location("foo/\u00e5\u00e4\u00f6/bar");
        Assert.assertEquals((Object)"foo", location.getSegments().get(0));
        Assert.assertEquals((Object)"\u00e5\u00e4\u00f6", location.getSegments().get(1));
        Assert.assertEquals((Object)"bar", location.getSegments().get(2));
    }

    @Test
    public void toggleTrailingSlash() {
        Assert.assertEquals((Object)"foo", (Object)new Location("foo/").toggleTrailingSlash().getPath());
        Assert.assertEquals((Object)"foo/", (Object)new Location("foo").toggleTrailingSlash().getPath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void toggleTrailingSlash_emtpyLocation() {
        new Location("").toggleTrailingSlash();
    }

    @Test
    public void locationWithParametersPath_emptyParams() {
        String initialPath = "foo/bar/";
        Location location = new Location(initialPath);
        String pathWithParameters = location.getPathWithQueryParameters();
        Assert.assertEquals((Object)initialPath, (Object)pathWithParameters);
        Assert.assertEquals((Object)location.getPath(), (Object)pathWithParameters);
    }

    @Test
    public void locationWithParametersPath_withTrailingSlash() {
        String initialPath = "foo/bar/";
        QueryParameters queryParams = LocationTest.getQueryParameters();
        Location location = new Location(initialPath, queryParams);
        String pathWithParameters = location.getPathWithQueryParameters();
        Assert.assertEquals((Object)(initialPath + "?" + queryParams.getQueryString()), (Object)pathWithParameters);
    }

    @Test
    public void locationWithParametersPath_withoutTrailingSlash() {
        String initialPath = "foo/bar";
        QueryParameters queryParams = LocationTest.getQueryParameters();
        Location location = new Location(initialPath, queryParams);
        String pathWithParameters = location.getPathWithQueryParameters();
        Assert.assertEquals((Object)(initialPath + "?" + queryParams.getQueryString()), (Object)pathWithParameters);
    }

    private static QueryParameters getQueryParameters() {
        HashMap<String, String[]> inputParameters = new HashMap<String, String[]>();
        inputParameters.put("one", new String[]{"1", "11"});
        inputParameters.put("two", new String[]{"2", "22"});
        inputParameters.put("three", new String[]{"3"});
        return QueryParameters.full(inputParameters);
    }

    @Test
    public void locationWithParamsInUrl() {
        String initialPath = "foo/bar/";
        QueryParameters queryParams = LocationTest.getQueryParameters();
        Location location = new Location(initialPath, queryParams);
        Assert.assertEquals((Object)"foo/bar/", (Object)location.getPath());
        Assert.assertEquals((Object)queryParams.getParameters(), (Object)location.getQueryParameters().getParameters());
    }

    @Test
    public void locationWithParamsInUrlAndParameters() {
        Location location = new Location("foo/bar/?one&two=222", LocationTest.getQueryParameters());
        Assert.assertEquals(Arrays.asList("foo", "bar", "?one&two=222"), (Object)location.getSegments());
        Assert.assertEquals((String)"Query parameters should be taken from the constructor parameter, not from path", (Object)"one=1&one=11&two=2&two=22&three=3", (Object)location.getQueryParameters().getQueryString());
    }

    @Test
    public void locationWithParamWithAndWithoutValue() {
        Location location = new Location("foo?param&param=bar");
        Assert.assertEquals((Object)"param&param=bar", (Object)location.getQueryParameters().getQueryString());
        location = new Location("foo?param=bar&param");
        Assert.assertEquals((Object)"param=bar&param", (Object)location.getQueryParameters().getQueryString());
    }

    @Test
    public void locationWithParamAndEmptyValue() {
        Location location = new Location("foo?param=&param=bar");
        Assert.assertEquals((Object)"param&param=bar", (Object)location.getQueryParameters().getQueryString());
    }

    @Test
    public void locationNameShouldBeAbleToHaveDotDot() {
        Location location = new Location("..element");
        Assert.assertEquals((Object)"..element", (Object)location.getFirstSegment());
        location = new Location("el..ement");
        Assert.assertEquals((Object)"el..ement", (Object)location.getFirstSegment());
    }

    @Test
    public void locationShouldBeRelative() {
        this.expectedEx.expect(InvalidLocationException.class);
        this.expectedEx.expectMessage("Relative path cannot contain .. segments");
        new Location("../element");
    }

    @Test
    public void locationShouldNotEndWithDotDotSegment() {
        this.expectedEx.expect(InvalidLocationException.class);
        this.expectedEx.expectMessage("Relative path cannot contain .. segments");
        new Location("element/..");
    }

    @Test
    public void dotDotLocationShouldNotWork() {
        this.expectedEx.expect(InvalidLocationException.class);
        this.expectedEx.expectMessage("Relative path cannot contain .. segments");
        new Location("..");
    }

    @Test
    public void pathShouldBeEmpty() {
        Assert.assertEquals((Object)"", (Object)new Location("").getPathWithQueryParameters());
    }

    @Test
    public void locationWithUrlEncodedCharacters() {
        Location location = new Location("foo?bar=a%20b%20%C3%B1%20%26%20%3F&baz=xyz");
        Assert.assertEquals(Arrays.asList("a b \u00f1 & ?"), location.getQueryParameters().getParameters().get("bar"));
        Assert.assertEquals(Arrays.asList("xyz"), location.getQueryParameters().getParameters().get("baz"));
        Assert.assertEquals((Object)"bar=a%20b%20%C3%B1%20%26%20%3F&baz=xyz", (Object)location.getQueryParameters().getQueryString());
    }

    @Test
    public void colonInLocationPath_locationIsParsed() {
        Location location = new Location("abc:foo/bar?baz");
        Assert.assertEquals((Object)"abc:foo/bar", (Object)location.getPath());
        Assert.assertEquals((Object)"baz", (Object)location.getQueryParameters().getQueryString());
    }

    @Test
    public void locationWithFragment_fragmentRetainedForPathWithQueryParameters() {
        String locationString = "foo#fragment";
        Location location = new Location(locationString);
        Assert.assertEquals((Object)locationString, (Object)location.getPathWithQueryParameters());
        locationString = "foo/#fragment";
        location = new Location(locationString);
        Assert.assertEquals((Object)locationString, (Object)location.getPathWithQueryParameters());
        locationString = "foo?bar#fragment";
        location = new Location(locationString);
        Assert.assertEquals((Object)locationString, (Object)location.getPathWithQueryParameters());
        locationString = "foo/?bar=baz#fragment";
        location = new Location(locationString);
        Assert.assertEquals((Object)locationString, (Object)location.getPathWithQueryParameters());
        locationString = "foo#";
        location = new Location(locationString);
        Assert.assertEquals((Object)locationString, (Object)location.getPathWithQueryParameters());
        locationString = "foo/?bar=baz#";
        location = new Location(locationString);
        Assert.assertEquals((Object)locationString, (Object)location.getPathWithQueryParameters());
    }
}

