/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.LocaleUtil;
import com.vaadin.flow.server.VaadinRequest;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class LocaleUtilTest {
    public static final Locale LOCALE_FI = new Locale("fi", "FI");
    public static final Locale LOCALE_EN = new Locale("en", "GB");
    @Mock
    VaadinRequest request;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.request.getLocales()).thenReturn(new Vector<Locale>(Arrays.asList(new Locale("fi"), LOCALE_EN)).elements());
    }

    @Test
    public void exact_match_provided_matches() {
        Optional exactLocaleMatch = LocaleUtil.getExactLocaleMatch((VaadinRequest)this.request, Arrays.asList(Locale.ENGLISH, LOCALE_EN));
        Assert.assertEquals((String)"Found wrong locale event though an exact match should have been available.", (Object)LOCALE_EN, exactLocaleMatch.get());
    }

    @Test
    public void no_exact_match_returns_null() {
        Optional exactLocaleMatch = LocaleUtil.getExactLocaleMatch((VaadinRequest)this.request, Arrays.asList(Locale.ENGLISH));
        Assert.assertFalse((String)"Found locale event though none should have been available.", (boolean)exactLocaleMatch.isPresent());
    }

    @Test
    public void language_match_gets_correct_target_by_request_priority() {
        Optional exactLocaleMatch = LocaleUtil.getLocaleMatchByLanguage((VaadinRequest)this.request, Arrays.asList(Locale.US, LOCALE_FI));
        Assert.assertEquals((String)"Found wrong locale event though an language match should have been available.", (Object)LOCALE_FI, exactLocaleMatch.get());
    }

    @Test
    public void language_match_returns_null_when_no_match() {
        Optional exactLocaleMatch = LocaleUtil.getLocaleMatchByLanguage((VaadinRequest)this.request, Arrays.asList(Locale.FRENCH, Locale.KOREA));
        Assert.assertFalse((String)"Found locale event though none should have been available.", (boolean)exactLocaleMatch.isPresent());
    }
}

