/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamResourceHandler;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StreamResourceHandlerTest {
    private StreamResourceHandler handler = new StreamResourceHandler();
    private MockVaadinSession session;
    private VaadinServletRequest request;
    private VaadinServletResponse response;

    @Before
    public void setUp() throws ServletException, ServiceException {
        MockVaadinServletService service = new MockVaadinServletService();
        this.session = new AlwaysLockedVaadinSession((VaadinService)service);
        this.request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)context);
        this.response = (VaadinServletResponse)Mockito.mock(VaadinServletResponse.class);
    }

    @Test
    public void inputStreamFactoryThrowsException_responseStatusIs500() throws IOException {
        StreamResource res = new StreamResource("readme.md", (InputStreamFactory & Serializable)() -> {
            throw new RuntimeException("Simulated-1");
        });
        try {
            this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, (VaadinResponse)this.response, res);
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)"Simulated-1", (Object)exception.getMessage());
        }
        ((VaadinServletResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void inputStreamResourceWriterThrows_responseStatusIs500() throws IOException {
        StreamResource res = new StreamResource("readme.md", (StreamResourceWriter & Serializable)(stream, session) -> {
            throw new RuntimeException("Simulated-2");
        });
        try {
            this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, (VaadinResponse)this.response, res);
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)"Simulated-2", (Object)exception.getMessage());
        }
        ((VaadinServletResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void inputStreamResourceWriterIsNull_responseStatusIs500() throws IOException {
        StreamResource res = new StreamResource("readme.md", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0])){

            public StreamResourceWriter getWriter() {
                return null;
            }
        };
        try {
            this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, (VaadinResponse)this.response, res);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((VaadinServletResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void inputStreamResourceWriterAndResponseThrows_streamResourceWriterExceptionIsPropagated() throws IOException {
        ServletOutputStream servletOutputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)servletOutputStream);
        ((ServletOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Error on close")}).when((Object)servletOutputStream)).close();
        StreamResource res = new StreamResource("readme.md", (StreamResourceWriter & Serializable)(stream, session) -> {
            throw new RuntimeException("Simulated-3");
        });
        try {
            this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, (VaadinResponse)this.response, res);
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)"Simulated-3", (Object)exception.getMessage());
        }
        ((VaadinServletResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
    }

    @Test
    public void inputStreamResourceHasHeader_headerIsWritten() throws IOException {
        StreamResource res = new StreamResource("readme.md", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0]));
        res.setHeader("foo", "bar");
        this.handler.handleRequest((VaadinSession)this.session, (VaadinRequest)this.request, (VaadinResponse)this.response, res);
        ((VaadinServletResponse)Mockito.verify((Object)this.response)).setHeader("foo", "bar");
    }
}

