/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.ResponseWriterTest;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Supplier;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class MockServletServiceSessionSetup {
    @Mock
    private ServletContext servletContext;
    @Mock
    private VaadinServletRequest request;
    @Mock
    private VaadinSession session;
    @Mock
    private WebBrowser browser;
    @Mock
    private WrappedHttpSession wrappedSession;
    @Mock
    private HttpSession httpSession;
    @Mock
    private ServletConfig servletConfig;
    @Mock
    private Lookup lookup;
    @Mock
    private ResourceProvider resourceProvider;
    private TestVaadinServlet servlet;
    private TestVaadinServletService service;
    private MockDeploymentConfiguration deploymentConfiguration = new MockDeploymentConfiguration();
    @Mock
    private StaticFileHandlerFactory staticFileHandlerFactory;

    public MockServletServiceSessionSetup() throws RuntimeException {
        this(true);
    }

    public MockServletServiceSessionSetup(boolean sessionAvailable) throws RuntimeException {
        MockitoAnnotations.initMocks((Object)this);
        this.servlet = this.createVaadinServlet();
        this.deploymentConfiguration.setXsrfProtectionEnabled(false);
        this.deploymentConfiguration.setProjectFolder(new File("./"));
        ((ServletContext)Mockito.doAnswer(invocation -> this.servletContext.getClass().getClassLoader()).when((Object)this.servletContext)).getClassLoader();
        Mockito.when((Object)this.servletConfig.getServletContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.servletContext.getAttribute(Lookup.class.getName())).thenReturn((Object)this.lookup);
        Mockito.when((Object)((ResourceProvider)this.lookup.lookup(ResourceProvider.class))).thenReturn((Object)this.resourceProvider);
        DefaultRoutePathProvider routePathProvider = new DefaultRoutePathProvider();
        Mockito.when((Object)((RoutePathProvider)this.lookup.lookup(RoutePathProvider.class))).thenReturn((Object)routePathProvider);
        Mockito.when((Object)((StaticFileHandlerFactory)this.lookup.lookup(StaticFileHandlerFactory.class))).thenReturn((Object)this.staticFileHandlerFactory);
        try {
            Mockito.when((Object)this.resourceProvider.getClientResourceAsStream("META-INF/resources/VAADIN/static/client/compile.properties")).thenAnswer(invocation -> new ByteArrayInputStream("jsFile=foo".getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Mockito.when((Object)this.resourceProvider.getApplicationResource(Mockito.anyString())).thenAnswer(invocation -> MockServletServiceSessionSetup.class.getResource("/" + String.valueOf(invocation.getArgument(0))));
        this.configureLookup(this.lookup);
        try {
            this.servlet.init(this.servletConfig);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        if (sessionAvailable) {
            Mockito.when((Object)this.session.getConfiguration()).thenReturn((Object)this.deploymentConfiguration);
            Mockito.when((Object)this.session.getBrowser()).thenReturn((Object)this.browser);
            Mockito.when((Object)this.session.getPushId()).thenReturn((Object)"fake push id");
            Mockito.when((Object)this.session.getLocale()).thenReturn((Object)Locale.ENGLISH);
            Mockito.when((Object)this.wrappedSession.getHttpSession()).thenReturn((Object)this.httpSession);
            Mockito.when((Object)this.session.getState()).thenReturn((Object)VaadinSessionState.OPEN);
            Mockito.when((Object)this.session.getService()).thenAnswer(i -> this.service);
            Mockito.when((Object)this.session.hasLock()).thenReturn((Object)true);
            Mockito.when((Object)this.session.getPendingAccessQueue()).thenReturn(new LinkedBlockingDeque());
            Mockito.when((Object)this.request.getWrappedSession()).thenReturn((Object)this.wrappedSession);
            SessionRouteRegistry sessionRegistry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)this.session);
            Mockito.when((Object)((SessionRouteRegistry)this.session.getAttribute(SessionRouteRegistry.class))).thenReturn((Object)sessionRegistry);
        } else {
            this.session = null;
        }
        CurrentInstance.set(VaadinRequest.class, (Object)this.request);
        CurrentInstance.set(VaadinService.class, (Object)((Object)this.service));
        if (sessionAvailable) {
            CurrentInstance.set(VaadinSession.class, (Object)this.session);
        }
        Mockito.when((Object)this.request.getServletPath()).thenReturn((Object)"");
    }

    public TestVaadinServlet createVaadinServlet() {
        return new TestVaadinServlet();
    }

    protected void configureLookup(Lookup lookup) {
    }

    public TestVaadinServletService getService() {
        return this.service;
    }

    public TestVaadinServlet getServlet() {
        return this.servlet;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public WrappedHttpSession getWrappedSession() {
        return this.wrappedSession;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public MockDeploymentConfiguration getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public WebBrowser getBrowser() {
        return this.browser;
    }

    public void cleanup() {
        CurrentInstance.clearAll();
    }

    public void setProductionMode(boolean productionMode) {
        this.deploymentConfiguration.setProductionMode(productionMode);
    }

    public void setAppShellRegistry(AppShellRegistry appShellRegistry) {
        Mockito.when((Object)this.servletContext.getAttribute(AppShellRegistry.AppShellRegistryWrapper.class.getName())).thenReturn((Object)new AppShellRegistry.AppShellRegistryWrapper(appShellRegistry));
    }

    public TestVaadinServletResponse createResponse() throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ResponseWriterTest.CapturingServletOutputStream out = new ResponseWriterTest.CapturingServletOutputStream();
        Mockito.when((Object)httpServletResponse.getOutputStream()).thenReturn((Object)out);
        return new TestVaadinServletResponse(httpServletResponse, this.getService());
    }

    public VaadinRequest createRequest(MockServletServiceSessionSetup mocks, String path, String queryString) {
        return this.createRequest(mocks, path, "", queryString);
    }

    public VaadinRequest createRequest(final MockServletServiceSessionSetup mocks, final String path, final String servletPath, String queryString) {
        QueryParameters queryParams = QueryParameters.fromString((String)queryString);
        final Map params = queryParams.getParameters();
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        return new VaadinServletRequest(this, httpServletRequest, mocks.getService()){

            public String getPathInfo() {
                return path;
            }

            public String getServletPath() {
                return servletPath;
            }

            public ServletContext getServletContext() {
                return mocks.getServletContext();
            }

            public String getParameter(String name) {
                if (!params.containsKey(name)) {
                    return null;
                }
                return (String)((List)params.get(name)).get(0);
            }

            public StringBuffer getRequestURL() {
                return new StringBuffer("http://localhost:8888" + servletPath + this.getPathInfo());
            }
        };
    }

    public class TestVaadinServlet
    extends VaadinServlet {
        protected VaadinServletService createServletService() throws ServletException, ServiceException {
            MockServletServiceSessionSetup.this.service = this.createTestVaadinServletService();
            MockServletServiceSessionSetup.this.service.init();
            return MockServletServiceSessionSetup.this.service;
        }

        public TestVaadinServletService createTestVaadinServletService() {
            return new TestVaadinServletService(this, (DeploymentConfiguration)MockServletServiceSessionSetup.this.deploymentConfiguration);
        }

        public ServletContext getServletContext() {
            return MockServletServiceSessionSetup.this.servletContext;
        }

        public void addServletContextResource(String path) {
            this.addServletContextResource(path, "This is " + path);
        }

        public void addServletContextResource(String path, final String contents) {
            try {
                final Supplier<InputStream> streamSupplier = new Supplier<InputStream>(){

                    @Override
                    public InputStream get() {
                        return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
                    }
                };
                URL url = new URL(null, "file://" + path, new URLStreamHandler(this){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return (InputStream)streamSupplier.get();
                            }
                        };
                    }
                });
                Mockito.when((Object)this.getServletContext().getResource(path)).thenReturn((Object)url);
                Mockito.when((Object)this.getServletContext().getResourceAsStream(path)).thenAnswer(arg_0 -> TestVaadinServlet.lambda$addServletContextResource$0((Supplier)streamSupplier, arg_0));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public void addWebJarResource(String webjarContent) {
            this.addServletContextResource("/webjars/" + webjarContent);
        }

        public void verifyServletContextResourceLoadedOnce(String resource) {
            ((ServletContext)Mockito.verify((Object)MockServletServiceSessionSetup.this.servlet.getServletContext())).getResourceAsStream(resource);
        }

        public void verifyServletContextResourceNotLoaded(String resource) {
            ((ServletContext)Mockito.verify((Object)MockServletServiceSessionSetup.this.servlet.getServletContext(), (VerificationMode)Mockito.never())).getResourceAsStream(resource);
        }

        private static /* synthetic */ Object lambda$addServletContextResource$0(Supplier streamSupplier, InvocationOnMock i) throws Throwable {
            return streamSupplier.get();
        }
    }

    public class TestVaadinServletService
    extends VaadinServletService {
        private List<DependencyFilter> dependencyFilterOverride;
        private TestRouteRegistry routeRegistry;
        private Router router;
        private List<IndexHtmlRequestListener> indexHtmlRequestListeners;
        private VaadinContext context;
        private List<RequestHandler> handlers;
        private Instantiator overriddenInstantiator;

        public TestVaadinServletService(TestVaadinServlet testVaadinServlet, DeploymentConfiguration deploymentConfiguration) {
            super((VaadinServlet)testVaadinServlet, deploymentConfiguration);
            this.indexHtmlRequestListeners = new ArrayList<IndexHtmlRequestListener>();
        }

        public Iterable<DependencyFilter> getDependencyFilters() {
            if (this.dependencyFilterOverride != null) {
                return this.dependencyFilterOverride;
            }
            return super.getDependencyFilters();
        }

        public void setDependencyFilters(List<DependencyFilter> dependencyFilters) {
            this.dependencyFilterOverride = dependencyFilters;
        }

        public void setRouteRegistry(TestRouteRegistry routeRegistry) {
            this.routeRegistry = routeRegistry;
        }

        protected List<RequestHandler> createRequestHandlers() throws ServiceException {
            List requestHandlers;
            this.handlers = requestHandlers = super.createRequestHandlers();
            return requestHandlers;
        }

        public List<RequestHandler> getRequestHandlers() {
            return this.handlers;
        }

        protected RouteRegistry getRouteRegistry() {
            if (this.routeRegistry != null) {
                return this.routeRegistry;
            }
            return super.getRouteRegistry();
        }

        public Router getRouter() {
            if (this.router != null) {
                return this.router;
            }
            return super.getRouter();
        }

        public void setRouter(Router router) {
            this.router = router;
        }

        public void addIndexHtmlRequestListener(IndexHtmlRequestListener listener) {
            this.indexHtmlRequestListeners.add(listener);
        }

        public void modifyIndexHtmlResponse(IndexHtmlResponse response) {
            this.indexHtmlRequestListeners.forEach(listener -> listener.modifyIndexHtmlResponse(response));
            super.modifyIndexHtmlResponse(response);
        }

        public VaadinContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            return super.getContext();
        }

        public void setContext(VaadinContext context) {
            this.context = context;
        }

        protected Instantiator createInstantiator() throws ServiceException {
            return (Instantiator)Mockito.spy((Object)super.createInstantiator());
        }

        public Instantiator getInstantiator() {
            if (this.overriddenInstantiator != null) {
                return this.overriddenInstantiator;
            }
            return super.getInstantiator();
        }

        public void setInstantiator(Instantiator instantiator) {
            this.overriddenInstantiator = instantiator;
        }
    }

    public static class TestVaadinServletResponse
    extends VaadinServletResponse {
        private int errorCode;
        private String errorMessage;
        private ResponseWriterTest.CapturingServletOutputStream output = new ResponseWriterTest.CapturingServletOutputStream();
        private String type;

        private TestVaadinServletResponse(HttpServletResponse response, VaadinServletService vaadinService) {
            super(response, vaadinService);
        }

        public void sendError(int errorCode, String message) throws IOException {
            this.errorCode = errorCode;
            this.errorMessage = message;
        }

        public void sendError(int sc) throws IOException {
            this.errorCode = sc;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setStatus(int sc) {
            this.errorCode = sc;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.output;
        }

        public String getPayload() {
            return new String(this.output.getOutput());
        }

        public void setContentType(String type) {
            this.type = type;
        }

        public String getContentType() {
            return this.type;
        }
    }
}

