/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class ListChangeTest {
    private NodeList<StateNode> feature = (NodeList)AbstractNodeFeatureTest.createFeature(ElementChildrenList.class);

    @Test
    public void testBasicJson() {
        StateNode child1 = StateNodeTest.createEmptyNode("child1");
        StateNode child2 = StateNodeTest.createEmptyNode("child2");
        ListAddChange change = new ListAddChange(this.feature, true, 0, Arrays.asList(child1, child2));
        ObjectNode json = change.toJson(null);
        Assert.assertEquals((long)change.getNode().getId(), (long)json.get("node").intValue());
        Assert.assertEquals((long)NodeFeatureRegistry.getId(this.feature.getClass()), (long)json.get("feat").intValue());
        Assert.assertEquals((Object)"splice", (Object)json.get("type").textValue());
        Assert.assertEquals((long)0L, (long)json.get("index").intValue());
        ArrayNode addNodes = (ArrayNode)json.get("addNodes");
        Assert.assertEquals((long)2L, (long)addNodes.size());
        Assert.assertEquals((long)child1.getId(), (long)addNodes.get(0).intValue());
        Assert.assertEquals((long)child2.getId(), (long)addNodes.get(1).intValue());
    }

    @Test
    public void testZeroRemoveNotInJson() {
        ListAddChange change = new ListAddChange(this.feature, false, 1, Arrays.asList(new StateNode[0]));
        ObjectNode json = change.toJson(null);
        Assert.assertFalse((boolean)json.has("remove"));
    }

    @Test
    public void testEmptyAddNotInJson() {
        ListAddChange change = new ListAddChange(this.feature, false, 1, Arrays.asList(new StateNode[0]));
        ObjectNode json = change.toJson(null);
        Assert.assertFalse((boolean)json.has("addNodes"));
    }
}

